#ifndef _BRLD_H
#define _BRLD_H
#define MAX_AUTH_KEY 32+1	/* maximum length of auth-string (32 chars = 512bit) */
#define MAX_BUF_LEN 800		/* maximum length of recv-buffer */
#define MAX_BRLTEXT_LEN 120	/* maximum length of braille-text */
#define MAX_PATH_LEN 100
#define MAX_PORT_LEN 50
#define MAX_ALIAS_LEN 20
#define DEFAULT_AUTH_KEY "default"
#define DEFAULT_BRLD_PORT 8888

/* registration modes */
#define TEXT  1
#define X11   2
#define ADMIN 3

/* braille cursor forms */
#define BLOCK_CSR     0xff
#define UNDERLINE_CSR 0xc0

/* config file */
typedef struct
{
  char brlalias[MAX_ALIAS_LEN];
  char brlport[MAX_PORT_LEN];
  int brld_port;
  char auth_key[MAX_AUTH_KEY];
  char brltbl[MAX_PATH_LEN];
  char progpath[MAX_PATH_LEN];
} brld_config;

/* info structure for brailledisplays */
struct brlinfo
{
  char name[50];
  char fullname[80];
  int cols;
  int st_cells;
  int offvert;
  int offhor;
  int baud;
};

typedef struct
{
  int brl_fd;
  unsigned char *disp;		/* display content */
  int x, y;			/* display size */
}
brldim;				/* used for writing to a braille display */

/* driver structure */
typedef struct
{
  char *identifier;		/* name of driver */
/* Routines provided by the braille driver library: */
  struct brlinfo (*identify) (const char *, const char *);	/* print start-up messages */
  void (*debug) (unsigned int dbg);
  void (*initialize) (brldim *, const char *);	/* initialise Braille display */
  void (*close) (brldim *);	/* close braille display */
  void (*write) (brldim *);	/* write to braille display */
  int (*read) (int *);		/* get key press from braille display */
  void (*setstatus) (const unsigned char *);	/* set status cells */

}
braille_driver;

int load_braille_driver (char *libname);
void unload_braille_driver ();

#endif
