/*****************************************************************************
 ** Class DVDLayout::Router
 **
 ** This class handles the display area for the DVD Layout tab.
 **
 **   Created : March 24 2009
 **        by : Varol Okan
 ** Copyright : (c) Varol Okan
 ** License   : GPL v 2.0
 **
 *****************************************************************************
 ** The DVD Layout must handle
 ** o DVDMenuObjects
 ** o MovieObjects
 ** o FirstObject ( FPC )
 ** o PreObjects / PostObjects
 *****************************************************************************/

#ifndef DVDLAYOUTROUTER_H
#define DVDLAYOUTROUTER_H

#include "dvdlayoutarea.h"

namespace DVDLayout
{

class LinearRouter
{
public:
  LinearRouter ( );
  virtual ~LinearRouter  ( );

  virtual QValueList<Area::PieceOfLine *> route ( QPoint, QPoint, Area::Container::Connection * );
};

class OthogonalRouter : public LinearRouter
{
  const int iSPACE;
  const int iDELTA;
public:
  OthogonalRouter ( );
  virtual ~OthogonalRouter  ( );

  virtual QValueList<Area::PieceOfLine *> route ( QPoint, QPoint, Area::Container::Connection * );

protected:
  QPoint routeBottomToBottomBelowTarget ( QPoint, QPoint, Area::Container::Connection * );
  QPoint routeBottomBelowTarget         ( QPoint, QPoint, Area::Container::Connection * );
  QPoint routeBottomToBottom            ( QPoint, QPoint, Area::Container::Connection * );
  QPoint routeBottom                    ( QPoint, QPoint, Area::Container::Connection * );
  QPoint routeSide                      ( QPoint, QPoint, Area::Container::Connection * );
  QPoint routeSideToBottom              ( QPoint, QPoint, Area::Container::Connection * );
  QPoint routeSideBelowTarget           ( QPoint, QPoint, Area::Container::Connection * );

private:
  QValueList<Area::PieceOfLine *> m_listLines;

};

}; // End of namespace DVDLayout

#endif // DVDLAYOUTROUTER_H
