<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Support suEXEC - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.2</a></div><div id="page-content"><div id="preamble"><h1>Support suEXEC</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/suexec.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/suexec.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/suexec.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/suexec.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/suexec.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>La fonctionnalit <strong>suEXEC</strong> permet
    l'excution des programmes <strong>CGI</strong> et
    <strong>SSI</strong> sous un identifiant utilisateur autre que celui sous
    lequel s'excute le serveur web qui appelle ces programmes.
    Normalement, lorsqu'un programme CGI ou SSI est lanc, il
    s'excute sous le mme identifiant utilisateur que celui du serveur web qui
    l'appelle.</p>

    <p>Utilise de manire approprie, cette fonctionnalit peut
    rduire considrablement les risques de scurit encourus
    lorsqu'on autorise les utilisateurs  dvelopper et faire
    s'excuter des programmes CGI ou SSI de leur cru. Cependant, mal
    configur, suEXEC peut causer de nombreux problmes et mme crer
    de nouvelles failles dans la scurit de votre ordinateur. Si
    vous n'tes pas familier avec la gestion des programmes
    <em>setuid root</em> et les risques de scurit qu'ils comportent,
    nous vous recommandons vivement de ne pas tenter
    d'utiliser suEXEC.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#before">Avant de commencer</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#model">Modle de scurit de suEXEC</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#install">Configurer et installer suEXEC</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#enable">Activation et dsactivation
de suEXEC</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#usage">Utilisation de suEXEC</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#debug">Dbogage de suEXEC</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#jabberwock">Avis  la population !
    Avertissements et exemples</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="before" id="before">Avant de commencer</a></h2>

    <p>Avant de foncer tte baisse dans la lecture de ce document,
    vous devez tenir compte des hypothses faites par le Groupe
    Apache et dans ce document.</p>

    <p>Premirement, vous devez utiliser un systme d'exploitation
    UNIX ou driv, capable d'effectuer des oprations
    <strong>setuid</strong> et <strong>setgid</strong>. Tous les
    exemples de commande sont fournis dans ce context. D'autres
    plates-formes, mme si elles supportent suEXEC, peuvent
    prsenter une configuration diffrente.</p>

    <p>Deuximement, vous devez tre familier avec les concepts de base
    relatifs  la scurit de votre ordinateur et son administration.
    Ceci implique la comprhension des oprations
    <strong>setuid/setgid</strong> et des diffrents effets qu'elles
    peuvent produire sur votre systme et son niveau de scurit.</p>

    <p>Troisimement, vous devez utiliser une version
    <strong>non modifie</strong> du code de suEXEC. L'ensemble du
    code de suEXEC a t scrut et test avec soin par les dveloppeurs
    et de nombreux bta testeurs. Toutes les prcautions ont t prises
    pour s'assurer d'une base sre de code non seulement simple, mais
    aussi solide. La modification de ce code peut causer des problmes
    inattendus et de nouveaux risques de scurit. Il est
    <strong>vivement</strong> recommand de ne pas modifier le code de
    suEXEC,  moins que vous ne soyez un programmeur spcialiste des
    particularits lies  la scurit, et souhaitez partager votre
    travail avec le Groupe Apache afin de pouvoir en discuter.</p>

    <p>Quatrimement et dernirement, le Groupe Apache a dcid de ne
    <strong>PAS</strong> inclure suEXEC dans l'installation par dfaut
    d'Apache. Pour pouvoir mettre en oeuvre suEXEC, l'administrateur
    doit porter la plus grande attention aux dtails. Aprs avoir bien
    rflchi aux diffrents points de la configuration de suEXEC,
    l'administrateur peut l'installer selon les mthodes classiques.
    Le choix de chaque paramtre de configuration doit tre
    dtermin et spcifi avec soin par l'administrateur, afin de
    maintenir la scurit du systme de manire approprie lors de
    l'utilisation de la fonctionnalit suEXEC. C'est par le biais de
    ce processus minutieux que le Groupe Apache espre rserver
    l'installation de suEXEC aux administrateurs prudents et
    suffisamment dtermins  vouloir l'utiliser.</p>

    <p>Vous tes encore avec nous ? Oui ? Bien.
    Alors nous pouvons continuer !</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="model" id="model">Modle de scurit de suEXEC</a></h2>

    <p>Avant d'installer et configurer suEXEC, nous allons tout d'abord
    dcrire le modle de scurit que vous tes sur le point
    d'implmenter. Vous devriez ainsi mieux comprendre ce qui se passe
    vraiment  l'intrieur de suEXEC et quelles prcautions ont t
    prises pour prserver la scurit de votre systme.</p>

    <p><strong>suEXEC</strong> est bas sur un programme "conteneur"
    (wrapper) setuid qui est appel par le serveur web Apache principal.
    Ce conteneur est appel quand une requte HTTP concerne
    un programme CGI ou SSI que l'administrateur
    a dcid de faire s'excuter
    sous un utilisateur autre que celui du serveur principal.
    Lorsqu'il reoit une telle requte, Apache fournit au conteneur
    suEXEC le nom du programme, ainsi que les identifiants utilisateur
    et groupe sous lesquels le programme doit s'excuter.</p>

    <p>Le conteneur effectue ensuite les vrifications suivantes afin
    de dterminer la russite ou l'chec du processus -- si une seule
    de ces conditions n'est pas vrifie, le programme journalise
    l'erreur et se termine en retournant un code d'erreur, sinon il
    continue :</p>

    <ol>
      <li>
        <strong>L'utilisateur qui excute le conteneur est-il un
	utilisateur valide de ce systme ?</strong>

        <p class="indent">
          Ceci permet de s'assurer que l'utilisateur qui excute le
	  conteneur est vraiment un utilisateur appartenant au systme.
        </p>
     </li>

     <li>
        <strong>Le conteneur a-t-il t appel avec un nombre
	d'arguments correct ?</strong>

        <p class="indent">
          Le conteneur ne s'excutera que si on lui fournit un nombre
	  d'arguments correct. Le serveur web apache sait quel est le
	  bon format des arguments. Si le conteneur ne reoit pas un
	  nombre d'arguments correct, soit il a t modifi,
	  soit quelque chose ne va pas dans la portion suEXEC de
	  votre binaire Apache.
        </p>
      </li>

      <li>
        <strong>Cet utilisateur valide est-il autoris  excuter le
	conteneur ?</strong>

        <p class="indent">
          Cet utilisateur est-il celui autoris  excuter le
	  conteneur ? Un seul utilisateur (celui d'Apache) est
	  autoris  excuter ce programme.
        </p>
      </li>

      <li>
        <strong>Le chemin du programme CGI ou SSI cible est-il
	non sr ?</strong>

        <p class="indent">
          Le chemin du programme CGI ou SSI cible dbute-t-il par un
	  '/' ou contient-il une rfrence arrire '..' ? Ceci est
	  interdit ; le programme CGI ou SSI cible doit se trouver dans
	  la hirarchie de la racine des documents de suEXEC (voir
	  <code>--with-suexec-docroot=<em>DIR</em></code> ci-dessous).
        </p>
      </li>

      <li>
        <strong>Le nom utilisateur cible est-il valide ?</strong>

        <p class="indent">
          L'utilisateur cible existe-t-il ?
        </p>
      </li>

      <li>
        <strong>Le nom du groupe cible est-il valide ?</strong>

        <p class="indent">
          Le groupe cible existe-t-il ?
        </p>
      </li>

      <li>
        <strong>L'utilisateur cible n'est-il <em>PAS</em>
	superutilisateur ?</strong>


        <p class="indent">
          suEXEc ne permet pas 
	  <code><em>root</em></code> d'excuter des programmes CGI/SSI.
        </p>
      </li>

      <li>
        <strong>Le numro de l'identifiant de l'utilisateur cible
	est-il <em>SUPERIEUR</em> au numro d'identifiant
	minimum ?</strong>

        <p class="indent">
          Le numro d'identifiant utilisateur minimum est dfini 
	  l'excution du script configure. Ceci vous permet de dfinir
	  le numro d'identifiant utilisateur le plus bas qui sera
	  autoris  xcuter des programmes CGI/SSI. En particulier,
	  cela permet d'carter les comptes systme.
        </p>
      </li>

      <li>
        <strong>Le groupe cible n'est-il <em>PAS</em> le groupe
	superutilisateur ?</strong>

        <p class="indent">
          Actuellement, suEXEC ne permet pas au groupe
	  <code><em>root</em></code> d'excuter des programmes CGI/SSI.
        </p>
      </li>

      <li>
        <strong> Le numro d'identifiant du groupe cible est-il
	<em>SUPERIEUR</em> au numro d'identifiant minimum ?</strong>

        <p class="indent">
          Le numro d'identifiant de groupe minimum est spcifi lors
	  de l'excution du script configure. Ceci vous permet de
	  dfinir l'identifiant de groupe le plus bas possible qui sera
	  autoris  excuter des programmes CGI/SSI, et est
	  particulirement utile pour carter les groupes "systme".
        </p>
      </li>

      <li>
        <strong>Le conteneur peut-il obtenir avec succs l'identit
	des utilisateur et groupe cibles ?</strong>

        <p class="indent">
          C'est ici que le programme obtient l'identit des utilisateur
	  et groupe cibles via des appels  setuid et setgid. De mme,
	  la liste des accs groupe est initialise avec tous les
	  groupes auxquels l'utilisateur cible appartient.
        </p>
      </li>

      <li>
        <strong>Peut-on se positionner dans le rpertoire dans dequel
	sont situs les programmes CGI/SSI ?</strong>

        <p class="indent">
          S'il n'existe pas, il ne peut pas contenir de fichier. Et si
	  l'on ne peut pas s'y positionner, il n'existe probablement
	  pas.
        </p>
      </li>

      <li>
        <strong>Le rpertoire est-il dans l'espace web
	d'Apache ?</strong>

        <p class="indent">
          Si la requte concerne une portion de la racine du serveur,
	  le rpertoire demand est-il dans la hirarchie de la racine
	  des documents de suEXEC ? Si la requte concerne un
	 <code class="directive"><a href="./mod/mod_userdir.html#userdir">UserDir</a></code>, le
         rpertoire demand est-il dans la hirarchie du rpertoire
         dfini comme le rpertoire utilisateur de suEXEC (voir les
	  <a href="#install">options de configuration de suEXEC</a>) ?
        </p>
      </li>

      <li>
        <strong>L'criture dans le rpertoire est-elle interdite pour
	un utilisateur autre que le propritaire ?</strong>

        <p class="indent">
          Le rpertoire ne doit pas tre ouvert aux autres
	  utilisateurs ; seul l'utilisateur propritaire doit pouvoir
	  modifier le contenu du rpertoire.
        </p>
      </li>

      <li>
        <strong>Le programme CGI/SSI cible existe-t-il ?</strong>

        <p class="indent">
          S'il n'existe pas, il ne peut pas tre excut.
        </p>
      </li>

      <li>
        <strong>Les utilisateurs autres que le propritaire n'ont-ils
	<em>PAS</em> de droits en criture sur le programme
	CGI/SSI ?</strong>

        <p class="indent">
          Les utilisateurs autres que le propritaire ne doivent pas
	  pouvoir modifier le programme CGI/SSI.
        </p>
      </li>

      <li>
        <strong>Le programme CGI/SSI n'est-il <em>PAS</em> setuid ou
	setgid ?</strong>

        <p class="indent">
          Les programmes cibles ne doivent pas pouvoir modifier 
	  nouveau les identifiants utilisateur/groupe.
        </p>
      </li>

      <li>
        <strong>Le couple utilisateur/groupe cible est-il le mme que
	celui du programme ?</strong>

        <p class="indent">
          L'utilisateur est-il le propritaire du fichier ?
        </p>
      </li>

      <li>
        <strong>Peut-on nettoyer avec succs l'environnement des
	processus afin de garantir la sret des oprations ?</strong>

        <p class="indent">
          suExec nettoie l'environnement des processus en tablissant
	  un chemin d'excution sr (dfini lors de la configuration),
	  et en ne passant que les variables dont les noms font partie
	  de la liste de l'environnement sr (cre de mme lors de la
	  configuration).
        </p>
      </li>

      <li>
        <strong>Le conteneur peut-il avec succs se substituer au
	programme CGI/SSI cible et s'excuter ?</strong>

        <p class="indent">
          C'est l o l'excution de suEXEC s'arrte et o commence
	  celle du programme CGI/ssi cible.
        </p>
      </li>
    </ol>

    <p>Ce sont les oprations standards effectues par le modle de
    scurit du conteneur suEXEC. Il peut paratre strict et est
    susceptible d'imposer de nouvelles limitations et orientations
    dans la conception des programmes CGI/SSI, mais il a t dvelopp
    avec le plus grand soin, tape par tape, en se focalisant sur
    la scurit.</p>

    <p>Pour plus d'informations sur la mesure dans laquelle ce modle
    de scurit peut limiter vos possibilits au regard de la
    configuration du serveur, ainsi que les risques de scurit qui
    peuvent tre vits grce  une configuration approprie de suEXEC,
    se rfrer  la section <a href="#jabberwock">"Avis  la population !"</a> de ce document.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="install" id="install">Configurer et installer suEXEC</a></h2>

    <p>C'est ici que nous entrons dans le vif du sujet.</p>

    <p><strong>Options de configuration de suEXEC</strong><br />
    </p>

    <dl>
      <dt><code>--enable-suexec</code></dt>

      <dd>Cette option active la fonctionnalit suEXEC qui n'est
      jamais installe ou active par dfaut. Au moins une option
      <code>--with-suexec-xxxxx</code> doit accompagner l'option
      <code>--enable-suexec</code> pour qu'APACI (l'utilitaire de
      configuration de la compilation d'Apache) accepte votre demande
      d'utilisation de la fonctionnalit suEXEC.</dd>

      <dt><code>--with-suexec-bin=<em>PATH</em></code></dt>

      <dd>Le chemin du binaire <code>suexec</code> doit tre cod en
      dur dans le serveur pour des raisons de scurit. Cette option
      vous permet de modifier le chemin par dfaut.
      <em>Par exemple</em>
      <code>--with-suexec-bin=/usr/sbin/suexec</code></dd>

      <dt><code>--with-suexec-caller=<em>UID</em></code></dt>

      <dd>L'<a href="mod/mpm_common.html#user">utilisateur</a> sous
      lequel Apache s'excute habituellement. C'est le seul utilisateur
      autoris  utiliser suexec.</dd>

      <dt><code>--with-suexec-userdir=<em>DIR</em></code></dt>

      <dd>Cette option dfinit le sous-rpertoire de la hirarchie des
      rpertoires utilisateurs dans lequel l'utilisation
      de suEXEC sera autorise. Tous les excutables situs dans ce
      rpertoire seront excutables par suEXEC sous l'utilisateur
      cible ; ces programmes doivent donc tre srs. Si vous utilisez
      une directive <code class="directive"><a href="./mod/mod_userdir.html#userdir">UserDir</a></code>
      "simple" (c'est  dire ne contenant pas de
      "*"), l'option --with-suexec-userdir
      devra contenir la mme valeur. suEXEC ne fonctionnera pas
      correctement si la directive <code class="directive"><a href="./mod/mod_userdir.html#userdir">UserDir</a></code> contient une valeur
      diffrente du rpertoire home de l'utilisateur tel qu'il est
      dfini dans le fichier <code>passwd</code>. la valeur par dfaut
      est "<code>public_html</code>".<br />
      Si vous avez plusieurs htes virtuels avec une directive
      <code class="directive"><a href="./mod/mod_userdir.html#userdir">UserDir</a></code> diffrente
      pour chacun d'entre eux, vous devrez faire en sorte que chaque
      UserDir possde un rpertoire parent commun ; donnez alors 
      l'option --with-suexec-userdir le nom
      de ce rpertoire commun. <strong>Si tout ceci n'est pas dfini
      correctement, les requtes CGI "~userdir" ne fonctionneront
      pas !</strong></dd>

      <dt><code>--with-suexec-docroot=<em>DIR</em></code></dt>

      <dd>Cette option fonctionne comme la directive DocumentRoot pour
      Apache. Il s'agit de la seule hirarchie (en dehors des directives
      <code class="directive"><a href="./mod/mod_userdir.html#userdir">UserDir</a></code>) dans laquelle la fonctionnalit suEXEC
      pourra tre utilise. La valeur par dfaut est la valeur de
      <code>--datadir</code> accompagne du suffixe
      "<code>/htdocs</code>" ;
      <em>Par exemple</em>, si vous excutez configure avec
      "<code>--datadir=/home/apache</code>", la valeur
      "<code>/home/apache/htdocs</code>" sera utilise par dfaut comme
      racine des documents pour le conteneur suEXEC.</dd>

      <dt><code>--with-suexec-uidmin=<em>UID</em></code></dt>

      <dd>Cette option dfinit l'identifiant utilisateur le plus bas
      avec lequel un utilisateur pourra tre la cible de
      suEXEC. 500 ou 100 sont des valeurs courantes sur la plupart des
      systmes. la valeur par dfaut est 100.</dd>

      <dt><code>--with-suexec-gidmin=<em>GID</em></code></dt>

      <dd>Cette option dfinit l'identifiant de groupe le plus bas
      avec lequel un utilisateur pourra tre la cible de
      suEXEC. 100 est une valeur courante sur la plupart des
      systmes et est par consquent la valeur par dfaut.</dd>

      <dt><code>--with-suexec-logfile=<em>FILE</em></code></dt>

      <dd>Cette option permet de dfinir le fichier dans lequel
      toutes les transactions et erreurs de suEXEC seront journalises
      ( des fins d'analyse ou de dbogage). Par dfaut, le fichier
      journal se nomme "<code>suexec_log</code>" et se trouve dans votre
      rpertoire standard des fichiers journaux dfini par
      <code>--logfiledir</code></dd>

      <dt><code>--with-suexec-safepath=<em>PATH</em></code></dt>

      <dd>Cette option permet de dfinir une variable d'environnement
      PATH sre  passer aux excutables CGI. La valeur par dfaut
      est "<code>/usr/local/bin:/usr/bin:/bin</code>".</dd>
    </dl>

    <h3>Compilation et installation du conteneur suEXEC</h3>
      

    <p>Si vous avez activ la fonctionnalit suEXEC  l'aide de
     l'option <code>--enable-suexec</code>, le binaire
     <code>suexec</code> sera automatiquement construit (en mme temps
     qu'Apache) lorsque vous excuterez la comande
     <code>make</code>.</p>

     <p>Lorsque tous les composants auront t construits, vous pourrez
     excuter la commande <code>make install</code> afin de les
     installer. Le binaire <code>suexec</code> sera install dans le
     rpertoire dfini  l'aide de l'option <code>--sbindir</code>. La
     localisation par dfaut est "/usr/local/apache2/bin/suexec".</p>
     <p>Veuillez noter que vous aurez besoin des
     <strong><em>privilges root</em></strong> pour passer l'tape de
     l'installation. Pour que le conteneur puisse changer
     l'identifiant utilisateur, il doit avoir comme propritaire
     <code><em>root</em></code>, et les droits du fichier doivent
     inclure le bit d'excution setuserid.</p>
   

   <h3>&gt;Mise en place de permissions pour
    paranoaque</h3>
	
    <p>Bien que le conteneur suEXEC vrifie que l'utilisateur qui
    l'appelle correspond bien  l'utilisateur spcifi  l'aide de
    l'option <code>--with-suexec-caller</code> du programme
    <code class="program"><a href="./programs/configure.html">configure</a></code>, il subsiste toujours le risque qu'un
    appel systme ou une bibliothque fasse appel  suEXEC avant que
    cette vrification ne soit exploitable sur votre systme. Pour
    tenir compte de ceci, et parce que c'est en gnral la meilleure
    pratique, vous devez utiliser les permissions du systme de
    fichiers afin de vous assurer que seul le groupe sous lequel
    s'excute Apache puisse faire appel  suEXEC.</p>

    <p>Si, par exemple, votre serveur web est configur pour
    s'excuter en tant que :</p>

<div class="example"><p><code>
    User www<br />
    Group webgroup<br />
</code></p></div>

    <p>et <code class="program"><a href="./programs/suexec.html">suexec</a></code> se trouve 
    "/usr/local/apache2/bin/suexec", vous devez excuter les
    commandes</p>

<div class="example"><p><code>
    chgrp webgroup /usr/local/apache2/bin/suexec<br />
    chmod 4750 /usr/local/apache2/bin/suexec<br />
</code></p></div>

    <p>Ceci permet de s'assurer que seul le groupe sous lequel Apache
    s'excute (ici webgroup) puisse faire appel au conteneur
    suEXEC.</p>
  
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="enable" id="enable">Activation et dsactivation
de suEXEC</a></h2>

    <p>Au dmarrage, Apache vrifie la prsence du fichier
    <code class="program"><a href="./programs/suexec.html">suexec</a></code> dans le rpertoire dfini par
    l'option <code>--sbindir</code> du script configure (le
    rpertoire par dfaut est "/usr/local/apache/sbin/suexec"). Si
    Apache trouve un conteneur suEXEC correctement configur, il
    enregistrera le message suivant dans le journal des erreurs :</p>

<div class="example"><p><code>
    [notice] suEXEC mechanism enabled (wrapper: <var>/path/to/suexec</var>)
</code></p></div>

    <p>Si ce message n'est pas gnr au dmarrage du serveur, ce
    dernier ne trouve probablement pas le programme conteneur 
    l'endroit o il est sens tre, ou l'excutable suexec n'est pas
    install en <em>setuid root</em>.</p>

     <p>Si le serveur Apache est dj en cours d'excution, et si
     vous activez le mcanisme suEXEC pour la premire fois, vous
     devez arrter et redmarrer Apache. Un redmarrage
      l'aide d'un simple signal HUP ou USR1 suffira. </p>
     <p>Pour dsactiver suEXEC, vous devez supprimer le fichier
     <code class="program"><a href="./programs/suexec.html">suexec</a></code>, puis arrter et redmarrer
     Apache.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="usage" id="usage">Utilisation de suEXEC</a></h2>

    <p>Les requtes pour des programmes CGI ne feront appel au
    conteneur suEXEC que si elles concernent un hte virtuel
    contenant une directive <code class="directive"><a href="./mod/mod_suexec.html#suexecusergroup">SuexecUserGroup</a></code>, ou si elles sont
    traites par <code class="module"><a href="./mod/mod_userdir.html">mod_userdir</a></code>.</p>

    <p><strong>Htes virtuels :</strong><br /> Une des mthodes
    d'utilisation du conteneur suEXEC consiste  insrer une
    directive <code class="directive"><a href="./mod/mod_suexec.html#suexecusergroup">SuexecUserGroup</a></code> dans une section
    <code class="directive"><a href="./mod/core.html#virtualhost">VirtualHost</a></code>. En dfinissant
    des valeurs diffrentes de celles du serveur principal, toutes les
    requtes pour des ressources CGI seront excutes sous
    les <em>User</em> et <em>Group</em> dfinis pour cette section
    <code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>. Si cette
    directive est absente de la section <code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>, l'utilisateur du
    serveur principal sera pris par dfaut</p>

    <p><strong>Rpertoires des utilisateurs :</strong><br /> Avec
    cette mthode, les
    requtes traites par <code class="module"><a href="./mod/mod_userdir.html">mod_userdir</a></code> appelleront le
    conteneur suEXEC pour excuter le programme CGI sous l'identifiant
    utilisateur du rpertoire utilisateur concern. Seuls prrequis
    pour pouvoir accder  cette fonctionnalit : l'excution des CGI
    doit tre active pour l'utilisateur concern, et le script doit
    passer avec succs le test des <a href="#model">vrifications de
    scurit</a> dcrit plus haut. Voir aussi l'
    <a href="#install">option de compilation</a>
    <code>--with-suexec-userdir</code>.</p> </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="debug" id="debug">Dbogage de suEXEC</a></h2>

    <p>Le conteneur suEXEC va crire ses informations de journalisation
    dans le fichier dfini par l'option de compilation
    <code>--with-suexec-logfile</code> comme indiqu plus haut. Si vous
    pensez avoir configur et install correctement le conteneur,
    consultez ce journal, ainsi que le journal des erreurs du serveur
    afin de dterminer l'endroit o vous avez fait fausse route.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="jabberwock" id="jabberwock">Avis  la population !
    Avertissements et exemples</a></h2>

    <p><strong>NOTE !</strong> Cette section est peut-tre incomplte.
    Pour en consulter la dernire rvision, voir la version de la <a href="http://httpd.apache.org/docs/2.2/suexec.html">Documentation en ligne</a> du Groupe Apache.</p>

    <p>Quelques points importants du conteneur peuvent
    imposer des contraintes du point de vue de la configuration du
    serveur. Veuillez en prendre connaissance avant de soumettre un
    rapport de bogue  propos de suEXEC.</p>

    <ul>
      <li><strong>Points importants de suEXEC</strong></li>

      <li>
        Limitations concernant la hirarchie.

        <p class="indent">
          Pour des raisons de scurit et d'efficacit, toutes les
	  requtes suEXEC ne doivent concerner que des ressources
	  situes dans la racine des documents dfinie pour les
	  requtes concernant un hte virtuel, ou des ressources
	  situes dans la racine des documents dfinies pour les
	  requtes concernant un rpertoire utilisateur. Par exemple,
	  si vous avez configur quatre htes virtuels, vous devrez
	  dfinir la structure des racines de documents de vos htes
	  virtuels en dehors d'une hirarchie de documents principale
	  d'Apache, afin de tirer parti de suEXEC dans le contexte des
	  htes virtuels (Exemple  venir).
        </p>
      </li>

      <li>
        La variable d'environnement PATH de suEXEC

        <p class="indent">
          Modifier cette variable peut s'avrer dangereux. Assurez-vous
	  que tout chemin que vous ajoutez  cette variable est un
	  rpertoire <strong>de confiance</strong>. Vous n'avez
	  probablement pas l'intention d'ouvrir votre serveur de faon
	   ce que l'on puisse y excuter un cheval de Troie.
        </p>
      </li>

      <li>
        Modification de suEXEC

        <p class="indent">
          Encore une fois, ceci peut vous causer de
	  <strong>graves ennuis</strong> si vous vous y essayez sans
	  savoir ce que vous faites. vitez de vous y risquer dans la
	  mesure du possible.
        </p>
      </li>
    </ul>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/suexec.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/suexec.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/suexec.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/suexec.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/suexec.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2011 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>