#!python
# Copyright 2010 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# DO NOT EDIT. This is an ETW event descriptor file generated by
# sawbuck/py/generate_descriptor.py. It contains event descriptions for
# MOF GUID {2cb15d1d-5fc1-11d2-abe1-00a0c911f518}.

from etw.descriptors import event, field


class Event(object):
  GUID = '{2cb15d1d-5fc1-11d2-abe1-00a0c911f518}'
  UnLoad = (GUID, 2)
  DCStart = (GUID, 3)
  DCEnd = (GUID, 4)
  Load = (GUID, 10)
  KernelBase = (GUID, 33)


class Image_V0(event.EventCategory):
  GUID = Event.GUID
  VERSION = 0

  class Image_V0_Load(event.EventClass):
    _event_types_ = [10]
    _fields_ = [('BaseAddress', field.Pointer),
                ('ModuleSize', field.UInt32),
                ('ImageFileName', field.WString)]


class Image_V1(event.EventCategory):
  GUID = Event.GUID
  VERSION = 1

  class Image_V1_Load(event.EventClass):
    _event_types_ = [10]
    _fields_ = [('ImageBase', field.Pointer),
                ('ImageSize', field.Pointer),
                ('ProcessId', field.UInt32),
                ('FileName', field.WString)]


class Image(event.EventCategory):
  GUID = Event.GUID
  VERSION = 2

  class Image_Load(event.EventClass):
    _event_types_ = [2, 3, 4, 10]
    _fields_ = [('ImageBase', field.Pointer),
                ('ImageSize', field.Pointer),
                ('ProcessId', field.UInt32),
                ('ImageChecksum', field.UInt32),
                ('TimeDateStamp', field.UInt32),
                ('Reserved0', field.UInt32),
                ('DefaultBase', field.Pointer),
                ('Reserved1', field.UInt32),
                ('Reserved2', field.UInt32),
                ('Reserved3', field.UInt32),
                ('Reserved4', field.UInt32),
                ('FileName', field.WString)]

  class KernelImageBase(event.EventClass):
    _event_types_ = [33]
    _fields_ = [('ImageBase', field.Pointer)]
