# Copyright (c) 2010 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'use_system_libwebp%': 0,
  },
  'conditions': [
    ['use_system_libwebp==0', {
      'targets': [
        {
          'target_name': 'libwebp',
          'type': '<(library)',
          'sources': [
            'bits.c',
            'frame.c',
            'dsp.c',
            'quant.c',
            'tree.c',
            'vp8.c',
            'webp.c',
            'yuv.c',
          ],
          'direct_dependent_settings': {
            'include_dirs': [
              '.', './webp',
            ],
          },
          'conditions': [
            ['OS!="win"', {
	      'product_name': 'webp',
              'cflags': [
                '-std=c99',
              ],},
            ],
            ['OS=="win"', {
              'msvs_settings': {
                'VCCLCompilerTool': {
                  'AdditionalOptions': ['/TP'],  # compile as C++ to get C99
                },
              },
            }],
          ],
        },
      ],
    }, {
      'targets': [
        {
          'target_name': 'libwebp',
          'type': 'settings',
          'direct_dependent_settings': {
            'defines': [
              'ENABLE_WEBP',
            ],
          },
          'link_settings': {
            'libraries': [
              '-lwebp',
            ],
          },
        }
      ],
    }],
  ],
}

# Local Variables:
# tab-width:2
# indent-tabs-mode:nil
# End:
# vim: set expandtab tabstop=2 shiftwidth=2:
