// Copyright (c) 2010 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#import <Cocoa/Cocoa.h>

#include "base/scoped_nsobject.h"
#include "base/sys_string_conversions.h"
#import "chrome/browser/cocoa/applescript/bookmark_applescript_utils_unittest.h"
#import "chrome/browser/cocoa/applescript/bookmark_item_applescript.h"
#import "chrome/browser/cocoa/applescript/error_applescript.h"
#include "googleurl/src/gurl.h"
#include "testing/gtest/include/gtest/gtest.h"
#import "testing/gtest_mac.h"
#include "testing/platform_test.h"

typedef BookmarkAppleScriptTest BookmarkItemAppleScriptTest;

namespace {

// Set and get title.
TEST_F(BookmarkItemAppleScriptTest, GetAndSetTitle) {
  NSArray* bookmarkItems = [bookmarkBar_.get() bookmarkItems];
  BookmarkItemAppleScript* item1 = [bookmarkItems objectAtIndex:0];
  [item1 setTitle:@"Foo"];
  EXPECT_NSEQ(@"Foo", [item1 title]);
}

// Set and get URL.
TEST_F(BookmarkItemAppleScriptTest, GetAndSetURL) {
  NSArray* bookmarkItems = [bookmarkBar_.get() bookmarkItems];
  BookmarkItemAppleScript* item1 = [bookmarkItems objectAtIndex:0];
  [item1 setURL:@"http://foo-bar.org"];
  EXPECT_EQ(GURL("http://foo-bar.org"),
            GURL(base::SysNSStringToUTF8([item1 URL])));

  // If scripter enters invalid URL.
  scoped_nsobject<FakeScriptCommand> fakeScriptCommand(
      [[FakeScriptCommand alloc] init]);
  [item1 setURL:@"invalid-url.org"];
  EXPECT_EQ((int)AppleScript::errInvalidURL,
            [fakeScriptCommand.get() scriptErrorNumber]);
}

}  // namespace
