/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for unit management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgunitboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgunitobject.h"
#include "skgmainpanel.h"

#include <QDomDocument>

SKGUnitBoardWidget::SKGUnitBoardWidget ( SKGDocument* iDocument )
        : SKGWidget ( iDocument )
{
    SKGTRACEIN ( 10, "SKGUnitBoardWidget::SKGUnitBoardWidget" );

    ui.setupUi ( this );

    //Refresh
    connect ( ( const QObject* ) getDocument(), SIGNAL ( tableModified ( QString, int ) ), this, SLOT ( dataModified ( QString, int ) ), Qt::QueuedConnection );
    dataModified ( "", 0 );
}

SKGUnitBoardWidget::~SKGUnitBoardWidget()
{
    SKGTRACEIN ( 10, "SKGUnitBoardWidget::~SKGUnitBoardWidget" );

}

void SKGUnitBoardWidget::dataModified ( const QString& iTableName, int iIdTransaction )
{
    SKGTRACEIN ( 10, "SKGUnitBoardWidget::dataModified" );
    Q_UNUSED ( iIdTransaction );

    if ( iTableName=="unit" || iTableName.isEmpty() )
    {
        KLocale* locale=KGlobal::locale();
        SKGServices::SKGUnitInfo primary= ( ( SKGDocumentBank* ) getDocument() )->getPrimaryUnit();

        QString html;
        SKGObjectBase::SKGListSKGObjectBase objs;
        SKGError err=SKGObjectBase::getObjects ( getDocument(), "v_unit_display", "t_type IN ('S', 'I') ORDER BY t_type DESC, t_name ASC", objs );
        if ( err.isSucceeded() )
        {
            html+="<html><body>";
            int nb=objs.count();
            if ( nb )
            {
                html+="<table class=\"table\">";
                QString lastTitle;
                for ( int i=0; i<nb; ++i )
                {
                    SKGUnitObject obj=objs.at ( i );
                    QString type=obj.getAttribute ( "t_TYPENLS" );
                    if ( lastTitle!=type )
                    {
                        lastTitle=type;
                        html+="<tr class=\"tabletotal\"><td><b>"+SKGServices::stringToHtml ( lastTitle ) +"</b></td></tr>";
                    }
                    html+=QString ( "<tr><td><a href=\""+SKGServices::stringToHtml ( obj.getSymbol() ) +"\">" ) +SKGServices::stringToHtml ( obj.getDisplayName() ) +"</a></td><td align=\"right\">";
                    QString unitSymbol=primary.Name;
                    if ( obj.getType() ==SKGUnitObject::INDEX ) unitSymbol=' ';
                    html+=SKGServices::stringToHtml ( locale->formatMoney ( SKGServices::stringToDouble ( obj.getAttribute ( "f_CURRENTAMOUNT" ) ),unitSymbol , primary.NbDecimal ) );
                    html+="</td><td>(";
                    double val=obj.getDailyChange();
                    html+="<font color=\"";
                    html+= ( val<0 ? "red" : "black" );
                    html+="\">";
                    html+=SKGServices::stringToHtml ( locale->formatNumber ( val ) );
                    html+="</font> %)</td></tr>";
                }
                html+="</table>";
            }
            else
            {
                html+=i18n ( "No share or index defined on the <a href=\"___\">\"Units\"</a> page." );
            }
            html+="</body></html>";
            ui.kLabel->setText ( html );
        }
    }
}

void SKGUnitBoardWidget::onOpen ( const QString& iLink )
{
    QDomDocument doc ( "SKGML" );
    if ( iLink!="___" )
    {
        SKGUnitObject unit ( ( SKGDocumentBank* ) getDocument() );
        unit.setSymbol ( iLink );
        unit.load();
        int unitid=unit.getID();

        //Build where clause and title
        QString wc="rc_unit_id="+SKGServices::intToString ( unitid );
        QString title=i18n ( "Operations with unit equal to '%1'",  unit.getName() );

        //Open
        //Call operation plugin
        doc.setContent ( getDocument()->getParameter ( "SKGOPERATION_DEFAULT_PARAMETERS" ) );
        QDomElement root = doc.documentElement();
        if ( root.isNull() )
        {
            root=doc.createElement ( "parameters" );
            doc.appendChild ( root );
        }

        root.setAttribute ( "operationTable", "v_operation_display" );
        root.setAttribute ( "operationWhereClause", wc );
        root.setAttribute ( "title", title );
        root.setAttribute ( "title_icon", "skrooge_unit" );
        root.setAttribute ( "currentPage", "-1" );

        SKGMainPanel::getMainPanel()->setNewTabContent ( SKGMainPanel::getMainPanel()->getPluginByName ( "Skrooge operation plugin" ), -1, doc.toString() );
    }
    else
    {
        doc.setContent ( getDocument()->getParameter ( "SKGUNIT_DEFAULT_PARAMETERS" ) );
        SKGMainPanel::getMainPanel()->setNewTabContent ( SKGMainPanel::getMainPanel()->getPluginByName ( "Skrooge unit plugin" ), -1, doc.toString() );
    }
}
#include "skgunitboardwidget.moc"
