/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGGRAPHICSVIEW_H
#define SKGGRAPHICSVIEW_H
/** @file
 * A Graphic view with more functionalities.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "skgbasegui_export.h"
#include "ui_skggraphicsview.h"

#include <kglobal.h>

#include <QWidget>
#include <QtDesigner/QDesignerExportWidget>
#include <QTimer>

class QGraphicsScene;
class QGraphicsView;
class KMenu;
class QAction;

/**
 * This file is a Graphic view with more functionalities
 */
class SKGBASEGUI_EXPORT SKGGraphicsView : public QWidget
{
    Q_OBJECT
    /**
     * State of the view
     */
    Q_PROPERTY ( QString state READ getState WRITE setState USER true )
    /**
     * To set the toolbar visible or not
     */
    Q_PROPERTY ( bool toolBarVisible READ isToolBarVisible WRITE setToolBarVisible )
public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGGraphicsView ( QWidget *parent = 0 );

    /**
     * Default Destructor
     */
    virtual ~SKGGraphicsView();

    /**
     * Set current scene
     * @param iScene The scene
     */
    virtual void setScene ( QGraphicsScene * iScene );

    /**
     * Get the internal Graphic view
     * @return the internal Graphic view
     */
    virtual QGraphicsView* graphicsView();

    /**
     * Set the visibility of the ToolBar
     * @param iVisibility visibility
     */
    virtual void setToolBarVisible ( bool iVisibility );

    /**
     * Get the visibility of the ToolBar
     * @return visibility
     */
    virtual bool isToolBarVisible() const;

    /**
     * Get the current state
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState() const;

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState ( const QString& iState );

    /**
     * Get a pointer on the contextual menu
     * @return contextual menu
     */
    virtual KMenu* getContextualMenu() const;

public slots:
    /**
     * Set the zoom
     */
    virtual void onZoom();

    /**
     * Zoom in
     */
    virtual void onZoomIn();

    /**
     * Zoom out
     */
    virtual void onZoomOut();

    /**
     * Fit on scene
     */
    virtual void onZoomOriginal();

    /**
     * Print
     */
    virtual void onPrint();

    /**
     * Export in PDF
     */
    virtual void onSavePDF();

    /**
     * Export as images
     */
    virtual void onSaveImage();

    /**
     * Export as SVG
     */
    virtual void onSaveSvg();

    /**
     * Copy
     */
    virtual void onCopy();

    /**
     * Swith tool bar visibility
     */
    virtual void onSwitchToolBarVisibility();

    /**
     * Swith antialiasing
     */
    virtual void onSwitchAntialiasing();

protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    bool eventFilter ( QObject *object, QEvent *event );

private slots:
    void showMenu ( const QPoint& pos );

private:
    Q_DISABLE_COPY ( SKGGraphicsView );
    Ui::skggraphicview_base ui;

    double oscale;

    KMenu* mainMenu;
    QAction* actZoomOriginal;
    QAction* actShowToolBar;
    QAction* actAntialiasing;
    bool toolBarVisible;
    QTimer* timer;
};

#endif // SKGGRAPHICSVIEW_H
