/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGFEColorMatrixElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumberList.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEColorMatrixElement.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEColorMatrixElement)

/* Hash table */

static const HashTableValue JSSVGFEColorMatrixElementTableValues[12] =
{
    { "in1", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementIn1, (intptr_t)0 },
    { "type", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementType, (intptr_t)0 },
    { "values", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementValues, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementStyle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEColorMatrixElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFEColorMatrixElementTableValues, 0 };
#else
    { 34, 31, JSSVGFEColorMatrixElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGFEColorMatrixElementConstructorTableValues[6] =
{
    { "SVG_FECOLORMATRIX_TYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_MATRIX", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_SATURATE", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_HUEROTATE", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEColorMatrixElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGFEColorMatrixElementConstructorTableValues, 0 };
#else
    { 17, 15, JSSVGFEColorMatrixElementConstructorTableValues, 0 };
#endif

class JSSVGFEColorMatrixElementConstructor : public DOMObject {
public:
    JSSVGFEColorMatrixElementConstructor(ExecState* exec)
        : DOMObject(JSSVGFEColorMatrixElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGFEColorMatrixElementPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGFEColorMatrixElementConstructor::s_info = { "SVGFEColorMatrixElementConstructor", 0, &JSSVGFEColorMatrixElementConstructorTable, 0 };

bool JSSVGFEColorMatrixElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEColorMatrixElementConstructor, DOMObject>(exec, &JSSVGFEColorMatrixElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEColorMatrixElementPrototypeTableValues[7] =
{
    { "SVG_FECOLORMATRIX_TYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_MATRIX", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_SATURATE", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_HUEROTATE", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE, (intptr_t)0 },
    { "SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA", DontDelete|ReadOnly, (intptr_t)jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA, (intptr_t)0 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEColorMatrixElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEColorMatrixElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGFEColorMatrixElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGFEColorMatrixElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEColorMatrixElementPrototype::s_info = { "SVGFEColorMatrixElementPrototype", 0, &JSSVGFEColorMatrixElementPrototypeTable, 0 };

JSObject* JSSVGFEColorMatrixElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEColorMatrixElement>(exec, globalObject);
}

bool JSSVGFEColorMatrixElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGFEColorMatrixElementPrototype, JSObject>(exec, &JSSVGFEColorMatrixElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGFEColorMatrixElement::s_info = { "SVGFEColorMatrixElement", &JSSVGElement::s_info, &JSSVGFEColorMatrixElementTable, 0 };

JSSVGFEColorMatrixElement::JSSVGFEColorMatrixElement(PassRefPtr<Structure> structure, PassRefPtr<SVGFEColorMatrixElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGFEColorMatrixElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFEColorMatrixElementPrototype(JSSVGFEColorMatrixElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEColorMatrixElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEColorMatrixElement, Base>(exec, &JSSVGFEColorMatrixElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGFEColorMatrixElementIn1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->typeAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementValues(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumberList> obj = imp->valuesAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEColorMatrixElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValuePtr jsSVGFEColorMatrixElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGFEColorMatrixElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSSVGFEColorMatrixElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGFEColorMatrixElementConstructor>(exec);
}

JSValuePtr jsSVGFEColorMatrixElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGFEColorMatrixElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEColorMatrixElement* castedThisObj = static_cast<JSSVGFEColorMatrixElement*>(asObject(thisValue));
    SVGFEColorMatrixElement* imp = static_cast<SVGFEColorMatrixElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

// Constant getters

JSValuePtr jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValuePtr jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_MATRIX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValuePtr jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_SATURATE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValuePtr jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_HUEROTATE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValuePtr jsSVGFEColorMatrixElementSVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
