# for SUSE Linux 10.1
%define fontsjp IPAGothic IPAMincho

%define exec_texhash [ -x %{_bindir}/texconfig-sys ] && %{_bindir}/env - PATH=%{_bindir}:$PATH %{_bindir}/texconfig-sys rehash 2>/dev/null
%define exec_updmap  [ -x %{_bindir}/updmap-sys ]    && %{_bindir}/env - PATH=%{_bindir}:$PATH %{_bindir}/updmap-sys --nostop 2>/dev/null
%define exec_fmtutil [ -x %{_bindir}/fmtutil-sys ]   && %{_bindir}/env - PATH=%{_bindir}:$PATH %{_bindir}/fmtutil-sys --all >/dev/null
%define vartexfonts %{_var}/lib/texmf

Summary: TeX distribution teTeX with Japanese patch collection 'ptetex3'
Name: tetex
Version: 3.0
Release: 20090610
Source1: http://tutimura.ath.cx/~nob/tex/ptetex/ptetex3/ptetex3-%{release}.tar.gz
Source0: http://www.ring.gr.jp/pub/text/CTAN/systems/unix/teTeX/3.0/distrib/tetex-src-3.0.tar.gz
Source2: http://www.ring.gr.jp/pub/text/CTAN/systems/unix/teTeX/3.0/distrib/tetex-texmf-3.0po.tar.gz
URL: http://www.nn.iij4u.or.jp/~tutimura/tex/ptetex.html
License: distributable
Buildroot: %{_tmppath}/%{name}-%{version}-root
Group: Productivity/Publishing/TeX/Base
PreReq:        ed mktemp
BuildRequires: ed mktemp
PreReq:        ghostscript-cjk %{fontsjp}
BuildRequires: ghostscript-cjk %{fontsjp}
BuildRequires: rpm build
BuildRequires: cpp gzip bzip2 tar patch file nkf
BuildRequires: binutils coreutils findutils diffutils
BuildRequires: gcc gcc-c++ libgcc >= 4.0.2
BuildRequires: glibc glibc-devel glibc-locale >= 2.3.5
BuildRequires: make libstdc++ libstdc++-devel
BuildRequires: bison flex libtool automake autoconf
BuildRequires: zlib-devel libpng-devel ncurses-devel
BuildRequires: xorg-x11 xorg-x11-devel xorg-x11-libs
#http://ftp.opensuse.org/pub/opensuse/distribution/SL-10.1/inst-source/suse/i586/openmotif-devel-2.2.4-21.i586.rpm
#http://ftp.opensuse.org/pub/opensuse/distribution/SL-10.1/inst-source/suse/x86_64/openmotif-devel-2.2.4-21.x86_64.rpm
BuildRequires: openmotif openmotif-libs openmotif-devel
BuildRequires: freetype2 freetype2-devel >= 2.1.10
Provides: te_cont te_kpath te_latex te_mpost te_omega jsclasses
Conflicts: te_ams te_dvilj te_eplai te_web te_ptex
Conflicts: cjk-latex latex-ucs musictex
#PreReq:        tetex-texmf
#BuildRequires: tetex-texmf

%description
TeTeX is an implementation of TeX for Linux or UNIX systems.

%prep
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%setup -q -n tetex-src-3.0 -a 1
mv ptetex3-* ptetex3
cd ptetex3
cat <<EOF > my_option
KANJI_CODE=EUC
#KANJI_CODE=UTF8
export CFLAGS="$RPM_OPT_FLAGS"
SRC_DIR=%{_sourcedir}
TMP_PREFIX=`pwd`%{_prefix}
PREFIX=%{_prefix}
DATADIR=%{_datadir}
TEXSRC_EXTRACTED=%{_builddir}
#TEXMFDIST=%{_datadir}/texmf-dist
make_option vartexfonts=%{vartexfonts}

conf_option --without-dviljk
conf_option --without-info
conf_option --without-texi2html
conf_option --without-texinfo

conf_option --with-system-zlib
conf_option --with-system-pnglib
conf_option --with-system-gd
conf_option --with-system-ncurses
conf_option --with-system-t1lib
conf_option --enable-shared
conf_option --enable-kanji-iconv
EOF
# ommit file check
perl -pi -e "s|(\./1check-archive\.sh)|\1 notetex|g" Makefile
# remove useless entry in 7font-search.sh
perl -ni -e 'print unless /^X11TTF / or /^Acrobat/' 7font-search.sh
# extract files
unset TEXMFMAIN TEXMF HOME
make check x
# modify input method for xdvi
perl -pi -e 's/(\*inputMethod: kinput2)/! \1/' \
    ../texk/xdvik/texmf/XDvi
# avoid dependency on perl-Tk
rm -rf teTeX/share/texmf-dist/scripts/context/perl

%build
cd ptetex3
unset TEXMFMAIN TEXMF HOME
make c macro otf babel fonty

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
mkdir -p $RPM_BUILD_ROOT%{vartexfonts}
cp -a ptetex3%{_prefix}/bin     $RPM_BUILD_ROOT%{_bindir}
cp -a ptetex3%{_prefix}/share   $RPM_BUILD_ROOT%{_datadir}
cp -a ptetex3%{_prefix}/include $RPM_BUILD_ROOT%{_includedir}
cp -a ptetex3%{_prefix}/lib     $RPM_BUILD_ROOT%{_libdir}
cp -a ptetex3%{_prefix}/man     $RPM_BUILD_ROOT%{_mandir}
cp -a ptetex3%{_prefix}/info    $RPM_BUILD_ROOT%{_infodir}

rm -r	$RPM_BUILD_ROOT%{_datadir}/texmf/web2c/texmf.cnf.* \
	$RPM_BUILD_ROOT%{_datadir}/texmf/web2c/fmtutil.cnf.* \
	$RPM_BUILD_ROOT%{_infodir}/dir

### Files list
find $RPM_BUILD_ROOT -type f -or -type l | \
    sed -e "s|$RPM_BUILD_ROOT||g" \
	-e "s|.*\.cnf$|%config(noreplace) &|" \
	-e "s|.*\.cfg$|%config(noreplace) &|" \
	-e "s|.*/ls-R$|%ghost &|" \
	-e "s|.*/texmf-var/.*\.log$|%ghost &|" \
	-e "s|.*/texmf-var/.*map$|%ghost &|" \
	-e "s|.*/texmf-var/.*\.fmt$|%verify(not size md5 mtime) &|" \
	-e "s|.*/texmf-var/.*\.mem$|%verify(not size md5 mtime) &|" \
	-e "s|.*/texmf-var/.*\.base$|%verify(not size md5 mtime) &|" \
	-e "s|/man/man.*|&*|" \
	-e "s|/info/.*|&*|" \
	-e "s|\.py$|&*|" \
						> filelist.full
find $RPM_BUILD_ROOT%{_datadir}/texmf* -type d | \
    sed -e "s|^$RPM_BUILD_ROOT|%dir |" \
	-e "s|$|/|"				>> filelist.full
echo "%dir %{_includedir}/kpathsea"		>> filelist.full

## check if 'jmpost.mem' exist
grep '/jmpost.mem' filelist.full > /dev/null

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT


%preun
rm -rf %{vartexfonts}/*
exit 0

%post
/sbin/ldconfig
%{exec_texhash}
%{exec_updmap}
exit 0

%postun
/sbin/ldconfig
exit 0


%files -f filelist.full
%defattr(-,root,root)
%attr(1777,root,root) %dir %{vartexfonts}


%changelog
* Wed Feb  7 2007 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added 'env -' to %exec_texhash, etc. to void $TEXMFMAIN.

* Tue Nov  7 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added 'unset TEXINPUTS HOME' before 'make'.

* Mon Oct 16 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- updated "my_option".
- use %{vartexfonts}.

* Tue Sep  5 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- use %{_mandir} and %{_infodir}, etc.
- remove useless files. (%{_infodir}/dir, texmf.cnf.*, fmtutil.cnf.*)
- added check existence of 'jmpost.mem'.

* Sun Sep  3 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added %{exec_fmtutil} macro.

* Tue Aug 15 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- use conf_option and make_option.

* Mon Mar 20 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added %verify() attribute to *.fmt and *.mem and *.base.

* Mon Dec  5 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- automatic yes in make font (target "fonty").

* Sat Dec  3 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- enhanced %exec_texhash macro (check if the command exist).

* Tue Aug 30 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added 'babel' target for make.

* Thu Jun 16 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- 1st release.
