#!/usr/bin/perl -w

use strict;
my (%title, %group, %depend, %option, %beforex, %afterx);
my $PTETEX_VER = `date +%Y%m%d`;
chop $PTETEX_VER;

###################################

$title{'vl3'} = <<'EOF';
# for VineLinux 3.x
%define fontsjp TrueType-sazanami
EOF

$title{'vl4'} = $title{'vl3'};
$title{'vl4'} =~ s/3/4/g;

$title{'fc4'} = <<'EOF';
# for Fedora Core 4
%define fontsjp fonts-japanese
EOF

$title{'fc5'} = $title{'fc4'};
$title{'fc5'} =~ s/4/5/g;

$title{'fc6'} = $title{'fc5'};
$title{'fc6'} =~ s/5/6/g;

$title{'rhel4'}  = <<'EOF';
# for Red Hat Enterprise Linux v.4
%define fontsjp ttfonts-ja
EOF

$title{'suse101'}  = <<'EOF';
# for SUSE Linux 10.1
%define fontsjp IPAGothic IPAMincho
EOF

###################################

$group{'vl3'}     = "Applications/Publishing";
$group{'vl4'}     = $group{'vl3'};
$group{'fc4'}     = $group{'vl3'};
$group{'fc5'}     = $group{'vl3'};
$group{'fc6'}     = $group{'vl3'};
$group{'rhel4'}   = $group{'vl3'};
$group{'suse101'} = "Productivity/Publishing/TeX/Base";

###################################

$depend{'vl3'} = <<'EOF';
PreReq:        ed mktemp
BuildRequires: ed mktemp
PreReq:        ghostscript %{fontsjp}
BuildRequires: ghostscript %{fontsjp}
BuildRequires: build-essential bison flex
BuildRequires: zlib-devel libpng-devel ncurses-devel
BuildRequires: XOrg-devel openMotif-devel t1lib-devel
Provides: tetex = 3.0 tetex-extra tetex-doc
Provides: xdvik dvipdfmx dvipng jvf makejvf tetex-macros texmacro-otf
EOF

$depend{'vl4'} = $depend{'vl3'};
$depend{'vl4'} =~ s/ t1lib-devel/ freetype2-devel/g;
$depend{'vl4'} =~ s/(Provides: tetex)/# BuildRequires: gd-devel t1lib-devel libjpeg-devel # VinePlus\n$1/;

$depend{'fc4'} = <<'EOF';
PreReq:        ed mktemp
BuildRequires: ed mktemp
PreReq:        ghostscript %{fontsjp}
BuildRequires: ghostscript %{fontsjp}
BuildRequires: bison flex
BuildRequires: zlib-devel libpng-devel gd-devel libjpeg-devel ncurses-devel
BuildRequires: xorg-x11-devel openmotif-devel
Provides: tetex = 3.0 tetex-latex tetex-fonts tetex-afm
Provides: tetex-dvips tetex-xdvi  tetex-doc
EOF

$depend{'fc5'} = $depend{'fc4'};
$depend{'fc5'} =~ s/xorg-x11-devel/xorg-x11-proto-devel/g;

$depend{'fc6'} = $depend{'fc5'};
$depend{'fc6'} =~ s/openmotif/lesstif/g;

$depend{'rhel4'} = $depend{'fc4'};

$depend{'suse101'} = <<'EOF';
PreReq:        ed mktemp
BuildRequires: ed mktemp
PreReq:        ghostscript-cjk %{fontsjp}
BuildRequires: ghostscript-cjk %{fontsjp}
BuildRequires: rpm build
BuildRequires: cpp gzip bzip2 tar patch file nkf
BuildRequires: binutils coreutils findutils diffutils
BuildRequires: gcc gcc-c++ libgcc >= 4.0.2
BuildRequires: glibc glibc-devel glibc-locale >= 2.3.5
BuildRequires: make libstdc++ libstdc++-devel
BuildRequires: bison flex libtool automake autoconf
BuildRequires: zlib-devel libpng-devel ncurses-devel
BuildRequires: xorg-x11 xorg-x11-devel xorg-x11-libs
#http://ftp.opensuse.org/pub/opensuse/distribution/SL-10.1/inst-source/suse/i586/openmotif-devel-2.2.4-21.i586.rpm
#http://ftp.opensuse.org/pub/opensuse/distribution/SL-10.1/inst-source/suse/x86_64/openmotif-devel-2.2.4-21.x86_64.rpm
BuildRequires: openmotif openmotif-libs openmotif-devel
BuildRequires: freetype2 freetype2-devel >= 2.1.10
Provides:  tetex = 3.0 te_cont te_kpath te_latex te_mpost te_omega jsclasses
Conflicts: te_ams te_dvilj te_eplai te_web te_ptex
Conflicts: cjk-latex latex-ucs musictex
EOF

###################################

$option{'vl3'} = <<'EOF';
EOF

$option{'vl4'}     = $option{'vl3'};
$option{'fc4'}     = $option{'vl3'};
$option{'fc5'}     = $option{'vl3'};
$option{'fc6'}     = $option{'vl3'};
$option{'rhel4'}   = $option{'vl3'};
$option{'suse101'} = $option{'vl3'};

###################################

$beforex{'vl3'} = <<'EOF';
# remove useless entry in 7font-search.sh
perl -ni -e 'print "alias /usr/share/fonts/alias/TrueType\n" if /^truetype/;
	s/sazanami-mincho/mincho-mr-jisx0208.1983-0/;
	s/sazanami-gothic/gothic-mr-jisx0208.1983-0/;
	print unless /^X11TTF / or /^Acrobat/ or /^\s(df|lx).*\.ttc/' \
    7font-search.sh
EOF

$beforex{'vl4'} = <<'EOF';
# remove useless entry in 7font-search.sh
perl -ni -e '
	s/sazanami-mincho/Mincho-Medium/;
	s/sazanami-gothic/Gothic-Medium/;
	print unless /^X11TTF / or /^Acrobat/ or /^\s(df|lx|ipa).*\.tt[cf]/' \
    7font-search.sh
EOF

$beforex{'fc4'} = <<'EOF';
# remove useless entry in 7font-search.sh
perl -ni -e 'print unless /^X11TTF / or /^Acrobat/' 7font-search.sh
EOF

$beforex{'fc5'}     = $beforex{'fc4'};
$beforex{'fc6'}     = $beforex{'fc4'};
$beforex{'rhel4'}   = $beforex{'fc4'};
$beforex{'suse101'} = $beforex{'fc4'};

###################################

$afterx{'vl3'} = <<'EOF';
# avoid dependency on perl-Tk
rm -rf teTeX/share/texmf-dist/scripts/context/perl
EOF

$afterx{'fc4'} = <<'EOF' . $afterx{'vl3'};
# modify input method for xdvi
perl -pi -e 's/(\*inputMethod: kinput2)/! \1/' \
    .%{_prefix}/tetex-src-3.0/texk/xdvik/texmf/XDvi
EOF

$afterx{'vl4'}     = $afterx{'fc4'} . <<'EOF';
# make symlink to ttf/ttc by PostScript name
SRC=/usr/share/fonts/alias/TrueType
DST=.%{_prefix}/share/texmf/fonts/truetype
mkdir -p $DST
ln -sf $SRC/mincho-mr-jisx0208.1983-0.ttf $DST/Mincho-Medium.ttf
ln -sf $SRC/gothic-mr-jisx0208.1983-0.ttf $DST/Gothic-Medium.ttf
EOF

$afterx{'fc5'}     = $afterx{'fc4'};
$afterx{'fc6'}     = $afterx{'fc4'};
$afterx{'rhel4'}   = $afterx{'fc4'};
$afterx{'suse101'} = $afterx{'fc4'};

###################################

my $dist;
foreach $dist ('vl3', 'vl4', 'fc4', 'fc5', 'fc6', 'rhel4', 'suse101') {
    open(SPEC, "< gene-template");
    open(OUT,  "> $dist");
    <SPEC>; # dummy read
    print OUT $title{$dist};
    while (<SPEC>) {
	s/\@PTETEX_VER\@/$PTETEX_VER/g;
	s/^(Group:).*/$1 $group{$dist}/g;
	s/^(.*--with-system-gd)/# $1/ if $dist =~ /vl/;
	print OUT $option{$dist}  if /^EOF/;
	print OUT $beforex{$dist} if /^# extract files/;
	print OUT;
	print OUT $afterx{$dist}  if /^make .* x$/;
	print OUT $depend{$dist}  if /^Group:/;
    }
    close(SPEC);
    close(OUT);
}
