#!/bin/sh
#
# ptetex3 -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh
root_check

install="prefix=$TMP_PREFIX texmf=$TEXMF datadir=$TMP_DATADIR install"

xdvi_check() {
    if test ! -f $SRC/texk/xdvik/Makefile && test "$XDVI" != "echo"; then
	cat <<-EOF
	-----------------------------
	We are NOT going to compile xdvi.  We have two choices.
	1. (with xdvi)    Check if we have X11 headers.
	2. (without xdvi) Set XDVI=echo in "my_option" to omit xdvi test.
	
	EOF
	exit 1
    fi
}

date
if test "$JAPANESE" != "without"; then
## freetype for xdvi-jp
if test "$SYSTEM_FREETYPE2" = "no"; then
    echo "[--freetype--] configure"
    cd $SRC/freetype || exit
    GNUMAKE=$MAKE ./configure || exit
    echo "[--freetype--] make"
    $MAKE || exit

    for f in $SRC/texk/*xdvik/configure; do
	perlprint \
	"s@freetype-config --ftversion@echo 2.3.5@g;
	 s@freetype-config --cflags@echo -I../../freetype/include@g;
	 s@freetype-config --libs@sh ../../freetype/builds/unix/freetype-config --libs | sed -e 's|-lfreetype|../../freetype/objs/.libs/libfreetype.a|'@" \
	     $f
    done
fi
fi # "$JAPANESE" != "without"

echo "[--tetex--] configure"
cd $SRC || exit
$MKDIR $PREFIX/share/texmf 2> /dev/null # avoid warning of texmf tree
./configure --prefix=$PREFIX --datadir=$DATADIR \
    --disable-multiplatform --with-ptexenc=$KANJI_CODE \
    $CONF_OPTION || exit
$RMDIR $PREFIX/share/texmf 2> /dev/null # avoid warning of texmf tree
xdvi_check
echo "[--tetex--] make"
$MAKE $MAKE_OPTION || exit
echo "[--tetex--] make install"
$MAKE $MAKE_OPTION $install || exit


if test "$JAPANESE" != "without"; then
echo "[--dvipdfmx--] configure"
cd $SRC/texk/dvipdfmx || exit
./configure --with-kpathsea=$TMP_PREFIX \
    --prefix=$PREFIX --datadir=$DATADIR || exit
echo "[--dvipdfmx--] make"
$MAKE $MAKE_OPTION || exit
echo "[--dvipdfmx--] install"
$MAKE $MAKE_OPTION $install || exit
fi # "$JAPANESE" != "without"

## disable mktexlsr (texhash)
#echo "% disable ls-R" > $TEXMF/ls-R

if test "$STRIP" = "yes"; then
    strip  $TMP_PREFIX/bin/* 2> /dev/null
    strip  $TMP_PREFIX/lib/libkpathsea.* \
	   $TMP_PREFIX/lib/libptexenc.* 2> /dev/null
    ar -ts $TMP_PREFIX/lib/libkpathsea.* \
	   $TMP_PREFIX/lib/libptexenc.* 2> /dev/null
fi
$MKTEXLSR || exit
$UPDMAP 2> /dev/null || exit
date

cat <<EOF
------------------------------
'ptetex3' binary was installed temporary.
(You should need extra macros and settings of Japanese fonts
 via 'make macro' and 'make font'.)
A WIZARD of UNIX can use the temporary TeX system by following setting.
In most case 'make install' is recommended.

(for sh/bash user)
export            PATH=$TMP_PREFIX/bin:\$PATH
export LD_LIBRARY_PATH=$TMP_PREFIX/lib:\$LD_LIBRARY_PATH
export       TEXMFMAIN=$TMP_PREFIX/share/texmf

(for csh/tcsh user)
setenv            PATH $TMP_PREFIX/bin:\$PATH
setenv LD_LIBRARY_PATH $TMP_PREFIX/lib:\$LD_LIBRARY_PATH
setenv       TEXMFMAIN $TMP_PREFIX/share/texmf
------------------------------

EOF
