/***************************************************************************
                          settings_widg.h  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#ifndef SETTINGS_WIDG_H
#define SETTINGS_WIDG_H

#include <QWidget>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QTableWidget>
#include <QTableWidgetItem>
//#include <QTabletEvent>
#include <QLineEdit>
#include <KPushButton>
#include <KDateTable>
#include <KComboBox>
#include <QString>
#include <Qt>
#include <KStandardDirs>
#include <KMenu>

#include <QCheckBox>	//ooo
#include <QGroupBox>	//ooo
#include <QGridLayout>	//ooo

//class QAction;

class Dictionary {
public:
	//Dictionary(QString _name, QString _language, int _id)
	//Dictionary(QString _name, QString _language, int _id, QString _codec)	//ooo
	//Dictionary(QString _name, QString _language, int _id, int _codecId)	//ooo
	//Dictionary(QString _name, QString _language, int _id, int _codecId, int _directionId)	//ooo
	//Dictionary(QString _name, QString _language, int _id, int _codecId, int _directionId, int _disableId)	//ooo
	//Dictionary(QString _name, QString _language, int _id, int _codecId, int _directionId, int _disableId, int _encodingId)	//ooo
	Dictionary(QString _name, QString _language, int _id, int _encodingDefinitionId, int _directionId, int _disableId, int _encodingExpressionId)	//ooo
		//{fileName=_name; Language=_language; flagID=_id;}
		//{fileName=_name; Language=_language; flagID=_id; Codec=_codec;}	//ooo
		//{fileName=_name; Language=_language; flagID=_id; codecID=_codecId;}	//ooo
		//{fileName=_name; Language=_language; flagID=_id; codecID=_codecId; directionID=_directionId;}	//ooo
		//{fileName=_name; Language=_language; flagID=_id; codecID=_codecId; directionID=_directionId; disableID=_disableId;}	//ooo
		//{fileName=_name; Language=_language; flagID=_id; codecID=_codecId; directionID=_directionId; disableID=_disableId; encodingID=_encodingId;}	//ooo
		{fileName=_name; Language=_language; flagID=_id; encodingDefinitionID=_encodingDefinitionId; directionID=_directionId; disableID=_disableId; encodingExpressionID=_encodingExpressionId;}	//ooo
		
	QString fileName;
	QString Language;
	int flagID;
	//QString Codec;		//ooo
	int encodingDefinitionID;	//ooo
	int directionID;		//ooo
	int disableID;			//ooo
	int encodingExpressionID;	//ooo
};


class Table_widg : public QTableWidget
{
   Q_OBJECT
public:
	Table_widg(QWidget *parent=0);	//ooo
	~Table_widg();

	//QTableWidget *tableWidget;

	int xPos;	//ooo
	int yPos;	//ooo
	int xGlobalPos;	//ooo
	int yGlobalPos;	//ooo

protected:
	void mousePressEvent(QMouseEvent *event);	//ooo
};


class Settings_widg : public QWidget
{
   Q_OBJECT
public:
	//Settings_widg( QWidget *parent=0 );
	Settings_widg( QWidget *parent=0, QMouseEvent *event=0 );	//ooo
	~Settings_widg();

	//QTable *Table;
	//QTableWidget *filesTable/*tableWidget*/;
	Table_widg *tableWidget;	//ooo
	QLineEdit *eBasePath;
	QList<Dictionary> *Data;
	QList<Dictionary>::const_iterator itr;

	KPushButton *bRemoveAll;

	//void addDictionary(QString,QString,int);
	//void addDictionary(QString,QString,int,QString);	//ooo
	//void addDictionary(QString,QString,int,int);	//ooo
	//void addDictionary(QString,QString,int,int,int);	//ooo
	//void addDictionary(QString,QString,int,int,int,int);	//ooo
	void addDictionary(QString,QString,int,int,int,int,int);	//ooo
	void repaintTable();

	QString flagPath;
	int selectedRow;
	int selectedColumn;	//ooo

	QMouseEvent *Par_mouseEvent;	//ooo
	QTableWidgetItem *currentItem;	//ooo
	QTableWidgetItem *prevItem;	//ooo
	QBrush tableItemColor;	//ooo
	int xPos;	//ooo
	int yPos;	//ooo

	KComboBox *cGoToLine;		//ooo


private:
	//void editRow(/*int*/);
	void move(int, bool);
	//void moveOnTop(int);

	//QVBoxLayout *Box;
	QVBoxLayout *mainLayout;
	QHBoxLayout *topBox;
	QHBoxLayout *bottomBox;
	KPushButton *bAdd;
	KPushButton *bMoveUp;		//ooo
	KPushButton *bMoveDown;		//ooo
	KPushButton *bMoveToLine;	//ooo
	KPushButton *bOpen;
	KPushButton *bHelp;

	//KPopupMenu *menu;
	//KPopupFrame *menu;
	//KMenu *menu;
	QAction *moveOnTopAct;
	QAction *moveUpAct;
	QAction *moveDownAct;
	QAction *moveToLineAct;
	QAction *editAct;
	QAction *removeDictionaryAct;
	QMenu *setupDictionaryMenu;

protected:
	void mousePressEvent(QMouseEvent *event);	//ooo

public slots:
	void slot_RemoveAll(bool ask = true);
	void slot_Open();
	void slot_Add();
	void slot_Help();
	void slot_table_Clicked(int, int);	//ooo
	void slot_tableClicked(int, int);
	void slot_removeRow(bool ask = true);
	void slot_moveOnTop();
	void slot_moveUp();
	void slot_moveDown();
	void slot_moveToLine();
	void slot_editRow();
};

class CAddWidget : public QWidget
{
  Q_OBJECT
public:
	//CAddWidget(Settings_widg *parent=0);
	CAddWidget(Settings_widg *parent=0,
		int _row = -1,
		QString _fileName = QString::null,
		QString _Language = QString::null,
		int _flagID = -1,		//ooo
		//QString _Codec = QString::null);	//ooo
		int _codecID = -1,		//ooo
		int _directionID = -1,		//ooo
		int _disableID = -1,		//ooo
		int _encodingID = -1);		//ooo
		//int _flagID = -1);
	~CAddWidget();

	QLineEdit *eFileName;
	QLineEdit *eLanguageName;
	KComboBox *cFlag;
	KComboBox *cDisable;		//ooo
	KComboBox *cEncoding;		//ooo
	KComboBox *cCodec;		//ooo
	KComboBox *cDirection;		//ooo
	QCheckBox *ChangeDirection;

	//Settings_widg *Par1;   //ooo

private:
	//QVBoxLayout *Box;
	QVBoxLayout *mainLayout;
	QHBoxLayout *Box1;
	QHBoxLayout *Box2;
	QHBoxLayout *Box3;
	QHBoxLayout *Box8;	//ooo
	QHBoxLayout *Box4;
	QHBoxLayout *Box7;	//ooo
	QHBoxLayout *Box5;	//ooo
	QHBoxLayout *Box6;	//ooo
	QGroupBox *optionsGroupBox;	//ooo
	QGridLayout *optionsGroupBoxLayout;	//ooo


	KPushButton *bOpen;

	KPushButton *bOk;
	KPushButton *bCancel;

	Settings_widg *Parent;
	bool editMode;
	int editRow;
	QWidget *Par1;	//ooo

public slots:
	void slot_Close();
	void slot_Ok();
	void slot_OpenFile();
};

#endif
