/***************************************************************************
                          qtrans.h  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#ifndef _QTRANS_H_
#define _QTRANS_H_

#include <KMainWindow>

#include <KToolBar>
#include <KMenu>

#include <QClipboard>
#include <QTimer>
#include <QSystemTrayIcon>
#include <KHelpMenu>
#include <QMouseEvent>		//ooo
#include <QTextEdit>		//ooo
#include <QWebView>		//ooo
//#include <QtWebKit/QWebView>	//ooo
#include <QKeyEvent>		//ooo

#include <QMenu>		//ooo
#include <QMenuBar>		//ooo
#include <QStatusBar>		//ooo
#include <QTime>		//ooo
#include <QProgressBar>		//ooo

#include "systemtray.h"
#include "settings_widg.h"
#include "html_widget.h"
#include "babylon.h"		//ooo

//#include "previewer.h"	//ooo

//class KComboBox;
//class QComboBox;
//class QAction;
//class QLabel;
//class QMenu;
//class KMenuBar;

//class QComboBox;

class QTrans : public KMainWindow
{
    Q_OBJECT
public:

	QTrans(QWidget* parent=0, KAboutData *aboutData=0);
	~QTrans();

	Html_Widget *Out;
	Babylon *Dic;			//ooo
	//Previewer *centralWidget;	//ooo

public slots:
	void Popup();

	void slot_Quit();
	void slot_Exit(bool ask = true);
	void slot_Ok();
	void slot_About();
	void slot_Help();

	void slot_ClipChanged();
	void slot_Enable();
	void slot_ShortCut();
	void toggleMode();
	void slot_OnTop();
	void slot_WordStartsWith();		//ooo
	void slot_WholeWordsOnly();		//ooo
	void slot_Combo(const QString &);
	void slot_Combo_2(int);			//ooo
	void slot_Combo_3(int);			//ooo
	void slot_Combo_4(int);			//ooo

	void chooseLibrary(QAction *action);
	void slot_searchInAllDictionaries();	//ooo
	void slot_searchInEveryDictionary();	//ooo
	void slot_statusBarMessage();		//ooo
	void slot_aboutKDE();
	void slot_Config();

	void slot_Copy();	//ooo


	//void iconActivated(QSystemTrayIcon::ActivationReason reason);

public:
	//void Translate(QString ,int ind=0);
	void Translate(QString ,int ind=0, bool allDict=false, bool inEveryDict=false);	//ooo
	void readConfig();
	void writeConfig();
	void Default();

	SystemTray *Dock;
	KAboutData* Par_aboutData;

	QClipboard *clip;
	QString Prev_Clip;

	KAction *closeAct;
	KToolBar *ToolBar;
	KHelpMenu *HelpMenu;

	QTimer *Time;
	QString English_Path;
	QTime t;			//ooo
	int NumOfLines;			//ooo
	int SearchTime;			//ooo
	int FinishedTime;		//ooo
	QString DictionaryName;	//ooo

	QList<Dictionary> *bab_dict;
	QWebView *view;
	QList<Dictionary>::const_iterator itr;
	QActionGroup *languageGroup;

	bool enabled;
	/*-- Boolean Controls --*/
	bool AutoPopUp,
		DontClose,
		DockIcon,
		StartMin,
		MouseSelected,		//ooo
		StatusBarSelected,	//ooo
		comboCurrentIndexChanged,	//ooo
		translationExecuted,	//ooo
		enableTranslation_2,	//ooo
		translationEnabled,	//ooo
		enableShortCut,
		compactMode,
		hideTask,
		stayOnTop,
		wordStartsWith,		//ooo
		wordContains,		//ooo
		wordEndsWith,		//ooo
		wholeWordsOnly;		//ooo
	/*-- --*/

	QFont fontType;
	QString ShortKey;
	QString Charset;
	QString widgetStyle;	//ooo
	QString bgColor, txtColor;
	QString expressionTxtColor;	//ooo
	QString sentencePartTxtColor;	//ooo
	//KComboBox *combo;
	QComboBox *combo;
	int comboCurrentIndexIfChanged;	//ooo
	int comboActivatedIndexStack;	//ooo
	QProgressBar *progressBar;	//ooo
	QString strStatusBar;		//ooo
	QMenu *languageMenu;

	QList<QAction*> actionsList;

	QSystemTrayIcon *trayIcon;

private:
	void createActions();
	void createMenus();
	void setupActions();
	void createStatusBar();		//ooo

	void createTrayIcon();
	QAction *exitAct;
	QAction *trayExitAct;
	QAction *trayAboutAct;
	QAction *aboutAct;
	QAction *configAct;

	QAction *normalModeAct;
	QAction *compactModeAct;
	QAction *stayOnTopAct;
	QAction *wordStartsWithAct;	//ooo
	QAction *wholeWordsOnlyAct;	//ooo
	QAction *searchAllAct;		//ooo
	QAction *searchEveryDictAct;	//ooo
	QAction *disableAct;
	QAction *enableAct;

	QAction *copyAct;	//ooo
	QTextEdit *textEdit;	//ooo
	//Previewer *centralWidget;	//ooo

	//QCheckBox *showIconCheckBox;

	//QSystemTrayIcon *trayIcon;   //because of Settings::slot_apply()
	//QMenu *trayIconMenu;   //no addTitle possible
	KMenu *trayIconMenu;

	QMenu *helpMenu;	//ooo
	QMenuBar *menubar;	//ooo

protected:
	void closeEvent(QCloseEvent *event);
	//void closeEvent(QEvent *event);
	void keyPressEvent(QKeyEvent * event);
	void contextMenuEvent(QContextMenuEvent *event);
	void mousePressEvent(QMouseEvent *event);	//ooo
	//bool queryClose();

	int xPos;
	int yPos;

};

#endif // _QTRANS_H_
