
/*
 *  soldevice.h
 *
 *  Copyright (C) 2009 David Hubner <hubnerd@ntlworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef __SOLDEVICE__
#define __SOLDEVICE__

//QT
#include <QTreeWidgetItem>
#include <QTreeWidget>
#include <QMessageBox>

//Solid
#include <solid/device.h>
#include <solid/deviceinterface.h>
#include <solid/processor.h>
#include <solid/deviceinterface.h>
#include <solid/networkinterface.h>
#include <solid/storagedrive.h>
#include <solid/storagevolume.h>
#include <solid/audiointerface.h>
#include <solid/button.h>
#include <solid/portablemediaplayer.h>
#include <solid/camera.h>
#include <solid/battery.h>
#include <solid/acadapter.h>
#include <solid/serialinterface.h>
#include <solid/video.h>
#include <solid/smartcardreader.h>

//KDE
#include <kicon.h>
#include <kdebug.h>
#include <klocale.h>

// Local
#include "qvlistlayout.h"

class QVListLayout;

class SolDevice : public QTreeWidgetItem
{
  
  public:
    SolDevice(Solid::DeviceInterface::Type);
    SolDevice(Solid::DeviceInterface::Type, QString);
    SolDevice(QTreeWidgetItem *);
    SolDevice(QTreeWidgetItem *, Solid::Device);
    
    QIcon getDeviceIcon();
    Solid::Device *getDevice();
    Solid::DeviceInterface::Type getDeviceType();
    
    template <class IFace> IFace *getInterface() 
    {
      if(deviceSet) {
	IFace *dev = tiedDevice.as<IFace>();
	if(!dev) {
	  kDebug() << i18n("Device unable to be cast to correct device") << endl;
	}
	return dev;
      } else {
	return NULL;
      }
    }
    
    template <class IFace> IFace *getInterface(Solid::Device device) 
    {
	IFace *dev = device.as<IFace>();
	if(!dev) {
	  kDebug() << i18n("Device unable to be cast to correct device") << endl;
	}
	return dev;
    }
    
    template <class IFace> void createDeviceChildren(
      QTreeWidgetItem *treeParent, QString parentUid, Solid::DeviceInterface::Type type) {
      
      QList<Solid::Device> list = Solid::Device::listFromType(type, parentUid);

      foreach(Solid::Device dev, list) {
	new IFace(treeParent,dev);
      }
    }   

    virtual QVListLayout *getInfoPanelLayout();
    virtual void setDefaultDeviceText(); 
    virtual void setDefaultDeviceIcon();
    virtual void setDefaultListing(Solid::DeviceInterface::Type);
    
    bool isDeviceSet();
    
  protected:
    
    void setDeviceText(QString);
    void setDeviceIcon(KIcon);
    
    bool deviceSet;
    QVListLayout *deviceInfoLayout;
    Solid::DeviceInterface::Type deviceType;
    Solid::Device tiedDevice;
};

#endif //__SOLDEVICE__