
/*
 *  soldevice.cpp
 *
 *  Copyright (C) 2009 David Hubner <hubnerd@ntlworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#include "soldevice.h"

// Con

SolDevice::SolDevice(Solid::DeviceInterface::Type type) : 
  QTreeWidgetItem(), deviceSet(0) 
{ 
  deviceType=type;
  setText(0,Solid::DeviceInterface::typeToString(type));
}

SolDevice::SolDevice(QTreeWidgetItem *parent) : 
  QTreeWidgetItem(parent), deviceSet(0)
{
  deviceType = Solid::DeviceInterface::Unknown;
}

SolDevice::SolDevice(Solid::DeviceInterface::Type type, QString typeName) : 
  QTreeWidgetItem(), deviceSet(0)
{
  deviceType=type;
  setText(0,typeName);
  
  setDefaultListing(type);
}

SolDevice::SolDevice(QTreeWidgetItem *parent, Solid::Device device) : 
  QTreeWidgetItem(parent), tiedDevice(device)
{
  deviceType = Solid::DeviceInterface::Unknown;
  
  deviceSet = device.isValid();
  setDefaultDeviceText();
  setDefaultDeviceIcon();
}

//Sets

void SolDevice::setDefaultListing(Solid::DeviceInterface::Type type) {

  createDeviceChildren<SolDevice>(this,QString(),type);
}

void SolDevice::setDefaultDeviceText() {
  
  if(deviceSet) {
    setText(0,tiedDevice.product());
  } else { setText(0,i18n("Unknown")); }
}

void SolDevice::setDefaultDeviceIcon() {
 
   if(deviceSet) {
     setDeviceIcon(KIcon(tiedDevice.icon()));
   } else {
     setDeviceIcon(KIcon("kde"));
   }
}

void SolDevice::setDeviceIcon(KIcon icon) {
 
   setIcon(0,icon);
}

void SolDevice::setDeviceText(QString text) {
  
  setText(0,text);
}

// Gets

QVListLayout *SolDevice::getInfoPanelLayout() {
  
  deviceInfoLayout = new QVListLayout();
  return deviceInfoLayout;
}

QIcon SolDevice::getDeviceIcon() {
  
  return icon(0);
}

Solid::DeviceInterface::Type SolDevice::getDeviceType() {

  return deviceType;
}

Solid::Device *SolDevice::getDevice() {
  
   return &tiedDevice;
}

// Is

bool SolDevice::isDeviceSet() {
  
  return deviceSet;
}