//////////////////////////////////////////////////////////////////////////////
// Name:        SVGUIControl.cpp
// Purpose:     
// Author:      Laurent Bessard
// Created:     2005/07/28
// RCS-ID:      $Id: SVGUIControl.cpp,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#include "SVGUIControl.h"

BEGIN_EVENT_TABLE(SVGUIControl, wxEvtHandler)
  EVT_LEFT_DOWN	(SVGUIControl::OnLeftDown)
  EVT_LEFT_UP	(SVGUIControl::OnLeftUp)
  EVT_MOTION	(SVGUIControl::OnMotion)
  EVT_CHAR  (SVGUIControl::OnChar)
END_EVENT_TABLE()

SVGUIControl::SVGUIControl(wxSVGDocument* doc, wxEvtHandler* window):
	SVGUIElement(doc)
{
	m_window = window;
}

bool SVGUIControl::HitTest(wxPoint pt)
{
	wxSVGRect rect(pt.x, pt.y, 1, 1);
	if (m_BackgroundElement)
		return m_doc->GetRootElement()->CheckIntersection(*m_BackgroundElement, rect);
	return false;
}

void SVGUIControl::Refresh()
{
	wxCommandEvent refresh_evt(wxEVT_COMMAND_ENTER, -1);
	refresh_evt.m_commandString = GetId();
	m_window->ProcessEvent(refresh_evt);
}

wxSVGRect SumBBox(wxSVGRect bbox1, wxSVGRect bbox2)
{
	if (bbox1.GetX() > bbox2.GetX())
	{
		bbox1.SetWidth(bbox1.GetWidth() + bbox1.GetX() - bbox2.GetX());
		bbox1.SetX(bbox2.GetX());
	}
	if (bbox1.GetY() > bbox2.GetY())
	{
		bbox1.SetHeight(bbox1.GetHeight() + bbox1.GetY() - bbox2.GetY());
		bbox1.SetY(bbox2.GetY());
	}
	if (bbox1.GetX() + bbox1.GetWidth() < bbox2.GetX() + bbox2.GetWidth())
		bbox1.SetWidth(bbox2.GetX() + bbox2.GetWidth() - bbox1.GetX());
	if (bbox1.GetY() + bbox1.GetHeight() < bbox2.GetY() + bbox2.GetHeight())
		bbox1.SetHeight(bbox2.GetY() + bbox2.GetHeight() - bbox1.GetY());	
	return bbox1;
}


wxSVGRect SVGUIControl::GetBBox()
{
	wxSVGRect res(0, 0, 0, 0);
	if (m_BackgroundElement)
        res = wxSVGLocatable::GetElementResultBBox(m_BackgroundElement, wxSVG_COORDINATES_VIEWPORT);
	return res;
}

#define SetElementDisplay_macro(the_dtd, the_class)\
		case the_dtd:\
		{\
          ((the_class*) elem)->SetDisplay(value);\
          break;\
		}

void SetDisplay(wxSVGElement* elem, wxCSS_VALUE value)
{
	if (elem)
	{
		switch (elem->GetDtd())
		{
			SetElementDisplay_macro(wxSVG_LINE_ELEMENT, wxSVGLineElement)
			SetElementDisplay_macro(wxSVG_POLYLINE_ELEMENT, wxSVGPolylineElement)
			SetElementDisplay_macro(wxSVG_POLYGON_ELEMENT, wxSVGPolygonElement)
			SetElementDisplay_macro(wxSVG_RECT_ELEMENT, wxSVGRectElement)
			SetElementDisplay_macro(wxSVG_CIRCLE_ELEMENT, wxSVGCircleElement)
			SetElementDisplay_macro(wxSVG_ELLIPSE_ELEMENT, wxSVGEllipseElement)
			SetElementDisplay_macro(wxSVG_PATH_ELEMENT, wxSVGPathElement)
			SetElementDisplay_macro(wxSVG_TEXT_ELEMENT, wxSVGTextElement)
			SetElementDisplay_macro(wxSVG_G_ELEMENT, wxSVGGElement)
            default:
              break;
		}
	}
}

void SVGUIControl::SendMouseEvent(wxMouseEvent& event)
{
	((wxEvtHandler*)this)->ProcessEvent(event);
}

void SVGUIControl::SendKeyEvent(wxKeyEvent& event)
{
	((wxEvtHandler*)this)->ProcessEvent(event);
}

void SVGUIControl::OnLeftDown(wxMouseEvent& event)
{
	wxLogError(wxT("SVGUIControl %s OnLeftDown\n"), GetId().c_str());
	event.Skip();
}
		
void SVGUIControl::OnLeftUp(wxMouseEvent& event)
{
	wxLogError(wxT("SVGUIControl %s OnLeftUp\n"), GetId().c_str());
	event.Skip();
}

void SVGUIControl::OnMotion(wxMouseEvent& event)
{
	wxLogError(wxT("SVGUIControl %s OnMotion\n"), GetId().c_str());
	event.Skip();
}

void SVGUIControl::OnChar(wxKeyEvent& event)
{
	wxLogError(wxT("SVGUIControl %s OnKeyDown\n"), GetId().c_str());
	event.Skip();
}
