/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGUNITBOARDWIDGET_H
#define SKGUNITBOARDWIDGET_H
/** @file
* This file is Skrooge plugin for unit management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgunitpluginwidget_board.h"
#include "skgwidget.h"

/**
 * This file is Skrooge plugin for unit management
 */
class SKGUnitBoardWidget : public SKGWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGUnitBoardWidget (SKGDocument* iDocument );

        /**
         * Default Destructor
         */
        virtual ~SKGUnitBoardWidget();

private slots:
        void dataModified(const QString& iTableName, int iIdTransaction);
        void onOpen(const QString& iLink);

private:
        Q_DISABLE_COPY ( SKGUnitBoardWidget );

        Ui::skgunitplugin_board ui;;
};

#endif // SKGUNITBOARDWIDGET_H
