/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is part of Skrooge and defines the main of skrooge.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"

#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kstandarddirs.h>
#include <KDE/KLocale>
#include <ksplashscreen.h>
#include <kconfiggroup.h>

#include <QBitmap>

/**
 * Description of the application
 */
static const char description[] = I18N_NOOP("Personal finance management tool for KDE4, with the aim of being highly intuitive, while providing powerful functions such as reporting (including graphics), persistent Undo/Redo, encryption, and much more...");

#define VER1_(x) #x
#define VER_(x) VER1_(x)
#define VER VER_(SKGVERSION)

/**
 * The main unique application for skrooge
 */
class KSkroogeApp : public KUniqueApplication
{
public:
        /**
         * Constructor
         * @param iDoc document
         */
        KSkroogeApp(SKGDocumentBank* iDoc) : KUniqueApplication(), splash(NULL), doc(iDoc), widget(NULL) {
                SKGTRACEIN(1, "KSkroogeApp::KSkroogeApp");
        }

        /**
         * Destructor
         */
        ~KSkroogeApp() {
                SKGTRACEIN(1, "KSkroogeApp::~KSkroogeApp");
                splash=NULL;
        }

        /**
         * Create a new instance
         * @return error code
         */
        int newInstance() {
                SKGTRACEIN(1, "KSkroogeApp::newInstance");

                //Build list of arguments
                QStringList argument;
                KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
                int nb=args->count();
                for (int i=0; i<nb ; ++i) {
                        argument.push_back( args->arg(i));
                }
                args->clear(); // Free up some memory.

                //Build widget
                if (!widget) {
                        //Creation splash screen
                        KSharedConfigPtr config=KSharedConfig::openConfig ( "skroogerc" );
                        KConfigGroup pref=config->group ( "skrooge" );

                        if (pref.readEntry ( "show_splash_screen",true )) {
                                //KSplashScreen splash(QPixmap ( KStandardDirs::locate("data", QString::fromLatin1("skrooge/images/splash.png"))),Qt::WindowStaysOnTopHint);
                                QPixmap pix( KStandardDirs::locate("data", QString::fromLatin1("skrooge/images/splash.png")));

                                splash=new KSplashScreen(pix);
                                if (splash) {
                                        splash->setMask(pix.createHeuristicMask());
                                        splash->show();
                                        splash->showMessage(i18n("Loading skrooge ..."), Qt::AlignLeft, QColor(221, 130, 8)); // krazy:exclude=qmethods
                                }
                        }

                        //First instance
                        widget = new SKGMainPanel(splash, doc, argument);
                        widget->show();
                } else {
                        //Set new parameters
                        widget->processArguments(argument);
                }

                if (splash) {
                        splash->finish(widget);
                        delete splash;
                        splash=NULL;
                }

                return 0;
        }

public:
        KSplashScreen* splash;
        SKGDocumentBank* doc;
        SKGMainPanel *widget;
};


/**
 * The main of the application
 * @param argc number of arguments
 * @param argv arguments
 * @return return code
 */
int main(int argc, char **argv)
{
        KAboutData about("skrooge",
                         0,
                         ki18n("Skrooge"),
                         VER,
                         ki18n(description),
                         KAboutData::License_GPL_V3,
                         ki18n("(c) 2007-2009 Stephane MANKOWSKI & Guillaume DE BURE"),
                         KLocalizedString(),
                         "http://extragear.kde.org/apps/skrooge");

        about.addAuthor( ki18n("Stephane MANKOWSKI"), ki18n("Architect & Developer"), "stephane@mankowski.fr" );
        about.addAuthor( ki18n("Guillaume DE BURE"), ki18n("Developer"), "guillaume.debure@gmail.com" );
        about.addCredit( ki18n("Thierry DAUCOURT"), ki18n("Graphist & Tester"), "thdox@users.sourceforge.net" );
        about.setOtherText( ki18n("The application name is inspired by Charles Dicken's tale <i>A Christmas Carol</i>, where the main character, Ebenezer Scrooge, a grumpy old narrow man, gets visited by three ghosts who change the way he sees the world, in a good way."));

        KCmdLineArgs::init(argc, argv, &about);

        KCmdLineOptions options;
        options.add("+[URL]", ki18n( "Document to open" ));
        KCmdLineArgs::addCmdLineOptions(options);

        int rc=0;
        if (!KSkroogeApp::start()) {
                fprintf(stderr, "Skrooge is already running!\n");
        } else {
                //Creating a main panel on a bank document
                SKGDocumentBank doc(SKGDocument::CopiedInFile);
                KSkroogeApp kApp(&doc);

                rc=kApp.exec(); // krazy:exclude=crashy
        }
        SKGTraces::dumpProfilingStatistics();
        return rc;
}
