/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGTABWIDGET_H
#define SKGTABWIDGET_H
/** @file
 * This file is a class managing widget.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <kglobal.h>
#include <QWidget>
#include "skgbasegui_export.h"
#include "skgobjectbase.h"
#include "skgwidget.h"

class SKGMainPanel;

/**
 * This file is Skrooge tab widget used by plugins
 */
class SKGBASEGUI_EXPORT SKGTabWidget : public SKGWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGTabWidget(SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGTabWidget();

        /**
         * Get the current selection
         * MUST BE OVERWRITTEN
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * CAN BE OVERWRITTEN FOR OPTIMIZATION
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

        /**
         * Set the bookmark id
         * @param iId bookmark id
         */
        virtual void setBookmarkID(const QString& iId);

        /**
         * Get the bookmark id
         * @return bookmark id
         */
        virtual QString getBookmarkID();

        /**
         * Overwrite bookmark if page is opened from a bookmark
         * Overwrite context if page is opened from a context
         * @param iNeedUserConfirmation to display a confirmation panel
         */
        virtual void overwrite(bool iNeedUserConfirmation=true);

signals:
        /**
         * This signal must be launched when the selection is modified
         */
        void selectionChanged();

public slots:
        /**
         * Closes this widget
         * @return true if the widget was closed; otherwise returns false.
         */
        virtual bool close();

private:
        Q_DISABLE_COPY(SKGTabWidget);

        QString       bookmarkID;
};

#endif // SKGTABWIDGET_H
