/***************************************************************************
 *   Copyright (C) 2005 by TAM (Teppei Tamra)   *
 *   tam-t@par.odn.ne.jp   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef HONOKASETUPKDE_H
#define HONOKASETUPKDE_H

#define Uses_SCIM_CONFIG_MODULE
#define Uses_SCIM_CONFIG_PATH
#define Uses_SCIM_GLOBAL_CONFIG
#include <scim.h>

#include <qobject.h>
#include <qwidget.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qvaluelist.h>
#include <qlayout.h>
#include <vector>

// for KDE

#define     HonokaSetupItem         HonokaSetupKdeItem
#define     HonokaSetupEntryItem    HonokaSetupKdeEntryItem
#define     HonokaSetupFileItem     HonokaSetupKdeFileItem
#define     HonokaSetupKeyItem      HonokaSetupKdeKeyItem
#define     HonokaSetupBoolItem     HonokaSetupKdeBoolItem
#define     HonokaSetupIntItem      HonokaSetupKdeIntItem
#define     HonokaSetupSelectItem   HonokaSetupKdeSelectItem
#define     HonokaSetupPage         HonokaSetupKdePage
#define     HonokaSetup             HonokaSetupKde

#include <honokasetupcore.h>

/**
@author TAM (Teppei Tamra)
*/

class HonokaSetupKdeItem : public QObject {
Q_OBJECT
public:
    QWidget *getValueWidget();
    QWidget *getLabelWidget();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
    QString getLabel();
    HonokaSetupKdeItem(scim::String _label,scim::String _name,scim::String _tip);
    ~HonokaSetupKdeItem();
protected:
    virtual void createLabelWidget();
    virtual void createValueWidget();
    virtual void createTipWidget();
    //void createWidgets();
    QString label;
    QString name;
    QString tip;
    QWidget *valueWidget;
    QLabel *labelWidget;
signals:
    void changed();
};


class HonokaSetupKdeContainer {
protected:
    HonokaSetupKdeContainer();
    ~HonokaSetupKdeContainer();

    virtual void append(HonokaSetupKdeItem *item);
    QValueList<HonokaSetupKdeItem *> items;
};

class HonokaSetupKdeItem;
class HonokaSetupKde: public HonokaSetupKdeItem ,public HonokaSetupKdeContainer {
Q_OBJECT
public:
    HonokaSetupKde(scim::String _label,scim::String _name,scim::String _tip);
    ~HonokaSetupKde();
    virtual void append(HonokaSetupKdeItem *page);
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
    static HonokaSetupKdeItem *HonokaSetupCoreToKde(Honoka::HonokaSetupCoreItem *item);
protected:
    virtual void createValueWidget();
};

class HonokaSetupKdePage: public HonokaSetupKdeItem ,public HonokaSetupKdeContainer {
public:
    HonokaSetupKdePage(scim::String _label,scim::String _name,scim::String _tip);
    ~HonokaSetupKdePage();
    virtual void append(HonokaSetupKdeItem *item);
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
protected:
    QGridLayout *table;
    QSpacerItem *spacer;
};


class HonokaSetupKdeEntryItem : public HonokaSetupKdeItem {
Q_OBJECT
public:
    HonokaSetupKdeEntryItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default);
    ~HonokaSetupKdeEntryItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    QString stringData;
protected slots:
    void textChanged(const QString &text);
};

class HonokaSetupKdeBoolItem : public HonokaSetupKdeItem {
Q_OBJECT
public:
    HonokaSetupKdeBoolItem(scim::String _label,scim::String _name,scim::String _tip,bool _default);
    ~HonokaSetupKdeBoolItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    bool boolData;
protected slots:
    void clicked();
};

class HonokaSetupKdeFileItem : public HonokaSetupKdeItem {
Q_OBJECT
public:
    HonokaSetupKdeFileItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default);
    ~HonokaSetupKdeFileItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    QString stringData;
    QLineEdit *le;
protected slots:
    void textChanged(const QString &text);
    void buttonClicked();
};

class HonokaSetupKdeKeyItem : public HonokaSetupKdeItem {
Q_OBJECT
public:
    HonokaSetupKdeKeyItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default);
    ~HonokaSetupKdeKeyItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    QString stringData;
    QLineEdit *le;
protected slots:
    void textChanged(const QString &text);
    void buttonClicked();
};

class HonokaSetupKdeIntItem : public HonokaSetupKdeItem {
Q_OBJECT
public:
    HonokaSetupKdeIntItem(scim::String _label,scim::String _name,scim::String _tip,int _default,int lower,int upper);
    ~HonokaSetupKdeIntItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
    int intData;
    int upperValue;
    int lowerValue;
protected:
    virtual void createValueWidget();
protected slots:
    void valueChanged(int value);
};

class HonokaSetupKdeSelectItem : public HonokaSetupKdeItem {
Q_OBJECT
public:
    HonokaSetupKdeSelectItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default,std::vector<scim::String> _list);
    ~HonokaSetupKdeSelectItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    QString stringData;
    QStringList list;
protected slots:
    void activated(int pos);
};



#endif
