/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "gnubversion-nautilus-menu.gob"

/*
    GnubVersion - Gnome interface to SubVersion
    Copyright (C) 2007  Karl E. Jorgensen <karl@jorgensen.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#line 27 "gnubversion-nautilus-menu.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gnubversion-nautilus-menu.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 23 "gnubversion-nautilus-menu.gob"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#define LOG_DOMAIN "gnubversion-nautilus"

#include <gnubversion.h>

#include <libgnomevfs/gnome-vfs-utils.h>
#include <stdio.h>
#include <assert.h>
#include <gnome.h>

#include "dirtyhack.h"

#line 62 "gnubversion-nautilus-menu.c"

#line 43 "gnubversion-nautilus-menu.gob"


#line 67 "gnubversion-nautilus-menu.c"

#line 46 "gnubversion-nautilus-menu.gob"

#include <svn_wc.h>

static char *files_key = "files";
static char *folder_key = "folder";
static char *relevant_key = "relevant";

static NautilusMenuItem *
create_menu_item( 
            NautilusMenuProvider *provider,
            char *folder,
            GList *files,
            guint32 *relevant,
            int relevant_size,
            const char *info,
            const char *menutext,
            const char *hint,
            const char *icon,
            void (* callback)(NautilusMenuItem *item, gpointer user_data)
        )
{
    NautilusMenuItem *item = NULL;

    item = nautilus_menu_item_new (info,
                                   menutext,
                                   hint,
                                   icon);
    assert(item != NULL);

    if ( (callback != NULL)  && ( provider != NULL) )
    {
        g_signal_connect (item, 
              "activate",
              G_CALLBACK (callback),
              provider);
    }

    if (folder != NULL) 
    {
        g_object_set_data_full (G_OBJECT (item), 
              folder_key,
              folder,
              (GDestroyNotify) g_free);
    }

    if (files != NULL) 
    {
        g_object_set_data_full (G_OBJECT (item), 
              files_key,
              nautilus_file_info_list_copy (files),
              (GDestroyNotify) nautilus_file_info_list_free);
    }

    if (relevant != NULL) 
    {
        guint32 *relevant_new = g_malloc(relevant_size * sizeof(guint32));

        memcpy(relevant_new, relevant, relevant_size * sizeof(guint32));
        g_object_set_data_full (G_OBJECT (item), 
              relevant_key,
              relevant_new,
              (GDestroyNotify) g_free);
    }

    return item;
}

static void
checkout_callback (NautilusMenuItem *item,
              gpointer          user_data)
{
    char            *folder;

    folder = g_object_get_data (G_OBJECT (item), folder_key);
    folder = gnome_vfs_get_local_path_from_uri(folder);

#ifndef NDEBUG
    g_print("checkout_callback for folder \"%s\"\n", folder);
#endif

    char *new_argv[] = { "gvn-checkout", NULL };

    int pid = gnome_execute_async( folder, 1, new_argv);

#ifndef NDEBUG
    printf("pid = %d\n", pid);
#endif
    if (pid == -1)
        gnubversion_linux_error(NULL, errno, _("Cannot execute %s"), new_argv[0]);

    g_free(folder);
}

static NautilusMenuItem *
create_item_checkout( 
    NautilusMenuProvider *provider,
    NautilusFileInfo *folder
)
{
    return create_menu_item(  provider,
                        nautilus_file_info_get_uri (folder),
                        NULL,
                        NULL,
                        0,
                        "GnubVersion::Checkout",
                        _("SVN Checkout"),
                        _("Check out a subversion project"),
                        "gvn-checkout",
                        checkout_callback
                        );
}

static void
generic_folder_callback (
    NautilusMenuItem *item,
    char *command)
{
    char            *folder;

    folder = g_object_get_data (G_OBJECT (item), folder_key);
    folder = gnome_vfs_get_local_path_from_uri(folder);

#ifndef NDEBUG
    g_print("generic_folder_callback for folder \"%s\"\n", folder);
#endif

    char *new_argv[] = { command, folder, NULL };

    int pid = gnome_execute_async( folder, 2, new_argv);

#ifndef NDEBUG
    printf("pid = %d\n", pid);
#endif
    if (pid == -1)
        gnubversion_linux_error(NULL, errno, _("Cannot execute %s"), new_argv[0]);

    g_free(folder);
}

static void
commit_folder_callback (
    NautilusMenuItem *item,
    gpointer          user_data)
{
    generic_folder_callback(item, "gvn-commit");
}

static NautilusMenuItem *
create_item_commit_folder( 
    NautilusMenuProvider *provider,
    NautilusFileInfo *folder,
    const char *identifier
)
{
    return create_menu_item(  provider,
                        nautilus_file_info_get_uri (folder),
                        NULL,
                        NULL,
                        0,
                        identifier,
                        _("Commit"),
                        _("Commit changes to subversion repository"),
                        "gvn-commit",
                        commit_folder_callback
                        );
}

static void
update_folder_callback (
    NautilusMenuItem *item,
    gpointer          user_data)
{
    generic_folder_callback(item, "gvn-update");
}

static NautilusMenuItem *
create_item_update_folder( 
    NautilusMenuProvider *provider,
    NautilusFileInfo *folder,
    char *identifier
)
{
    return create_menu_item(  provider,
                        nautilus_file_info_get_uri (folder),
                        NULL,
                        NULL,
                        0,
                        identifier,
                        _("Update"),
                        _("Update working copy with changes from the subversion repository"),
                        "gvn-update",
                        update_folder_callback
                        );
}

static void
multi_items_callback (
    NautilusMenuItem *item,
    char *command,
    guint32 mask)
{
    GList *files;
    files = g_object_get_data (G_OBJECT (item), files_key);

    guint32 *relevant;
    relevant = g_object_get_data (G_OBJECT (item), relevant_key);

    int file_count;
    file_count = g_list_length(files);

    gvn_debug("commit_items_callback - file_count = %d", file_count);

    char **new_argv;
    int argc;

    new_argv = g_malloc( ( file_count + 2) * sizeof(char *));
    new_argv[0] = command;

    int relevant_idx;

    for (argc = 1, relevant_idx = 0; files != NULL; files = files->next, relevant_idx++)
    {
        if (relevant[relevant_idx] & mask)
        {
            NautilusFileInfo *info = files->data;
            char *uri;
            char *path;

            uri = nautilus_file_info_get_uri(info);
            path = gnome_vfs_get_local_path_from_uri(uri);
            if (path != NULL)
            {
                new_argv[argc] = g_strdup(path);
#ifndef NDEBUG
                printf("new argv[%d] =  '%s'", argc, new_argv[argc]);
#endif
                argc++;
            }

            g_free(uri);
        }
    }
    new_argv[argc] = NULL;

    if (argc == 0)
        g_critical("Internal error: no file names forward to command %s", command);

    int pid = gnome_execute_async( NULL, argc, new_argv);

#ifndef NDEBUG
    printf("pid = %d\n", pid);
#endif
    if (pid == -1)
        gnubversion_linux_error(NULL, errno, _("Cannot execute %s"), new_argv[0]);

    /* Free up the newly allocated argv array */
    int i;
    for (i = 1; i < argc; i++)
    {
        g_free(new_argv[i]);
    }
    g_free(new_argv);
}

static void
commit_items_callback (
    NautilusMenuItem *item,
    gpointer          user_data)
{
    multi_items_callback(item, "gvn-commit", GVN_ACTION_COMMIT);
}

static void
update_items_callback (
    NautilusMenuItem *item,
    gpointer          user_data)
{
    multi_items_callback(item, "gvn-update", GVN_ACTION_UPDATE);
}

static void
add_items_callback (
    NautilusMenuItem *item,
    gpointer          user_data)
{
    multi_items_callback(item, "gvn-add", GVN_ACTION_ADD);
}

static void
remove_items_callback (
    NautilusMenuItem *item,
    gpointer          user_data)
{
    multi_items_callback(item, "gvn-remove", GVN_ACTION_DELETE);
}

static void
revert_items_callback (
    NautilusMenuItem *item,
    gpointer          user_data)
{
    multi_items_callback(item, "gvn-revert", GVN_ACTION_REVERT);
}

static NautilusMenuItem *
create_item_commit_items(
    NautilusMenuProvider *provider,
    GList *files,
    guint *relevant,
    int relevant_size
)
{
    gvn_debug("%d files selected", relevant_size);
    return create_menu_item(
        provider,
        NULL,
        files,
        relevant,
        relevant_size,
        "GnubVersion::CommitItems",
        _("Commit"),
        _("Commit the selected files to the subversion repository"),
        "gvn-commit",
        commit_items_callback);
}

static NautilusMenuItem *
create_item_update_items(
    NautilusMenuProvider *provider,
    GList *files,
    guint *relevant,
    int relevant_size
)
{
    return create_menu_item(
        provider,
        NULL,
        files,
        relevant,
        relevant_size,
        "GnubVersion::UpdateItems",
        _("Update"),
        _("Update the selected files with updates from the subversion repository"),
        "gvn-update",
        update_items_callback);
}
static NautilusMenuItem *
create_item_add_items(
    NautilusMenuProvider *provider,
    GList *files,
    guint *relevant,
    int relevant_size
)
{
    return create_menu_item(
        provider,
        NULL,
        files,
        relevant,
        relevant_size,
        "GnubVersion::AddItems",
        _("Add"),
        _("Schedule the selected files for addition to the subversion repository"),
        "gvn-add",
        add_items_callback);
}
static NautilusMenuItem *
create_item_remove_items(
    NautilusMenuProvider *provider,
    GList *files,
    guint *relevant,
    int relevant_size
)
{
    return create_menu_item(
        provider,
        NULL,
        files,
        relevant,
        relevant_size,
        "GnubVersion::RemoveItems",
        _("Remove"),
        _("Schedule the selected files for removal from the subversion repository"),
        "gvn-remove",
        remove_items_callback);
}
static NautilusMenuItem *
create_item_revert_items(
    NautilusMenuProvider *provider,
    GList *files,
    guint *relevant,
    int relevant_size
)
{
    return create_menu_item(
        provider,
        NULL,
        files,
        relevant,
        relevant_size,
        "GnubVersion::RevertItems",
        _("Revert"),
        _("Reverse out any local changes to the selected files"),
        "gvn-revert",
        revert_items_callback);
}

#line 477 "gnubversion-nautilus-menu.c"
/* self casting macros */
#define SELF(x) GNUBVERSION_NAUTILUS_MENU(x)
#define SELF_CONST(x) GNUBVERSION_NAUTILUS_MENU_CONST(x)
#define IS_SELF(x) GNUBVERSION_IS_NAUTILUS_MENU(x)
#define TYPE_SELF GNUBVERSION_TYPE_NAUTILUS_MENU
#define SELF_CLASS(x) GNUBVERSION_NAUTILUS_MENU_CLASS(x)

#define SELF_GET_CLASS(x) GNUBVERSION_NAUTILUS_MENU_GET_CLASS(x)

/* self typedefs */
typedef GnubVersionNautilusMenu Self;
typedef GnubVersionNautilusMenuClass SelfClass;

/* here are local prototypes */
static void gnubversion_nautilus_menu_init (GnubVersionNautilusMenu * o) G_GNUC_UNUSED;
static void gnubversion_nautilus_menu_class_init (GnubVersionNautilusMenuClass * c) G_GNUC_UNUSED;
static GList * gnubversion_nautilus_menu_get_file_items (NautilusMenuProvider * provider, GtkWidget * window, GList * files) G_GNUC_UNUSED;
static GList * gnubversion_nautilus_menu_get_background_items (NautilusMenuProvider * provider, GtkWidget * window, NautilusFileInfo * current_folder) G_GNUC_UNUSED;
static GList * gnubversion_nautilus_menu_get_toolbar_items (NautilusMenuProvider * provider, GtkWidget * window, NautilusFileInfo * current_folder) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_file_items gnubversion_nautilus_menu_get_file_items
#define self_get_background_items gnubversion_nautilus_menu_get_background_items
#define self_get_toolbar_items gnubversion_nautilus_menu_get_toolbar_items


static void
___Nautilus_Menu_Provider_init (NautilusMenuProviderIface *iface)
{
#line 463 "gnubversion-nautilus-menu.gob"
	iface->get_file_items = self_get_file_items;
#line 541 "gnubversion-nautilus-menu.gob"
	iface->get_background_items = self_get_background_items;
#line 574 "gnubversion-nautilus-menu.gob"
	iface->get_toolbar_items = self_get_toolbar_items;
#line 516 "gnubversion-nautilus-menu.c"
}

GType
gnubversion_nautilus_menu_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GnubVersionNautilusMenuClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnubversion_nautilus_menu_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GnubVersionNautilusMenu),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gnubversion_nautilus_menu_init,
			NULL
		};

		static const GInterfaceInfo Nautilus_Menu_Provider_info = {
			(GInterfaceInitFunc) ___Nautilus_Menu_Provider_init,
			NULL,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GnubVersionNautilusMenu", &info, (GTypeFlags)0);
		g_type_add_interface_static (type,
			NAUTILUS_TYPE_MENU_PROVIDER,
			&Nautilus_Menu_Provider_info);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GnubVersionNautilusMenu *)g_object_new(gnubversion_nautilus_menu_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GnubVersionNautilusMenu * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GnubVersionNautilusMenu *
GET_NEW_VARG (const char *first, ...)
{
	GnubVersionNautilusMenu *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GnubVersionNautilusMenu *)g_object_new_valist (gnubversion_nautilus_menu_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
gnubversion_nautilus_menu_init (GnubVersionNautilusMenu * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GnubVersion:Nautilus:Menu::init"
	o->_priv = NULL;
}
#undef __GOB_FUNCTION__
static void 
gnubversion_nautilus_menu_class_init (GnubVersionNautilusMenuClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GnubVersion:Nautilus:Menu::class_init"

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

}
#undef __GOB_FUNCTION__



#line 463 "gnubversion-nautilus-menu.gob"
static GList * 
gnubversion_nautilus_menu_get_file_items (NautilusMenuProvider * provider, GtkWidget * window, GList * files)
#line 592 "gnubversion-nautilus-menu.c"
{
#define __GOB_FUNCTION__ "GnubVersion:Nautilus:Menu::get_file_items"
{
#line 468 "gnubversion-nautilus-menu.gob"
	
	GList            *items = NULL;
	NautilusMenuItem *item = NULL;
        int file_count;

#ifndef NDEBUG
        printf("get_file_items\n");
#endif

        file_count = g_list_length(files);

        if (file_count > 0)
        {
            guint32 *relevant = g_malloc(file_count  * sizeof(guint32));
            guint32 relevant_total = 0;
            
            GList *l;
            int i;
            for (l = files, i=0; l != NULL; l = l->next, i++) // loop through the list
            {
                NautilusFileInfo *info = l->data;
                char *uri = nautilus_file_info_get_uri(info);
                relevant[i] = gnubversion_relevant_actions_uri(uri);
                relevant_total |= relevant[i];
                g_free(uri);
            }

            if ( (relevant_total & GVN_ACTION_COMMIT) 
                && (item = create_item_commit_items(provider, files, relevant, file_count)) != NULL)
                items = g_list_append (items, item);
                
            if ( (relevant_total & GVN_ACTION_UPDATE) 
                && (item = create_item_update_items(provider, files, relevant, file_count)) != NULL)
                items = g_list_append (items, item);

            if ( (relevant_total & GVN_ACTION_ADD)
                && (item = create_item_add_items(provider, files, relevant, file_count)) != NULL)
                items = g_list_append (items, item);

            if ( (relevant_total & GVN_ACTION_DELETE) 
                && (item = create_item_remove_items(provider, files, relevant, file_count)) != NULL)
                items = g_list_append (items, item);

            if ( (relevant_total & GVN_ACTION_REVERT) 
                && (item = create_item_revert_items(provider, files, relevant, file_count)) != NULL)
                items = g_list_append (items, item);

            g_free(relevant);
        }

#define USE_MENU 0
#if USE_MENU
        /* Create a submenu */
        NautilusMenu     *menu = NULL;
        menu = nautilus_menu_new();
        item = create_menu_item(NULL, NULL, NULL, 0, "GnubVersion::Menu", _("Subversion"), _("Subversion stuff"), NULL, NULL);
        nautilus_menu_item_set_submenu(item, menu);

        items = g_list_append(items, item);

        item = nautilus_menu_item_new("GnubVersion", _("Subversion"), _("Subversion interface"), NULL);
        nautilus_menu_append_item(menu, item);
#endif

        return items;
    }}
#line 663 "gnubversion-nautilus-menu.c"
#undef __GOB_FUNCTION__

#line 541 "gnubversion-nautilus-menu.gob"
static GList * 
gnubversion_nautilus_menu_get_background_items (NautilusMenuProvider * provider, GtkWidget * window, NautilusFileInfo * current_folder)
#line 669 "gnubversion-nautilus-menu.c"
{
#define __GOB_FUNCTION__ "GnubVersion:Nautilus:Menu::get_background_items"
{
#line 546 "gnubversion-nautilus-menu.gob"
	
        GList *items = NULL;
        gchar            *uri;
        uri = nautilus_file_info_get_uri (current_folder);
#ifndef NDEBUG
        g_print("get_background_items: %s\n", uri);
#endif

        guint32 relevant = gnubversion_relevant_actions_uri(uri);
#ifndef NDEBUG
        {
            GString *r = gnubversion_relevant_string(relevant);
            printf("Relevant: %s\n", r->str);
            g_string_free(r, TRUE);
        }
#endif
        if (relevant & GVN_ACTION_CHECKOUT)
            items = g_list_append(items, create_item_checkout(provider, current_folder));
        if (relevant & GVN_ACTION_UPDATE)
            items = g_list_append(items, create_item_update_folder(provider, current_folder, "GnubVersion::UpdateBG"));
        if (relevant & GVN_ACTION_COMMIT)
            items = g_list_append(items, create_item_commit_folder(provider, current_folder, "GnubVersion::CommitBG"));

        g_free(uri);
        return items;
    }}
#line 700 "gnubversion-nautilus-menu.c"
#undef __GOB_FUNCTION__

#line 574 "gnubversion-nautilus-menu.gob"
static GList * 
gnubversion_nautilus_menu_get_toolbar_items (NautilusMenuProvider * provider, GtkWidget * window, NautilusFileInfo * current_folder)
#line 706 "gnubversion-nautilus-menu.c"
{
#define __GOB_FUNCTION__ "GnubVersion:Nautilus:Menu::get_toolbar_items"
{
#line 579 "gnubversion-nautilus-menu.gob"
	
        GList *items = NULL;
        gchar            *uri;
        uri = nautilus_file_info_get_uri (current_folder);
#ifndef NDEBUG
        g_print("get_toolbar_items: %s\n", uri);
#endif
        guint32 relevant = gnubversion_relevant_actions_uri(uri);

        if (relevant & GVN_ACTION_UPDATE)
            items = g_list_append(items, create_item_update_folder(provider, current_folder, "GnubVersion::UpdateToolBar"));
        if (relevant & GVN_ACTION_COMMIT)
            items = g_list_append(items, create_item_commit_folder(provider, current_folder, "GnubVersion::CommitToolBar"));

        g_free(uri);

        // return nautilus_menu_provider_get_background_items(provider, window, current_folder);
        return items;
    }}
#line 730 "gnubversion-nautilus-menu.c"
#undef __GOB_FUNCTION__

#line 600 "gnubversion-nautilus-menu.gob"


#line 736 "gnubversion-nautilus-menu.c"
