/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "gnubversion-nautilus-info.gob"

/*
    GnubVersion - Gnome interface to SubVersion
    Copyright (C) 2007  Karl E. Jorgensen <karl@jorgensen.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#line 27 "gnubversion-nautilus-info.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gnubversion-nautilus-info.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 23 "gnubversion-nautilus-info.gob"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#define LOG_DOMAIN "gnubversion-nautilus"

#include <gnubversion.h>

#include <libgnomevfs/gnome-vfs-utils.h>
#include <stdio.h>
#include <assert.h>
#include <gnome.h>

#include "dirtyhack.h"


#line 63 "gnubversion-nautilus-info.c"

#line 46 "gnubversion-nautilus-info.gob"

#include <gnubversion-status.h>

#line 69 "gnubversion-nautilus-info.c"

#line 50 "gnubversion-nautilus-info.gob"

#include <svn_wc.h>

#include "columnnames.h"

#line 77 "gnubversion-nautilus-info.c"
/* self casting macros */
#define SELF(x) GNUBVERSION_NAUTILUS_INFO(x)
#define SELF_CONST(x) GNUBVERSION_NAUTILUS_INFO_CONST(x)
#define IS_SELF(x) GNUBVERSION_IS_NAUTILUS_INFO(x)
#define TYPE_SELF GNUBVERSION_TYPE_NAUTILUS_INFO
#define SELF_CLASS(x) GNUBVERSION_NAUTILUS_INFO_CLASS(x)

#define SELF_GET_CLASS(x) GNUBVERSION_NAUTILUS_INFO_GET_CLASS(x)

/* self typedefs */
typedef GnubVersionNautilusInfo Self;
typedef GnubVersionNautilusInfoClass SelfClass;

/* here are local prototypes */
static void gnubversion_nautilus_info_init (GnubVersionNautilusInfo * o) G_GNUC_UNUSED;
static void gnubversion_nautilus_info_class_init (GnubVersionNautilusInfoClass * c) G_GNUC_UNUSED;
static NautilusOperationResult gnubversion_nautilus_info_update_file_info (NautilusInfoProvider * provider, NautilusFileInfo * file, GClosure * update_complete, NautilusOperationHandle ** handle) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_update_file_info gnubversion_nautilus_info_update_file_info


static void
___Nautilus_Info_Provider_init (NautilusInfoProviderIface *iface)
{
#line 60 "gnubversion-nautilus-info.gob"
	iface->update_file_info = self_update_file_info;
#line 108 "gnubversion-nautilus-info.c"
}

GType
gnubversion_nautilus_info_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GnubVersionNautilusInfoClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnubversion_nautilus_info_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GnubVersionNautilusInfo),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gnubversion_nautilus_info_init,
			NULL
		};

		static const GInterfaceInfo Nautilus_Info_Provider_info = {
			(GInterfaceInitFunc) ___Nautilus_Info_Provider_init,
			NULL,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GnubVersionNautilusInfo", &info, (GTypeFlags)0);
		g_type_add_interface_static (type,
			NAUTILUS_TYPE_INFO_PROVIDER,
			&Nautilus_Info_Provider_info);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GnubVersionNautilusInfo *)g_object_new(gnubversion_nautilus_info_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GnubVersionNautilusInfo * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GnubVersionNautilusInfo *
GET_NEW_VARG (const char *first, ...)
{
	GnubVersionNautilusInfo *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GnubVersionNautilusInfo *)g_object_new_valist (gnubversion_nautilus_info_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
gnubversion_nautilus_info_init (GnubVersionNautilusInfo * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GnubVersion:Nautilus:Info::init"
	o->_priv = NULL;
}
#undef __GOB_FUNCTION__
static void 
gnubversion_nautilus_info_class_init (GnubVersionNautilusInfoClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GnubVersion:Nautilus:Info::class_init"

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

}
#undef __GOB_FUNCTION__



#line 60 "gnubversion-nautilus-info.gob"
static NautilusOperationResult 
gnubversion_nautilus_info_update_file_info (NautilusInfoProvider * provider, NautilusFileInfo * file, GClosure * update_complete, NautilusOperationHandle ** handle)
#line 184 "gnubversion-nautilus-info.c"
{
#define __GOB_FUNCTION__ "GnubVersion:Nautilus:Info::update_file_info"
{
#line 66 "gnubversion-nautilus-info.gob"
	
        const char *text_status_attribute = NULL;
        const char *prop_status_attribute = NULL;
        GString *revision_attribute = NULL;
        GString *repos_revision_attribute = NULL;

        char *uri = nautilus_file_info_get_uri(file);
#ifndef NDEBUG
        g_print("update_file_info: %s\n", uri);
#endif

        char *uri_scheme = nautilus_file_info_get_uri_scheme(file);
#ifndef NDEBUG
        g_print("update_file_info: scheme %s\n", uri_scheme);
#endif
        if (strcmp(uri_scheme, "file") != 0)
            text_status_attribute = prop_status_attribute = _("n/a (remote)");
        else {
            GnubVersionStatus *gvs;

            gvs = gnubversion_status_new_from_uri(uri);

            text_status_attribute = prop_status_attribute = _("internal error");

            if (gvs->error) {
                if ( (gvs->error->domain == GNUBVERSION_QUARK_SVN)
                    && (gvs->error->code == SVN_ERR_WC_NOT_DIRECTORY) )
                    text_status_attribute = prop_status_attribute = _("n/a");
                else
                    text_status_attribute = prop_status_attribute = gvs->error->message;
            } else if ( (gvs->status != NULL) ) {
                text_status_attribute = statuskind (gvs->status -> text_status);
                prop_status_attribute = statuskind (gvs->status -> prop_status);
                if (gvs->status->entry) {
                    revision_attribute = gnubversion_revision_to_string(gvs->status->entry->revision);
                    repos_revision_attribute = gnubversion_revision_to_string(gvs->status->entry->cmt_rev);
                }
            }
            // FIXME: *gvs needs to be freed
        }

        if (text_status_attribute != NULL)
            nautilus_file_info_add_string_attribute(file, 
                                                    nautilus_column_attribute_gvn_text_status, 
                                                    text_status_attribute);
        if (prop_status_attribute != NULL)
            nautilus_file_info_add_string_attribute(file, 
                                                    nautilus_column_attribute_gvn_prop_status, 
                                                    prop_status_attribute);

        if (revision_attribute != NULL) {
            nautilus_file_info_add_string_attribute(file, 
                                                    nautilus_column_attribute_gvn_revision, 
                                                    revision_attribute->str);
            g_string_free(revision_attribute, TRUE);
        } else {
            nautilus_file_info_add_string_attribute(file, 
                                                    nautilus_column_attribute_gvn_revision, 
                                                    _("n/a"));
        }
            
        if (repos_revision_attribute != NULL) {
            nautilus_file_info_add_string_attribute(file, 
                                                    nautilus_column_attribute_gvn_repos_revision, 
                                                    repos_revision_attribute->str);
            g_string_free(repos_revision_attribute, TRUE);
        } else {
            nautilus_file_info_add_string_attribute(file, 
                                                    nautilus_column_attribute_gvn_repos_revision, 
                                                    _("n/a"));
        }

        g_free(uri_scheme);
        g_free(uri);

        return NAUTILUS_OPERATION_COMPLETE;
    }}
#line 266 "gnubversion-nautilus-info.c"
#undef __GOB_FUNCTION__

#line 145 "gnubversion-nautilus-info.gob"


#line 272 "gnubversion-nautilus-info.c"
