#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnubversion.h>
#include <gnome.h>
#include <assert.h>

#define APP_NAME "testprogress"

static int do_cancel = FALSE;

/* Little "worker" thread.
 * This thread simulates a background task with a few important characteristics:
 * - it can be cancelled
 * - it will send messages to the progress window
 */
gpointer 
thread_main (gpointer thread_arg)
{
    GnubVersionProgressWindow *win = thread_arg;
    GnubVersionThreadMessage *msg;
    int i;

    for (i = 0; (i < 10) && !do_cancel; i++)
    {
        msg = gnubversion_threadmessage_new_info("ticktock %d", i);
        gnubversion_progresswindow_send_message(win, msg);
        sleep(1);
    }

    if (do_cancel)
    {
        GError *err = g_error_new(g_quark_from_string("testing"),7, "Cancel Requested");
        msg = gnubversion_threadmessage_new_bye_error(err);
    }
    else
        msg = gnubversion_threadmessage_new_bye_success("Final byes");

    gnubversion_progresswindow_send_message(win,msg);
    return NULL;
}

static void 
on_progress_closed(GnubVersionProgressWindow *win, gpointer userdata)
{
    g_message("progress_closed signal emitted");
    gtk_main_quit();
}

static void
on_cancel_requested(GnubVersionProgressWindow *win, gpointer userdata)
{
    g_message("cancel_requested signal emitted");
    
    GnubVersionThreadMessage *msg;
    msg = gnubversion_threadmessage_new_info("Cancelling test");
    gnubversion_progresswindow_send_message(win,msg);

    do_cancel = TRUE;
}

static void
on_task_finished(GnubVersionProgressWindow *win, gboolean success, gpointer userdata)
{
    g_message("task_finished signal emitted: %s", success ? "ok" : "failed");
}

int 
main (
    int argc, 
    char **argv, 
    char **env
    )
{
    #ifdef ENABLE_NLS
        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        textdomain (PACKAGE);
    #endif

    GnomeProgram *my_app;

    my_app = gnome_program_init(APP_NAME, VERSION,
                                LIBGNOMEUI_MODULE, argc, argv,
                                GNOME_PARAM_NONE);
    gnubversion_init();

    GnubVersionProgressWindow *win;
    win = gnubversion_progresswindow_new("Getting ready");
    assert(win != NULL);

    gnubversion_progresswindow_connect__window_closed(win, on_progress_closed, NULL);
    gnubversion_progresswindow_connect__cancel_requested(win, on_cancel_requested, NULL);
    gnubversion_progresswindow_connect__task_finished(win, on_task_finished, NULL);

    gtk_window_set_title ( GTK_WINDOW (win), "Progress Window Test");

    gtk_widget_show(GTK_WIDGET(win));
    GThread *thread;
    thread = g_thread_create ( thread_main, win, TRUE, NULL );
    assert ( thread != NULL );

    gtk_main();

    g_thread_join(thread);

    assert (gnubversion_progresswindow_is_task_finished(win));
    
    g_message ("Was task successfull? %s", gnubversion_progresswindow_was_task_successfull(win) 
                                        ? "Yes" : "No");
    gvn_debug("unreffing window %p", win);
    g_object_unref(win);
    gvn_debug("Window unreffed %p", win);

    gnubversion_shutdown();
    g_object_unref (my_app);
    return 0;
}
