#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnubversion.h>
#include <gnome.h>
#include <assert.h>

#define APP_NAME "test-fileselector"

static void
init_test(void)
{
    GnubVersionFileSelector *fs = GNUBVERSION_FILESELECTOR(gnubversion_get_widget("fileselector"));
    GnubVersionFileSelectorStore *store = gnubversion_fileselectorstore_new();

    gnubversion_fileselectorstore_append (store, TRUE, "/some/long/path", "somepath", "yip", "yep");
    gnubversion_fileselectorstore_append (store, FALSE, "/some/other/path", "otherepath", "doh", "bah");
    gnubversion_fileselectorstore_append (store, FALSE, "/yet/other/path", "yotherepath", "boh", "wah");
    gnubversion_fileselectorstore_append (store, FALSE, "/yet/other/path", "yotherepath", "bah", "wuh");
    gnubversion_fileselectorstore_append (store, FALSE, "/yadda/dah", "yadda-dah", "wah", "huh");

    gnubversion_fileselector_set_model( fs, store);
}

static void 
dump_test(void)
{
    GnubVersionFileSelector *fs = GNUBVERSION_FILESELECTOR(gnubversion_get_widget("fileselector"));
    GnubVersionFileSelectorStore *store = gnubversion_fileselector_get_model(fs);
    const char **names = gnubversion_fileselectorstore_get_ticked_fullnames(store);
    
    const char **p;
    for (p = names; *p != NULL; p++)
    {
        gvn_debug("Name ticked: %s", *p);
    }
}

int 
main (
    int argc, 
    char **argv, 
    char **env
    )
{
    #ifdef ENABLE_NLS
        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        textdomain (PACKAGE);
    #endif

    GnomeProgram *my_app;

    my_app = gnome_program_init(APP_NAME, VERSION,
                                LIBGNOMEUI_MODULE, argc, argv,
                                GNOME_PARAM_NONE);
    gnubversion_init_with_glade(APP_NAME);

    printf("karl was here\n");

    init_test();
    gtk_widget_show (gnubversion_get_widget("window"));

    gtk_main();
    dump_test();

    gnubversion_shutdown();
    g_object_unref (my_app);
    return 0;
}
