#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-statuskind.h"

#include <glib/gi18n.h>

const char *statuskind (enum svn_wc_status_kind kind)
{
    switch (kind)
    {
        case svn_wc_status_none:       return _("none");
        case svn_wc_status_unversioned:return _("not versioned");
        case svn_wc_status_normal:     return _("exists, but uninteresting");
        case svn_wc_status_added:      return _("is scheduled for addition");
        case svn_wc_status_missing:    return _("missing");
        case svn_wc_status_deleted:    return _("scheduled for deletion");
        case svn_wc_status_replaced:   return _("was deleted and then re-added");
        case svn_wc_status_modified:   return _("locally modified");
        case svn_wc_status_merged:     return _("local mods received repos mods");
        case svn_wc_status_conflicted: return _("local mods received conflicting repos mods");
        case svn_wc_status_ignored:    return _("unversioned but configured to be ignored");
        case svn_wc_status_obstructed: return _("unversioned resource is in the way of the versioned resource");
        case svn_wc_status_external:   return _("unversioned path populated by an svn:externals property");
        case svn_wc_status_incomplete: return _("directory doesn't contain a complete entries list");
        default:
            g_error(_("Internal Error: unknown svn_wc_status_kind value %d"), kind);
            return NULL;
    }
}

gboolean statuskind_committable(enum svn_wc_status_kind kind)
{
    switch (kind)
    {
        case svn_wc_status_none:        return FALSE;
        case svn_wc_status_unversioned: return FALSE;
        case svn_wc_status_normal:      return FALSE;
        case svn_wc_status_added:       return TRUE;
        case svn_wc_status_missing:     return FALSE;
        case svn_wc_status_deleted:     return TRUE;
        case svn_wc_status_replaced:    return TRUE;
        case svn_wc_status_modified:    return TRUE;
        case svn_wc_status_merged:      return TRUE;
        case svn_wc_status_conflicted:  return FALSE;
        case svn_wc_status_ignored:     return FALSE;
        case svn_wc_status_obstructed:  return FALSE;
        case svn_wc_status_external:    return FALSE;
        case svn_wc_status_incomplete:  return FALSE;
        default:
            g_error(_("Internal Error: unknown svn_wc_status_kind value %d"), kind);
            return FALSE;
    }
}
