#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-notify-action.h"

#include <assert.h>

struct map_entry 
{
    svn_wc_notify_action_t action;
    const char *long_desc;
    const char *short_desc;
};

static struct map_entry map[] = {
  { svn_wc_notify_add,
    "Adding a path to revision control.",
    "Add" },
  { svn_wc_notify_copy,
    "Copying a versioned path.",
    "Copy" },
  { svn_wc_notify_delete,
    "Deleting a versioned path.",
    "Del" },
  { svn_wc_notify_restore,
    "Restoring a missing path from the pristine text-base.",
    "Rest" },
  { svn_wc_notify_revert,
    "Reverting a modified path.",
    "Rev" },
  { svn_wc_notify_failed_revert,
    "A revert operation has failed.",
    "!Rev" },
  { svn_wc_notify_resolved,
    "Resolving a conflict.",
    "Rlvd" },
  { svn_wc_notify_skip,
    "Skipping a path.",
    "Skip" },
  { svn_wc_notify_update_delete,
    "Got a delete in an update.",
    "Del" },
  { svn_wc_notify_update_add,
    "Got an add in an update.",
    "Add" },
  { svn_wc_notify_update_update,
    "Got any other action in an update.",
    "Upd" },
  { svn_wc_notify_update_completed,
    "The last notification in an update (including updates of externals).",
    "Last" },
  { svn_wc_notify_update_external,
    "Updating an external module.",
    "XUpd" },
  { svn_wc_notify_status_completed,
    "The last notification in a status (including status on externals).",
    "Last" },
  { svn_wc_notify_status_external,
    "Running status on an external module.",
    "XStat}" },
  { svn_wc_notify_commit_modified,
    "Committing a modification.",
    "Commit" },
  { svn_wc_notify_commit_added,
    "Committing an addition.",
    "Commit" },
  { svn_wc_notify_commit_deleted,
    "Committing a deletion.",
    "Commit" },
  { svn_wc_notify_commit_replaced,
    "Committing a replacement.",
    "Commit" },
  { svn_wc_notify_commit_postfix_txdelta,
    "Transmitting post-fix text-delta data for a file.",
    "Xmit" },
  { svn_wc_notify_blame_revision,
    "Processed a single revision's blame.",
    "Blame" },
  { svn_wc_notify_locked,
    "Locking a path. @since New in 1.2.",
    "+Lock" },
  { svn_wc_notify_unlocked,
    "Unlocking a path. @since New in 1.2.",
    "-Lock" },
  { svn_wc_notify_failed_lock,
    "Failed to lock a path. @since New in 1.2.",
    "!+Lock" },
  { svn_wc_notify_failed_unlock,
    "Failed to unlock a path. @since New in 1.2.",
    "!-Unlock" },
  { 0, NULL, NULL }
};

const char *
gnubversion_notify_action_long(
    svn_wc_notify_action_t action
    )
{
    struct map_entry *m;

    for (m = map; m->long_desc != NULL; m++)
    {
        if ( m->action == action )
            return m->long_desc;
    }
    assert("Illegal svn_notify_action_t" == NULL);
    return NULL;
}

const char *
gnubversion_notify_action_short(
    svn_wc_notify_action_t action
    )
{
    struct map_entry *m;

    for (m = map; m->long_desc != NULL; m++)
    {
        if ( m->action == action )
            return m->short_desc;
    }
    assert("Illegal svn_notify_action_t" == NULL);
    return NULL;
}
