#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-auth.h"
#include "gnubversion-init.h"
#include "gnubversion-options.h"
#include "gnubversion-widgets.h"

#include <assert.h>
#include <svn_auth.h>
#include <svn_dso.h>

GladeXML *gnubversion_gladeXML = NULL;
apr_pool_t *gnubversion_apr_pool = NULL;
svn_client_ctx_t *gnubversion_svn_client_ctx = NULL;
gnubversion_auth_baton_t *gnubversion_auth_baton = NULL;

void 
gnubversion_init ()
{
    apr_initialize();
    svn_dso_initialize();
    apr_assert(apr_pool_create(&gnubversion_apr_pool, NULL));
    svn_assert(svn_client_create_context(&gnubversion_svn_client_ctx, gnubversion_apr_pool));

    /* The whole list of registered providers */
    apr_array_header_t *providers =
        apr_array_make (gnubversion_apr_pool, 4, sizeof (svn_auth_provider_object_t *));
    svn_auth_provider_object_t *provider;

    /* The main disk-caching auth providers, for both
    'username/password' creds and 'username' creds.  */
#ifdef WIN32
    svn_auth_get_windows_simple_provider(&provider, gnubversion_apr_pool);
    APR_ARRAY_PUSH(providers, svn_auth_provider_object_t *) = provider;
#endif
#ifdef SVN_HAVE_KEYCHAIN_SERVICES
    svn_auth_get_keychain_simple_provider(&provider, gnubversion_apr_pool);
    APR_ARRAY_PUSH(providers, svn_auth_provider_object_t *) = provider;
#endif

    // Provider that uses info from a user's ~/.subversion directory
    svn_auth_get_simple_provider (&provider, gnubversion_apr_pool);
    APR_ARRAY_PUSH (providers, svn_auth_provider_object_t *) = provider;

    // Another provider that uses info from a user's ~/.subversion directory
    svn_auth_get_username_provider (&provider, gnubversion_apr_pool);
    APR_ARRAY_PUSH (providers, svn_auth_provider_object_t *) = provider;

    /* The server-cert, client-cert, and client-cert-password providers. */
    svn_auth_get_ssl_server_trust_file_provider(&provider, gnubversion_apr_pool);
    APR_ARRAY_PUSH(providers, svn_auth_provider_object_t *) = provider;
    svn_auth_get_ssl_client_cert_file_provider(&provider, gnubversion_apr_pool);
    APR_ARRAY_PUSH(providers, svn_auth_provider_object_t *) = provider;
    svn_auth_get_ssl_client_cert_pw_file_provider(&provider, gnubversion_apr_pool);
    APR_ARRAY_PUSH(providers, svn_auth_provider_object_t *) = provider;

    gnubversion_auth_baton = apr_palloc(gnubversion_apr_pool, sizeof(*gnubversion_auth_baton));

    if ( ! (gnubversion_get_options()->non_interactive ) )
    {
        gnubversion_auth_baton->progressWindow = NULL;

        /* Two basic prompt providers: username/password, and just username. */
        svn_auth_get_simple_prompt_provider(&provider,
                                            gnubversion_auth_simple_prompt,
                                            gnubversion_auth_baton,
                                            2, /* retry limit */
                                            gnubversion_apr_pool);
        APR_ARRAY_PUSH(providers, svn_auth_provider_object_t *) = provider;

        svn_auth_get_username_prompt_provider(  &provider, 
                                                gnubversion_auth_username_prompt,
                                                gnubversion_auth_baton, 
                                                2, /* retry limit */ 
                                                gnubversion_apr_pool);
        APR_ARRAY_PUSH(providers, svn_auth_provider_object_t *) = provider;

        svn_auth_get_ssl_server_trust_prompt_provider( &provider,
                                                       gnubversion_auth_ssl_server_trust_prompt,
                                                       gnubversion_auth_baton,
                                                       gnubversion_apr_pool);
        APR_ARRAY_PUSH(providers, svn_auth_provider_object_t *) = provider;

        /* TODO: See subversion/libsvn_subr/cmdline.c for more ideas of what to add here */
    }

    /* Register the auth-providers into the context's auth_baton. */
    svn_auth_open (&gnubversion_svn_client_ctx->auth_baton, providers, gnubversion_apr_pool);      

    if (gnubversion_get_options()->username)
    {
        g_debug("Username: %s", gnubversion_get_options()->username->str);
        svn_auth_set_parameter(gnubversion_svn_client_ctx->auth_baton, SVN_AUTH_PARAM_DEFAULT_USERNAME, gnubversion_get_options()->username->str);
    }

    if (gnubversion_get_options()->password)
        svn_auth_set_parameter(gnubversion_svn_client_ctx->auth_baton, SVN_AUTH_PARAM_DEFAULT_PASSWORD, gnubversion_get_options()->password->str);

    if (gnubversion_get_options()->non_interactive)
        svn_auth_set_parameter(gnubversion_svn_client_ctx->auth_baton, SVN_AUTH_PARAM_NON_INTERACTIVE, "");

    if (gnubversion_get_options()->config_dir && (strlen(gnubversion_get_options()->config_dir->str) > 0))
        svn_auth_set_parameter(gnubversion_svn_client_ctx->auth_baton, SVN_AUTH_PARAM_CONFIG_DIR, gnubversion_get_options()->config_dir->str);

    if (gnubversion_get_options()->no_auth_cache)
        svn_auth_set_parameter(gnubversion_svn_client_ctx->auth_baton, SVN_AUTH_PARAM_NO_AUTH_CACHE, "");
}

void 
gnubversion_init_with_glade (const char *program)
{
    gnubversion_init();

    assert(program != NULL);
    GString * str = gladefile(program, ".glade");

    gnubversion_gladeXML = glade_xml_new (str->str, NULL, NULL);
    assert(gnubversion_gladeXML != NULL);
    g_string_free(str, TRUE);

    glade_xml_signal_autoconnect (gnubversion_gladeXML);
}

void 
gnubversion_shutdown()
{
    apr_pool_destroy(gnubversion_apr_pool);
    gnubversion_apr_pool = NULL;
}
