#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#define G_LOG_DOMAIN "gnubversion-treeview-utils"

#include <gtk/gtk.h>

void
gnubversion_treeview_utils_add_text_column (
    GtkTreeView *view, 
    const char *title, 
    int column_id, 
    int width_chars, 
    gboolean ellipsize,
    gboolean resizable,
    gboolean use_strikethrough,
    gboolean do_expand)
{
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;

    renderer = gtk_cell_renderer_text_new ();

    GValue value = {0,};
    g_value_init ( &value, G_TYPE_INT);

    if (ellipsize) 
    {
        g_value_set_int (&value, PANGO_ELLIPSIZE_START);
        g_object_set_property ( G_OBJECT (renderer), "ellipsize", &value);
    }

    if (width_chars > 0)
    {
        g_value_set_int (&value, width_chars);
        g_object_set_property ( G_OBJECT(renderer), "width-chars", &value);
    }

    column = gtk_tree_view_column_new_with_attributes (title,
                                                       renderer,
                                                       "text", column_id,
                                                       NULL);

    gtk_tree_view_column_set_expand(column, do_expand);
    gtk_tree_view_column_set_sort_column_id (column, column_id);
    gtk_tree_view_column_set_resizable (column, resizable);
    gtk_tree_view_append_column (view, column);
}

GtkCellRenderer *
gnubversion_treeview_utils_add_checkbox_column (
    GtkTreeView *view,
    const char *title,
    int active_column_id,
    gboolean resizable
)
{
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;

    renderer = gtk_cell_renderer_toggle_new();

    column = gtk_tree_view_column_new_with_attributes (title,
                                                       renderer,
                                                       "active", active_column_id,
                                                       NULL);

    gtk_tree_view_column_set_sort_column_id (column, active_column_id);
    gtk_tree_view_column_set_resizable (column, resizable);
    gtk_tree_view_append_column (view, column);

    return renderer;
}
