#ifndef GNUBVERSION_GERROR_H
#define GNUBVERSION_GERROR_H

#include <glib/gquark.h>
#include <glib/gerror.h>
#include <apr_errno.h>
#include <svn_error.h>

#define GNUBVERSION_QUARK_APR g_quark_from_static_string("apr")
#define GNUBVERSION_QUARK_SVN g_quark_from_static_string("svn")
#define GNUBVERSION_QUARK_LINUX g_quark_from_static_string("linux")

/** Error Functions
 *
 * When dialing with errors from multiple sources (ARP, Subversion and linux
 * itself), things get hairy.  
 *
 * This module helps convert "foreign" errors into @a GError instances
 *
 * @defgroup gnubversion_error_funcs Error Functions
 * @{
 */

/** Create a @a GError instance from an APR error
 */
extern GError * g_error_from_apr (apr_status_t apr_status);

/** Create a @a GError instance from an Subversion error
 */
extern GError * g_error_from_svn (svn_error_t *err);

/** Create a @a GError instance from an linux error
 */
extern GError * g_error_from_linux (int new_errno);

/**
 * @}
 */
#endif
