#ifndef GVN_ADDREMOVE_H
#define GVN_ADDREMOVE_H

#include <glib.h>
#include <svn_client.h>
#include <gnubversion.h>

struct baton {
    GnubVersionProgressWindow *progressWindow;
    GnubVersionFileSelectorStore *store;
    gboolean cancel_requested;
    gboolean ignore_externals;
    gboolean no_ignore;
    gboolean non_recursive;
    gboolean recursive;
    gboolean force;
};

/* Variables (constants, really) and functions declared in gvn-add.c and gvn-remove.c */
extern const char *appname;
extern const char *appwidget_name;
extern const char *get_initial_progressmessage();
extern const char *get_fileselector_title(void);
extern const char *get_tick_column_title(void);

extern gboolean include_func (const gchar *path, 
                              svn_wc_status2_t *status, 
                              gpointer user_data);

extern gpointer worker_thread_main(gpointer data);

extern GOptionEntry *get_option_entries(
        const gchar ***args,
        struct baton *baton);

extern svn_error_t * do_add_remove(
    apr_array_header_t *targets,
    struct baton *baton);

/* Copy the settings from the baton to the GUI */
extern void set_gui_options(struct baton *baton);

/* Copy the settings the GUI to the baton */
extern void get_gui_options(struct baton *baton);

#endif 
