#line 2 "mate_parser.c"

#line 4 "mate_parser.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE Materestart(Matein  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int Mateleng;

extern FILE *Matein, *Mateout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up Matetext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up Matetext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via Materestart()), so that the user can continue scanning by
	 * just pointing Matein at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when Matetext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int Mateleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow Matewrap()'s to do buffer switches
 * instead of setting up a fresh Matein.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void Materestart (FILE *input_file  );
void Mate_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE Mate_create_buffer (FILE *file,int size  );
void Mate_delete_buffer (YY_BUFFER_STATE b  );
void Mate_flush_buffer (YY_BUFFER_STATE b  );
void Matepush_buffer_state (YY_BUFFER_STATE new_buffer  );
void Matepop_buffer_state (void );

static void Mateensure_buffer_stack (void );
static void Mate_load_buffer_state (void );
static void Mate_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER Mate_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE Mate_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE Mate_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE Mate_scan_bytes (yyconst char *bytes,int len  );

void *Matealloc (yy_size_t  );
void *Materealloc (void *,yy_size_t  );
void Matefree (void *  );

#define yy_new_buffer Mate_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        Mateensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            Mate_create_buffer(Matein,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        Mateensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            Mate_create_buffer(Matein,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define Matewrap() 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *Matein = (FILE *) 0, *Mateout = (FILE *) 0;

typedef int yy_state_type;

extern int Matelineno;

int Matelineno = 1;

extern char *Matetext;
#define yytext_ptr Matetext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up Matetext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	Mateleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 69
#define YY_END_OF_BUFFER 70
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[320] =
    {   0,
        0,    0,    0,    0,   67,   67,    0,    0,    0,    0,
       70,   69,    2,    1,   65,   66,   69,   52,   53,   56,
       58,   60,   63,   57,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
       64,   64,   64,   64,   54,   59,   55,   67,    2,    1,
       68,    4,    7,    2,    7,    2,    0,    6,    0,    0,
       60,   63,    0,   63,   63,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   21,    0,    0,
        0,    0,    0,    0,    0,    0,   64,   64,   64,   64,

       67,    2,    4,    8,    0,    0,    5,   61,   60,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   11,   10,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    9,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   64,   64,    0,    0,
       61,   60,    0,    0,    0,    0,    0,    0,   47,    0,
        0,    0,    0,    0,    0,    0,   43,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   23,    0,   34,    0,   64,   34,
        0,    0,   61,    0,    0,    0,    0,   49,    0,    0,

        0,   15,    0,   24,   35,    0,    0,    0,    0,    0,
        0,   50,    0,   16,   13,    0,    0,    0,    0,   36,
        0,    0,    0,   22,    0,    0,   35,    0,    0,    0,
       61,   40,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   18,    0,    0,   20,   30,    0,    0,
       41,    0,    0,    0,   14,    0,    0,    0,   62,    0,
        0,    0,   51,    0,    0,    0,   42,    0,    0,   19,
        0,   46,    0,   37,   31,   17,    0,    0,    0,    0,
        3,   62,    0,   39,    0,    0,    0,   48,    0,    0,
       29,    0,   25,    0,    0,   62,   33,    0,    0,    0,

       32,    0,   26,   12,   38,    0,    0,   27,    0,    0,
        0,   28,    0,    0,    0,    0,   45,   44,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    4,    1,    1,    1,    7,
        8,    9,    1,   10,   11,   12,   13,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   15,   16,    4,
        4,    4,    1,    1,   17,   18,   19,   20,   21,   22,
       23,   11,   24,   11,   11,   25,   26,   27,   28,   29,
       11,   30,   31,   32,   33,   11,   11,   11,   11,   11,
        1,    1,    1,    4,   11,    1,   34,   35,   36,   37,

       38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
       48,   49,   44,   50,   51,   52,   53,   54,   55,   56,
       57,   44,   58,   59,   60,    4,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[61] =
    {   0,
        1,    1,    1,    1,    2,    1,    1,    1,    1,    1,
        3,    4,    5,    6,    7,    1,    6,    6,    6,    6,
        6,    6,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    6,    6,    6,    6,    6,    6,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[330] =
    {   0,
        0,    2,    5,    0,   64,   68,   73,  133,   82,   84,
      504,  505,  501,  505,  505,  505,  460,  505,  505,  505,
       59,   80,  486,  505,   84,   64,   54,   65,   69,   80,
      452,   65,  112,   72,  451,  451,   74,  459,   76,   79,
      180,  206,  481,  129,  505,  505,  505,    0,  493,    0,
      505,    0,  505,  492,  480,  490,  444,  505,  487,  475,
      133,  473,  451,  471,  470,  448,  115,  441,  117,  431,
      434,  432,  441,   69,  132,  433,  124,  115,  432,  425,
      424,  420,  434,  424,  419,  424,  437,  505,  411,  414,
      418,  118,  417,  128,  130,  137,  449,  148,  188,  196,

        0,  461,    0,  505,  426,  458,  505,  161,  446,  148,
      417,  406,  151,  172,  421,  418,  406,  404,  411,  402,
      158,  413,  404,  403,  505,  416,  409,  408,  393,  406,
      405,  391,  405,  405,  389,  393,  405,  384,  397,  389,
      378,  382,  382,  388,  209,  382,  181,  216,  383,  413,
      222,  234,  202,  390,  387,  384,  199,  389,  505,  389,
      364,  370,  385,  218,  371,  379,  505,  366,  383,  364,
      384,  367,  359,  372,  368,  370,  369,  358,  355,  356,
      367,  368,  369,  348,  505,  363,  505,  347,  238,  382,
      343,  243,  246,  381,  342,  361,  342,  505,  346,  340,

      342,  505,  354,  351,  505,  352,  353,  346,  341,  330,
      344,  505,  338,  505,  505,  329,  340,  343,  338,  505,
      323,  338,   77,  505,  321,  222,  357,  334,  356,  250,
      355,  505,  318,  325,  314,  328,  330,  311,  310,  315,
      310,  321,  312,  505,  304,  310,  505,  505,  318,  316,
      505,  315,  306,  313,  505,  302,  301,  310,  333,  334,
      307,  310,  505,  314,  291,  299,  505,  302,  301,  505,
      300,  505,  299,  505,  505,  505,  298,  297,  284,  267,
      505,  299,  268,  505,  238,  223,  225,  505,  234,  222,
      505,  218,  505,  222,  215,  505,  505,  213,  223,  216,

      505,  197,  505,  505,  505,  190,  167,  505,  151,  154,
      138,  505,  129,  142,  140,   89,  505,  505,  505,  276,
      283,  290,  297,  301,  303,  308,  315,  320,  326
    } ;

static yyconst flex_int16_t yy_def[330] =
    {   0,
      320,  320,  319,    3,  321,  321,  322,  322,  323,  323,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  324,  325,  319,  324,   25,   25,   25,   25,   25,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      326,  326,  326,  326,  319,  319,  319,  327,  327,  327,
      319,  328,  319,  319,  319,  319,  319,  319,  329,  319,
       25,  325,   25,  325,  325,   25,   25,  319,   25,  319,
      319,  319,  319,  319,   25,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  326,   42,   42,  326,

      327,  327,  328,  319,  319,  329,  319,  319,   61,   25,
      319,  319,   25,   25,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  326,  326,  319,  319,
      319,   61,   25,  319,  319,  319,   25,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  326,  326,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,

      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  326,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,

      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,    0,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319
    } ;

static yyconst flex_int16_t yy_nxt[566] =
    {   0,
      319,   13,   14,   13,   14,   12,   13,   14,   15,   16,
       17,   18,   19,   12,   20,   12,   12,   21,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   12,   41,   41,
       41,   41,   41,   42,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   44,   43,   43,   43,
       43,   43,   45,   46,   47,   49,   50,   58,   51,   49,
       50,   59,   51,   12,   13,   14,   12,   12,   12,   12,
       12,   12,   12,   54,   14,   54,   14,   12,   12,   63,
       55,   60,   55,   61,   62,  319,   75,   67,   62,   63,

       63,   79,   69,   68,   63,   85,   70,   89,   95,   86,
       90,   80,   71,   75,   72,   63,   93,  119,  253,   66,
      120,   76,   73,   91,   74,  318,  254,   94,   96,   77,
       12,   12,   12,   12,   13,   14,   12,   12,   12,   12,
       12,   12,   12,  319,   60,   81,  109,   12,   12,   82,
       63,  113,   63,   83,  125,  114,  121,  123,  100,   84,
      139,  142,  145,  126,   98,  111,  140,   63,   63,  145,
      146,  124,  150,  317,  151,  143,  121,  144,  100,  316,
      315,   98,  145,   63,  314,  153,   63,  313,  164,  145,
       12,   12,   12,   98,   62,  319,   98,   98,   98,   98,

       98,   98,  312,  156,   98,  157,  311,   63,  164,  310,
      319,  189,  147,   98,   98,   98,   98,   98,   98,   98,
       62,   98,   99,   98,   98,   98,   98,   98,  148,  187,
      319,  189,  147,  150,   63,  193,  190,   63,  205,   99,
       98,   98,   98,   98,   98,  194,  187,  152,  148,  309,
      195,  199,  319,  190,  229,  205,  230,  150,  227,  231,
      256,  229,  308,  260,  307,  306,  305,  304,  303,  302,
      257,  301,  300,  299,  298,  227,   12,   12,   12,   12,
       12,   12,   12,   48,   48,   48,   48,   48,   48,   48,
       52,   52,   52,   52,   52,   52,   52,   53,   53,   53,

       53,   53,   53,   53,   63,  297,   63,   63,   64,   64,
       97,   97,  296,   97,   97,  101,  295,  101,  101,  101,
      101,  101,  103,  103,  103,  103,  106,  106,  106,  106,
      106,  106,  106,  294,  293,  292,  291,  290,  289,  288,
      287,  286,  285,  284,  283,  229,  282,  281,  280,  279,
      278,  277,  276,  275,  274,  273,  272,  271,  270,  269,
      268,  267,  266,  265,  264,  263,  262,  261,  231,  259,
      258,  319,  255,  252,  251,  250,  249,  248,  247,  246,
      245,  244,  243,  242,  241,  240,  239,  238,  237,  236,
      235,  234,  233,  232,  231,  228,  319,  226,  225,  224,

      223,  222,  221,  220,  219,  218,  217,  216,  215,  214,
      213,  212,  211,  210,  209,  208,  207,  206,  204,  203,
      202,  201,  200,  198,  197,  196,  192,  191,  188,  186,
      185,  184,  183,  182,  181,  180,  179,  178,  177,  176,
      175,  174,  173,  172,  171,  170,  169,  168,  167,  166,
      165,  163,  162,  161,  160,  159,  158,  155,  154,  152,
      107,  149,  102,  319,  141,  138,  137,  136,  135,  134,
      133,  132,  131,  130,  129,  128,  127,  122,  118,  117,
      116,  115,  112,  110,   65,   65,   63,   65,  108,  107,
      105,   56,  104,   56,  102,  319,   92,   88,   87,   78,

       65,   57,   56,  319,   11,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319
    } ;

static yyconst flex_int16_t yy_chk[566] =
    {   0,
        0,    1,    1,    2,    2,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    5,    5,   21,    5,    6,
        6,   21,    6,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    9,    9,   10,   10,    7,    7,   27,
        9,   22,   10,   22,   22,   25,   30,   26,   25,   26,

       28,   32,   28,   27,   29,   34,   28,   37,   40,   34,
       37,   32,   28,   30,   28,   30,   39,   74,  223,   25,
       74,   30,   29,   37,   29,  316,  223,   39,   40,   30,
        7,    7,    7,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,   44,   61,   33,   61,    8,    8,   33,
       67,   69,   69,   33,   78,   69,   75,   77,   44,   33,
       92,   94,   95,   78,   98,   67,   92,   75,   61,   96,
       96,   77,  108,  315,  108,   94,   75,   94,   44,  314,
      313,   98,   95,  110,  311,  110,  113,  310,  121,   96,
        8,    8,    8,   41,   41,  147,   41,   41,   41,   41,

       41,   41,  309,  113,   99,  114,  307,  114,  121,  306,
      100,  147,   99,   41,   41,   41,   41,   41,   41,   42,
       42,   99,   42,   42,   42,   42,   42,   42,  100,  145,
      148,  147,   99,  151,  157,  151,  148,  153,  164,   42,
       42,   42,   42,   42,   42,  152,  145,  152,  100,  302,
      153,  157,  189,  148,  192,  164,  192,  193,  189,  193,
      226,  230,  300,  230,  299,  298,  295,  294,  292,  290,
      226,  289,  287,  286,  285,  189,  320,  320,  320,  320,
      320,  320,  320,  321,  321,  321,  321,  321,  321,  321,
      322,  322,  322,  322,  322,  322,  322,  323,  323,  323,

      323,  323,  323,  323,  324,  283,  324,  324,  325,  325,
      326,  326,  282,  326,  326,  327,  280,  327,  327,  327,
      327,  327,  328,  328,  328,  328,  329,  329,  329,  329,
      329,  329,  329,  279,  278,  277,  273,  271,  269,  268,
      266,  265,  264,  262,  261,  260,  259,  258,  257,  256,
      254,  253,  252,  250,  249,  246,  245,  243,  242,  241,
      240,  239,  238,  237,  236,  235,  234,  233,  231,  229,
      228,  227,  225,  222,  221,  219,  218,  217,  216,  213,
      211,  210,  209,  208,  207,  206,  204,  203,  201,  200,
      199,  197,  196,  195,  194,  191,  190,  188,  186,  184,

      183,  182,  181,  180,  179,  178,  177,  176,  175,  174,
      173,  172,  171,  170,  169,  168,  166,  165,  163,  162,
      161,  160,  158,  156,  155,  154,  150,  149,  146,  144,
      143,  142,  141,  140,  139,  138,  137,  136,  135,  134,
      133,  132,  131,  130,  129,  128,  127,  126,  124,  123,
      122,  120,  119,  118,  117,  116,  115,  112,  111,  109,
      106,  105,  102,   97,   93,   91,   90,   89,   87,   86,
       85,   84,   83,   82,   81,   80,   79,   76,   73,   72,
       71,   70,   68,   66,   65,   64,   63,   62,   60,   59,
       57,   56,   55,   54,   49,   43,   38,   36,   35,   31,

       23,   17,   13,   11,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int Mate_flex_debug;
int Mate_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *Matetext;
#line 1 "mate_parser.l"
/*
 * We want to stop processing when we get to the end of the input.
 */
/*
 * We don't use unput, so don't generate code for it.
 */
/*
 * We don't read from the terminal.
 */
/*
 * Prefix scanner routines with "Mate" rather than "yy", so this scanner
 * can coexist with other scanners.
 */
#line 23 "mate_parser.l"

	/* mate_parser.l
	* lexical analyzer for MATE configuration files
	*
	* Copyright 2004, Luis E. Garcia Ontanon <luis.ontanon@gmail.com>
	*
	* $Id: mate_parser.l 24717 2008-03-23 02:42:30Z gerald $
	*
	* Wireshark - Network traffic analyzer
	* By Gerald Combs <gerald@wireshark.org>
	* Copyright 1998 Gerald Combs
	*
	* This program is free software; you can redistribute it and/or
	* modify it under the terms of the GNU General Public License
	* as published by the Free Software Foundation; either version 2
	* of the License, or (at your option) any later version.
	* 
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	* 
	* You should have received a copy of the GNU General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/
	
#include <wiretap/file_util.h>

#include "mate.h"	
#include "mate_grammar.h"
#include "mate_parser_lex.h"
	
	void MateParser(void*,int, gchar*, mate_config* matecfg);
#if (GLIB_MAJOR_VERSION > 2 || (GLIB_MAJOR_VERSION == 2 && GLIB_MINOR_VERSION >= 16))
	void *MateParserAlloc(void *(*)(gsize));
#else
	void *MateParserAlloc(void *(*)(gulong));
#endif
	void MateParserFree( void*, void(*)(void*) );
	void MateParseTrace(FILE*,char*);
	
#define MAX_INCLUDE_DEPTH 10
	static YY_BUFFER_STATE include_stack[MAX_INCLUDE_DEPTH];
	static int include_stack_ptr = 0;
	
	static void* pParser;
	static mate_config_frame* current_frame;
	
	static mate_config* mc;
	
#define MATE_PARSE(token_type) MateParser(pParser, (token_type), g_strdup(Matetext), mc );


#line 756 "mate_parser.c"

#define INITIAL 0
#define OUTSIDE 1
#define QUOTED 2
#define INCLUDING 3
#define COMMENT 4

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int Matewrap (void );
#else
extern int Matewrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( Matetext, Mateleng, 1, Mateout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( Matein )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( Matein ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, Matein))==0 && ferror(Matein)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(Matein); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int Matelex (void);

#define YY_DECL int Matelex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after Matetext and Mateleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 156 "mate_parser.l"


#line 914 "mate_parser.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! Matein )
			Matein = stdin;

		if ( ! Mateout )
			Mateout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			Mateensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				Mate_create_buffer(Matein,YY_BUF_SIZE );
		}

		Mate_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of Matetext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 320 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 319 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 158 "mate_parser.l"
current_frame->linenum++; 
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 159 "mate_parser.l"
;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 161 "mate_parser.l"
BEGIN INCLUDING;
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 163 "mate_parser.l"
{
	if ( include_stack_ptr >= MAX_INCLUDE_DEPTH )
		g_error("dtd_preparse: include files nested to deeply");
	
	include_stack[include_stack_ptr++] = YY_CURRENT_BUFFER;
	Matein = eth_fopen( Matetext, "r" );

	if (!Matein) {
		Mate_delete_buffer(YY_CURRENT_BUFFER );
		
		/* coverity[negative_sink] */
		Mate_switch_to_buffer(include_stack[--include_stack_ptr] );
		
		if (errno)
			g_string_sprintfa(mc->config_error, "Mate parser: Could not open file: '%s': %s", Matetext, strerror(errno) );
		
	} else {
		
		current_frame = g_malloc(sizeof(mate_config_frame));
		current_frame->filename = g_strdup(Matetext);
		current_frame->linenum = 1;
		
		g_ptr_array_add(mc->config_stack,current_frame);

		Mate_switch_to_buffer(Mate_create_buffer(Matein,YY_BUF_SIZE ) );
	}
	
	BEGIN OUTSIDE;
}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(OUTSIDE):
case YY_STATE_EOF(QUOTED):
case YY_STATE_EOF(INCLUDING):
case YY_STATE_EOF(COMMENT):
#line 193 "mate_parser.l"
{	
	/* coverity[check_after_sink] */
	if ( --include_stack_ptr < 0 ) {
		yyterminate();
	} else {
		Mate_delete_buffer(YY_CURRENT_BUFFER );
		Mate_switch_to_buffer(include_stack[include_stack_ptr] );
		
		g_free(current_frame->filename);
		g_free(current_frame);
		current_frame = g_ptr_array_remove_index(mc->config_stack,mc->config_stack->len-1);
	}
}				
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 207 "mate_parser.l"
;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 209 "mate_parser.l"
BEGIN COMMENT;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 210 "mate_parser.l"
;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 211 "mate_parser.l"
BEGIN OUTSIDE;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 213 "mate_parser.l"
MATE_PARSE(TOKEN_PDU_KW);
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 214 "mate_parser.l"
MATE_PARSE(TOKEN_GOP_KW);
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 215 "mate_parser.l"
MATE_PARSE(TOKEN_GOG_KW);
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 216 "mate_parser.l"
MATE_PARSE(TOKEN_TRANSFORM_KW);
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 217 "mate_parser.l"
MATE_PARSE(TOKEN_MATCH_KW);
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 218 "mate_parser.l"
MATE_PARSE(TOKEN_STRICT_KW);
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 219 "mate_parser.l"
MATE_PARSE(TOKEN_EVERY_KW);
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 220 "mate_parser.l"
MATE_PARSE(TOKEN_LOOSE_KW);
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 221 "mate_parser.l"
MATE_PARSE(TOKEN_REPLACE_KW);
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 222 "mate_parser.l"
MATE_PARSE(TOKEN_INSERT_KW);
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 223 "mate_parser.l"
MATE_PARSE(TOKEN_GOP_TREE_KW);
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 224 "mate_parser.l"
MATE_PARSE(TOKEN_MEMBER_KW);
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 225 "mate_parser.l"
MATE_PARSE(TOKEN_ON_KW);
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 226 "mate_parser.l"
MATE_PARSE(TOKEN_START_KW);
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 227 "mate_parser.l"
MATE_PARSE(TOKEN_STOP_KW);
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 228 "mate_parser.l"
MATE_PARSE(TOKEN_EXTRA_KW);
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 229 "mate_parser.l"
MATE_PARSE(TOKEN_SHOW_TREE_KW);
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 230 "mate_parser.l"
MATE_PARSE(TOKEN_SHOW_TIMES_KW);
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 231 "mate_parser.l"
MATE_PARSE(TOKEN_EXPIRATION_KW);
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 232 "mate_parser.l"
MATE_PARSE(TOKEN_IDLE_TIMEOUT_KW);
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 233 "mate_parser.l"
MATE_PARSE(TOKEN_LIFETIME_KW);
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 234 "mate_parser.l"
MATE_PARSE(TOKEN_NO_TREE_KW);
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 235 "mate_parser.l"
MATE_PARSE(TOKEN_PDU_TREE_KW);
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 236 "mate_parser.l"
MATE_PARSE(TOKEN_FRAME_TREE_KW);
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 237 "mate_parser.l"
MATE_PARSE(TOKEN_BASIC_TREE_KW);
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 238 "mate_parser.l"
MATE_PARSE(TOKEN_TRUE_KW);
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 239 "mate_parser.l"
MATE_PARSE(TOKEN_FALSE_KW);
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 240 "mate_parser.l"
MATE_PARSE(TOKEN_PROTO_KW);
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 241 "mate_parser.l"
MATE_PARSE(TOKEN_PAYLOAD_KW);
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 242 "mate_parser.l"
MATE_PARSE(TOKEN_TRANSPORT_KW);
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 243 "mate_parser.l"
MATE_PARSE(TOKEN_CRITERIA_KW);
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 244 "mate_parser.l"
MATE_PARSE(TOKEN_ACCEPT_KW);
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 245 "mate_parser.l"
MATE_PARSE(TOKEN_REJECT_KW);
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 246 "mate_parser.l"
MATE_PARSE(TOKEN_EXTRACT_KW);
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 247 "mate_parser.l"
MATE_PARSE(TOKEN_FROM_KW);
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 248 "mate_parser.l"
MATE_PARSE(TOKEN_DROP_UNASSIGNED_KW);
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 249 "mate_parser.l"
MATE_PARSE(TOKEN_DISCARD_PDU_DATA_KW);
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 250 "mate_parser.l"
MATE_PARSE(TOKEN_LAST_PDU_KW);
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 251 "mate_parser.l"
MATE_PARSE(TOKEN_DONE_KW);
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 252 "mate_parser.l"
MATE_PARSE(TOKEN_FILENAME_KW);
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 253 "mate_parser.l"
MATE_PARSE(TOKEN_DEBUG_KW);
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 254 "mate_parser.l"
MATE_PARSE(TOKEN_LEVEL_KW);
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 255 "mate_parser.l"
MATE_PARSE(TOKEN_DEFAULT_KW);
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 257 "mate_parser.l"
MATE_PARSE(TOKEN_OPEN_PARENS);
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 258 "mate_parser.l"
MATE_PARSE(TOKEN_CLOSE_PARENS);
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 259 "mate_parser.l"
MATE_PARSE(TOKEN_OPEN_BRACE);
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 260 "mate_parser.l"
MATE_PARSE(TOKEN_CLOSE_BRACE);
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 261 "mate_parser.l"
MATE_PARSE(TOKEN_COMMA);
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 262 "mate_parser.l"
MATE_PARSE(TOKEN_SEMICOLON);
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 263 "mate_parser.l"
MATE_PARSE(TOKEN_SLASH);
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 264 "mate_parser.l"
MATE_PARSE(TOKEN_PIPE);
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 266 "mate_parser.l"
MATE_PARSE(TOKEN_INTEGER);
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 267 "mate_parser.l"
MATE_PARSE(TOKEN_FLOATING);
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 268 "mate_parser.l"
MATE_PARSE(TOKEN_DOTED_IP);
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 269 "mate_parser.l"
MATE_PARSE(TOKEN_COLONIZED);
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 270 "mate_parser.l"
MATE_PARSE(TOKEN_NAME);
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 271 "mate_parser.l"
MATE_PARSE(TOKEN_AVP_OPERATOR);
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 274 "mate_parser.l"
BEGIN QUOTED;
	YY_BREAK
case 67:
/* rule 67 can match eol */
YY_RULE_SETUP
#line 275 "mate_parser.l"
MATE_PARSE(TOKEN_QUOTED);
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 276 "mate_parser.l"
BEGIN OUTSIDE;
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 278 "mate_parser.l"
ECHO;
	YY_BREAK
#line 1389 "mate_parser.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed Matein at a new source and called
			 * Matelex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = Matein;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( Matewrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * Matetext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of Matelex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					Materealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			Materestart(Matein  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 320 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 320 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 319);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					Materestart(Matein );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( Matewrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve Matetext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void Materestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        Mateensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            Mate_create_buffer(Matein,YY_BUF_SIZE );
	}

	Mate_init_buffer(YY_CURRENT_BUFFER,input_file );
	Mate_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void Mate_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		Matepop_buffer_state();
	 *		Matepush_buffer_state(new_buffer);
     */
	Mateensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	Mate_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (Matewrap()) processing, but the only time this flag
	 * is looked at is after Matewrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void Mate_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	Matein = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE Mate_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) Matealloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in Mate_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) Matealloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in Mate_create_buffer()" );

	b->yy_is_our_buffer = 1;

	Mate_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with Mate_create_buffer()
 * 
 */
    void Mate_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		Matefree((void *) b->yy_ch_buf  );

	Matefree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a Materestart() or at EOF.
 */
    static void Mate_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	Mate_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then Mate_init_buffer was _probably_
     * called from Materestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void Mate_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		Mate_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void Matepush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	Mateensure_buffer_stack();

	/* This block is copied from Mate_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from Mate_switch_to_buffer. */
	Mate_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void Matepop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	Mate_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		Mate_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void Mateensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)Matealloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)Materealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE Mate_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) Matealloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in Mate_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	Mate_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to Matelex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       Mate_scan_bytes() instead.
 */
YY_BUFFER_STATE Mate_scan_string (yyconst char * yystr )
{
    
	return Mate_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to Matelex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE Mate_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) Matealloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in Mate_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = Mate_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in Mate_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up Matetext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		Matetext[Mateleng] = (yy_hold_char); \
		(yy_c_buf_p) = Matetext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		Mateleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int Mateget_lineno  (void)
{
        
    return Matelineno;
}

/** Get the input stream.
 * 
 */
FILE *Mateget_in  (void)
{
        return Matein;
}

/** Get the output stream.
 * 
 */
FILE *Mateget_out  (void)
{
        return Mateout;
}

/** Get the length of the current token.
 * 
 */
int Mateget_leng  (void)
{
        return Mateleng;
}

/** Get the current token.
 * 
 */

char *Mateget_text  (void)
{
        return Matetext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void Mateset_lineno (int  line_number )
{
    
    Matelineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see Mate_switch_to_buffer
 */
void Mateset_in (FILE *  in_str )
{
        Matein = in_str ;
}

void Mateset_out (FILE *  out_str )
{
        Mateout = out_str ;
}

int Mateget_debug  (void)
{
        return Mate_flex_debug;
}

void Mateset_debug (int  bdebug )
{
        Mate_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from Matelex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    Matein = stdin;
    Mateout = stdout;
#else
    Matein = (FILE *) 0;
    Mateout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * Matelex_init()
     */
    return 0;
}

/* Matelex_destroy is for both reentrant and non-reentrant scanners. */
int Matelex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		Mate_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		Matepop_buffer_state();
	}

	/* Destroy the stack itself. */
	Matefree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * Matelex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *Matealloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *Materealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void Matefree (void * ptr )
{
	free( (char *) ptr );	/* see Materealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 278 "mate_parser.l"



extern gboolean mate_load_config(const gchar* filename, mate_config* matecfg) {
	volatile gboolean state = TRUE;
	mc = matecfg;

	Matein = eth_fopen(filename,"r");
	
	if (!Matein) {
		g_string_sprintfa(mc->config_error,"Mate parser: Could not open file: '%s', error: %s", filename, strerror(errno) );
		return FALSE;
	}
	
	mc->config_stack = g_ptr_array_new();
	
	current_frame = g_malloc(sizeof(mate_config_frame));
	current_frame->filename = g_strdup(filename);
	current_frame->linenum = 1;
	
	g_ptr_array_add(mc->config_stack,current_frame);

	pParser = MateParserAlloc(g_malloc);
	
	/* MateParserTrace(stdout,""); */
	
	TRY {
		BEGIN OUTSIDE;

		Matelex();

		MateParser(pParser, 0, NULL,mc);

		Materestart(NULL);
	
		MateParserFree(pParser, g_free );
	
		g_free(current_frame->filename);
		g_free(current_frame);
	
		g_ptr_array_free(mc->config_stack,FALSE);
	} CATCH(MateConfigError) {
		state = FALSE;
	} CATCH_ALL {
		state = FALSE;		
		g_string_sprintfa(mc->config_error,"An unexpected error occurred");
	}
	ENDTRY;
	
	return state;
}

