/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "qmpushbutton.h"

#include <qimage.h>
#include <qpainter.h>
#include <qstyle.h>

#include <kiconeffect.h>

QMPushButton::QMPushButton(QWidget * parent, const char * name) : QPushButton(parent, name)
{
}

QMPushButton::~QMPushButton()
{
}

void QMPushButton::drawButtonLabel(QPainter * p)
{
	QPushButton::drawButtonLabel(p);

	if (isEnabled())
		return;

	const QRect ir = style().subRect(QStyle::SR_PushButtonContents, this);

	QPixmap pixmap;

	if ((iconSet()) && (!iconSet()->isNull()))
	{
		QIconSet::State state = QIconSet::Off;

		if ((isToggleButton()) && (isOn()))
			state = QIconSet::On;

		pixmap = iconSet()->pixmap(QIconSet::Small, QIconSet::Normal, state);
	}
	else
	{
		const QPixmap * pmap = this->pixmap();

		if (pmap)
			pixmap = (*pmap);
		else
			return;
	}

	const int
	pixw = pixmap.width(),
	pixh = pixmap.height();

	int
	x = (ir.x() + 2),
	y = (ir.y() + ir.height() / 2 - pixh / 2);

	if ((text().isEmpty()) && (!this->pixmap()))
	{
		x = (ir.x() + ir.width() / 2 - pixw / 2);
		y = (ir.y() + ir.height() / 2 - pixh / 2);
	}

	QImage tmpImage = pixmap.convertToImage();

	KIconEffect::toGray(tmpImage, 1.0);
	pixmap.convertFromImage(tmpImage);

	p->drawPixmap(x, y, pixmap);

	KIconEffect::toGamma(tmpImage, 0.2);
	pixmap.convertFromImage(tmpImage);

	p->drawPixmap(x, y, pixmap);
}
