/**
	Equalizer's window
**/

#include <klocale.h>

void frmEqualizer::init()
{
	setCaption(i18n("Equalizer"));

	lblAmp->setText(i18n("Amplifier"));

	pshNewProfile->setText(i18n("Add"));
	pshRenameProfile->setText(i18n("Change"));
	pshRemoveProfile->setText(i18n("Remove"));
	pshDefault->setText(i18n("Restore default values"));

	disCon(false);
}

void frmEqualizer::somethingChanged()
{
	int freq[] =
		{
			sld30->value(),
			sld60->value(),
			sld125->value(),
			sld250->value(),
			sld500->value(),
			sld1k->value(),
			sld2k->value(),
			sld4k->value(),
			sld8k->value(),
			sld16k->value(),
		};

	eqProfile & p = (*profiles.at(cmbProfiles->currentItem()));

	p.setAmpFreq(sldAmp->value(), freq);

	for (int i = 0 ; i != 10 ; i++)
		freq[i] = -freq[i];

	emit someEqValChanged(200 - sldAmp->value(), freq);
}

void frmEqualizer::restoreDefaultValues()
{
	sldAmp->setValue(100);

	sld30->setValue(0);
	sld60->setValue(0);
	sld125->setValue(0);
	sld250->setValue(0);
	sld500->setValue(0);
	sld1k->setValue(0);
	sld2k->setValue(0);
	sld4k->setValue(0);
	sld8k->setValue(0);
	sld16k->setValue(0);
}

void frmEqualizer::onEqualizer(int state)
{
	grpSliders->setEnabled(state);
	grpProfiles->setEnabled(state);

	if (state)
		somethingChanged();
	else
	{
		int freq[] =
		{
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
		};

		emit someEqValChanged(100, freq);
	}
}

eqProfiles & frmEqualizer::getEqProfiles()
{
	return profiles;
}

void frmEqualizer::onNewProfile()
{
	eqProfile p(txtName->text());

	profiles.append(p);

	refreshProfilesList(cmbProfiles->count());
	restoreDefaultValues();
}

void frmEqualizer::onRemoveProfile()
{
	if (cmbProfiles->count() <= 1)
		return;

	int i = cmbProfiles->currentItem();

	profiles.remove(profiles.at(i));

	if (i >= (int)profiles.count())
		i = 0;

	refreshProfilesList(i);
}

void frmEqualizer::refreshProfilesList(int i)
{
	cmbProfiles->clear();

	for (eqProfiles::const_iterator j = profiles.begin() ; j != profiles.end() ; j++)
		cmbProfiles->insertItem((*j).getName());

	cmbProfiles->setCurrentItem(i);

	if (cmbProfiles->count() == 1)
		pshRemoveProfile->setEnabled(false);
	else
		pshRemoveProfile->setEnabled(true);

	refreshSliders();
}

void frmEqualizer::onChangeProfileName()
{
	int i = cmbProfiles->currentItem();

	(*profiles.at(i)).setName(txtName->text());

	refreshProfilesList(i);
}

void frmEqualizer::refreshSliders()
{
	eqProfile & p = (*profiles.at(cmbProfiles->currentItem()));

	disCon(true);

	sldAmp->setValue(p.getAmp());

	sld30->setValue(p.getFreq(0));
	sld60->setValue(p.getFreq(1));
	sld125->setValue(p.getFreq(2));
	sld250->setValue(p.getFreq(3));
	sld500->setValue(p.getFreq(4));
	sld1k->setValue(p.getFreq(5));
	sld2k->setValue(p.getFreq(6));
	sld4k->setValue(p.getFreq(7));
	sld8k->setValue(p.getFreq(8));
	sld16k->setValue(p.getFreq(9));

	disCon(false);

	txtName->setText(p.getName());

	somethingChanged();
}

void frmEqualizer::disCon(bool b)
{
	if (b)
	{
		sldAmp->disconnect();
		sld30->disconnect();
		sld60->disconnect();
		sld125->disconnect();
		sld250->disconnect();
		sld500->disconnect();
		sld1k->disconnect();
		sld2k->disconnect();
		sld4k->disconnect();
		sld8k->disconnect();
		sld16k->disconnect();
	}
	else
	{
		connect(sldAmp, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld30, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld60, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld125, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld250, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld500, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld1k, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld2k, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld4k, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld8k, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
    		connect(sld16k, SIGNAL(valueChanged(int)), this, SLOT(somethingChanged()));
	}
}

void frmEqualizer::onNameChanged(const QString & s)
{
	if (s.isEmpty())
	{
		pshNewProfile->setEnabled(false);
		pshRenameProfile->setEnabled(false);
	}
	else
	{
		pshNewProfile->setEnabled(true);
		pshRenameProfile->setEnabled(true);
	}
}
