#include "accelview.h"
#include "accelviewitem.h"

AccelView::AccelView(QWidget * parent) : KListView(parent)
{
	setSorting(-1);
	setSortColumn(-1);
	setSelectionModeExt(KListView::Single);
	setAllColumnsShowFocus(true);
}

void AccelView::keyPressEvent(QKeyEvent * e)
{
	int nextKey = e->key();

	if (nextKey == QObject::Key_Control ||
		nextKey == QObject::Key_Shift ||
		nextKey == QObject::Key_Meta ||
		nextKey == QObject::Key_Alt)
		return;

	int modifier = translateModifiers(e->state());

	nextKey |= modifier;

	((AccelViewItem *)currentItem())->setAccel(QKeySequence(nextKey));

	emit accelChanged();
}

int AccelView::translateModifiers(int state) const
{
	int result = 0;

	if (state & QObject::ShiftButton)
		result |= QObject::SHIFT;

	if (state & QObject::ControlButton)
		result |= QObject::CTRL;

	if (state & QObject::MetaButton)
		result |= QObject::META;

	if (state & QObject::AltButton)
		result |= QObject::ALT;

	return result;
}
