/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "staticswitcher_options.h"

static int StaticswitcherOptionsDisplayPrivateIndex;

static CompMetadata staticswitcherOptionsMetadata;

static CompPluginVTable *staticswitcherPluginVTable = NULL;
CompPluginVTable staticswitcherOptionsVTable;

#define STATICSWITCHER_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, StaticswitcherOptions, o)
#define STATICSWITCHER_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, StaticswitcherOptions, o)

typedef struct _StaticswitcherOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[StaticswitcherDisplayOptionNum];
    staticswitcherDisplayOptionChangeNotifyProc notify[StaticswitcherDisplayOptionNum];
} StaticswitcherOptionsDisplay;

typedef struct _StaticswitcherOptionsScreen
{
    CompOption opt[StaticswitcherScreenOptionNum];
    staticswitcherScreenOptionChangeNotifyProc notify[StaticswitcherScreenOptionNum];
} StaticswitcherOptionsScreen;

CompAction * staticswitcherGetNextButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextButton].value.action;
}

void staticswitcherSetNextButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextButton].value.action.initiate = init;
}

void staticswitcherSetNextButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextButton].value.action.terminate = term;
}

CompOption * staticswitcherGetNextButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextButton];
}

void staticswitcherSetNextButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextButton] = notify;
}

CompAction * staticswitcherGetNextKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextKey].value.action;
}

void staticswitcherSetNextKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextKey].value.action.initiate = init;
}

void staticswitcherSetNextKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextKey].value.action.terminate = term;
}

CompOption * staticswitcherGetNextKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextKey];
}

void staticswitcherSetNextKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextKey] = notify;
}

CompAction * staticswitcherGetPrevButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevButton].value.action;
}

void staticswitcherSetPrevButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevButton].value.action.initiate = init;
}

void staticswitcherSetPrevButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevButton].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevButton];
}

void staticswitcherSetPrevButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevButton] = notify;
}

CompAction * staticswitcherGetPrevKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevKey].value.action;
}

void staticswitcherSetPrevKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevKey].value.action.initiate = init;
}

void staticswitcherSetPrevKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevKey].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevKey];
}

void staticswitcherSetPrevKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevKey] = notify;
}

CompAction * staticswitcherGetNextAllButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextAllButton].value.action;
}

void staticswitcherSetNextAllButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextAllButton].value.action.initiate = init;
}

void staticswitcherSetNextAllButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextAllButton].value.action.terminate = term;
}

CompOption * staticswitcherGetNextAllButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextAllButton];
}

void staticswitcherSetNextAllButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextAllButton] = notify;
}

CompAction * staticswitcherGetNextAllKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextAllKey].value.action;
}

void staticswitcherSetNextAllKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextAllKey].value.action.initiate = init;
}

void staticswitcherSetNextAllKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextAllKey].value.action.terminate = term;
}

CompOption * staticswitcherGetNextAllKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextAllKey];
}

void staticswitcherSetNextAllKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextAllKey] = notify;
}

CompAction * staticswitcherGetPrevAllButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevAllButton].value.action;
}

void staticswitcherSetPrevAllButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevAllButton].value.action.initiate = init;
}

void staticswitcherSetPrevAllButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevAllButton].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevAllButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevAllButton];
}

void staticswitcherSetPrevAllButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevAllButton] = notify;
}

CompAction * staticswitcherGetPrevAllKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevAllKey].value.action;
}

void staticswitcherSetPrevAllKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevAllKey].value.action.initiate = init;
}

void staticswitcherSetPrevAllKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevAllKey].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevAllKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevAllKey];
}

void staticswitcherSetPrevAllKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevAllKey] = notify;
}

CompAction * staticswitcherGetNextGroupButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextGroupButton].value.action;
}

void staticswitcherSetNextGroupButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextGroupButton].value.action.initiate = init;
}

void staticswitcherSetNextGroupButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextGroupButton].value.action.terminate = term;
}

CompOption * staticswitcherGetNextGroupButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextGroupButton];
}

void staticswitcherSetNextGroupButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextGroupButton] = notify;
}

CompAction * staticswitcherGetNextGroupKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextGroupKey].value.action;
}

void staticswitcherSetNextGroupKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextGroupKey].value.action.initiate = init;
}

void staticswitcherSetNextGroupKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextGroupKey].value.action.terminate = term;
}

CompOption * staticswitcherGetNextGroupKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextGroupKey];
}

void staticswitcherSetNextGroupKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextGroupKey] = notify;
}

CompAction * staticswitcherGetPrevGroupButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevGroupButton].value.action;
}

void staticswitcherSetPrevGroupButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevGroupButton].value.action.initiate = init;
}

void staticswitcherSetPrevGroupButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevGroupButton].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevGroupButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevGroupButton];
}

void staticswitcherSetPrevGroupButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevGroupButton] = notify;
}

CompAction * staticswitcherGetPrevGroupKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevGroupKey].value.action;
}

void staticswitcherSetPrevGroupKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevGroupKey].value.action.initiate = init;
}

void staticswitcherSetPrevGroupKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevGroupKey].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevGroupKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevGroupKey];
}

void staticswitcherSetPrevGroupKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevGroupKey] = notify;
}

CompAction * staticswitcherGetNextNoPopupButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextNoPopupButton].value.action;
}

void staticswitcherSetNextNoPopupButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextNoPopupButton].value.action.initiate = init;
}

void staticswitcherSetNextNoPopupButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextNoPopupButton].value.action.terminate = term;
}

CompOption * staticswitcherGetNextNoPopupButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextNoPopupButton];
}

void staticswitcherSetNextNoPopupButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextNoPopupButton] = notify;
}

CompAction * staticswitcherGetNextNoPopupKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextNoPopupKey].value.action;
}

void staticswitcherSetNextNoPopupKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextNoPopupKey].value.action.initiate = init;
}

void staticswitcherSetNextNoPopupKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextNoPopupKey].value.action.terminate = term;
}

CompOption * staticswitcherGetNextNoPopupKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextNoPopupKey];
}

void staticswitcherSetNextNoPopupKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextNoPopupKey] = notify;
}

CompAction * staticswitcherGetPrevNoPopupButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevNoPopupButton].value.action;
}

void staticswitcherSetPrevNoPopupButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevNoPopupButton].value.action.initiate = init;
}

void staticswitcherSetPrevNoPopupButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevNoPopupButton].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevNoPopupButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevNoPopupButton];
}

void staticswitcherSetPrevNoPopupButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevNoPopupButton] = notify;
}

CompAction * staticswitcherGetPrevNoPopupKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevNoPopupKey].value.action;
}

void staticswitcherSetPrevNoPopupKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevNoPopupKey].value.action.initiate = init;
}

void staticswitcherSetPrevNoPopupKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevNoPopupKey].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevNoPopupKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevNoPopupKey];
}

void staticswitcherSetPrevNoPopupKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevNoPopupKey] = notify;
}

CompAction * staticswitcherGetNextPanelButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextPanelButton].value.action;
}

void staticswitcherSetNextPanelButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextPanelButton].value.action.initiate = init;
}

void staticswitcherSetNextPanelButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextPanelButton].value.action.terminate = term;
}

CompOption * staticswitcherGetNextPanelButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextPanelButton];
}

void staticswitcherSetNextPanelButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextPanelButton] = notify;
}

CompAction * staticswitcherGetNextPanelKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextPanelKey].value.action;
}

void staticswitcherSetNextPanelKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextPanelKey].value.action.initiate = init;
}

void staticswitcherSetNextPanelKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionNextPanelKey].value.action.terminate = term;
}

CompOption * staticswitcherGetNextPanelKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionNextPanelKey];
}

void staticswitcherSetNextPanelKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionNextPanelKey] = notify;
}

CompAction * staticswitcherGetPrevPanelButton (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevPanelButton].value.action;
}

void staticswitcherSetPrevPanelButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevPanelButton].value.action.initiate = init;
}

void staticswitcherSetPrevPanelButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevPanelButton].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevPanelButtonOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevPanelButton];
}

void staticswitcherSetPrevPanelButtonNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevPanelButton] = notify;
}

CompAction * staticswitcherGetPrevPanelKey (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevPanelKey].value.action;
}

void staticswitcherSetPrevPanelKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevPanelKey].value.action.initiate = init;
}

void staticswitcherSetPrevPanelKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->opt[StaticswitcherDisplayOptionPrevPanelKey].value.action.terminate = term;
}

CompOption * staticswitcherGetPrevPanelKeyOption (CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[StaticswitcherDisplayOptionPrevPanelKey];
}

void staticswitcherSetPrevPanelKeyNotify (CompDisplay *d, staticswitcherDisplayOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    od->notify[StaticswitcherDisplayOptionPrevPanelKey] = notify;
}

float staticswitcherGetSpeed (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionSpeed].value.f;
}

CompOption * staticswitcherGetSpeedOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionSpeed];
}

void staticswitcherSetSpeedNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionSpeed] = notify;
}

float staticswitcherGetTimestep (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionTimestep].value.f;
}

CompOption * staticswitcherGetTimestepOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionTimestep];
}

void staticswitcherSetTimestepNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionTimestep] = notify;
}

CompMatch * staticswitcherGetWindowMatch (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionWindowMatch].value.match;
}

CompOption * staticswitcherGetWindowMatchOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionWindowMatch];
}

void staticswitcherSetWindowMatchNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionWindowMatch] = notify;
}

Bool staticswitcherGetBringToFront (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionBringToFront].value.b;
}

CompOption * staticswitcherGetBringToFrontOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionBringToFront];
}

void staticswitcherSetBringToFrontNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionBringToFront] = notify;
}

Bool staticswitcherGetMinimized (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionMinimized].value.b;
}

CompOption * staticswitcherGetMinimizedOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionMinimized];
}

void staticswitcherSetMinimizedNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionMinimized] = notify;
}

Bool staticswitcherGetAutoChangeVp (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionAutoChangeVp].value.b;
}

CompOption * staticswitcherGetAutoChangeVpOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionAutoChangeVp];
}

void staticswitcherSetAutoChangeVpNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionAutoChangeVp] = notify;
}

float staticswitcherGetPopupDelay (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionPopupDelay].value.f;
}

CompOption * staticswitcherGetPopupDelayOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionPopupDelay];
}

void staticswitcherSetPopupDelayNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionPopupDelay] = notify;
}

int staticswitcherGetSaturation (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionSaturation].value.i;
}

CompOption * staticswitcherGetSaturationOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionSaturation];
}

void staticswitcherSetSaturationNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionSaturation] = notify;
}

int staticswitcherGetBrightness (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionBrightness].value.i;
}

CompOption * staticswitcherGetBrightnessOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionBrightness];
}

void staticswitcherSetBrightnessNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionBrightness] = notify;
}

int staticswitcherGetOpacity (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionOpacity].value.i;
}

CompOption * staticswitcherGetOpacityOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionOpacity];
}

void staticswitcherSetOpacityNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionOpacity] = notify;
}

Bool staticswitcherGetIcon (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionIcon].value.b;
}

CompOption * staticswitcherGetIconOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionIcon];
}

void staticswitcherSetIconNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionIcon] = notify;
}

Bool staticswitcherGetMipmap (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionMipmap].value.b;
}

CompOption * staticswitcherGetMipmapOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionMipmap];
}

void staticswitcherSetMipmapNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionMipmap] = notify;
}

int staticswitcherGetRowAlign (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return os->opt[StaticswitcherScreenOptionRowAlign].value.i;
}

CompOption * staticswitcherGetRowAlignOption (CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[StaticswitcherScreenOptionRowAlign];
}

void staticswitcherSetRowAlignNotify (CompScreen *s, staticswitcherScreenOptionChangeNotifyProc notify)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    os->notify[StaticswitcherScreenOptionRowAlign] = notify;
}

CompOption * staticswitcherGetDisplayOption (CompDisplay *d, StaticswitcherDisplayOptions num)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * staticswitcherGetScreenOption (CompScreen *s, StaticswitcherScreenOptions num)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo staticswitcherOptionsDisplayOptionInfo[] = {
    { "next_button", "button", 0, 0, 0 },
    { "next_key", "key", 0, 0, 0 },
    { "prev_button", "button", 0, 0, 0 },
    { "prev_key", "key", 0, 0, 0 },
    { "next_all_button", "button", 0, 0, 0 },
    { "next_all_key", "key", 0, 0, 0 },
    { "prev_all_button", "button", 0, 0, 0 },
    { "prev_all_key", "key", 0, 0, 0 },
    { "next_group_button", "button", 0, 0, 0 },
    { "next_group_key", "key", 0, 0, 0 },
    { "prev_group_button", "button", 0, 0, 0 },
    { "prev_group_key", "key", 0, 0, 0 },
    { "next_no_popup_button", "button", 0, 0, 0 },
    { "next_no_popup_key", "key", 0, 0, 0 },
    { "prev_no_popup_button", "button", 0, 0, 0 },
    { "prev_no_popup_key", "key", 0, 0, 0 },
    { "next_panel_button", "button", 0, 0, 0 },
    { "next_panel_key", "key", 0, 0, 0 },
    { "prev_panel_button", "button", 0, 0, 0 },
    { "prev_panel_key", "key", 0, 0, 0 },
};

static Bool staticswitcherOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, StaticswitcherDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case StaticswitcherDisplayOptionNextButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextButton])
                (*od->notify[StaticswitcherDisplayOptionNextButton]) (d, o, StaticswitcherDisplayOptionNextButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextKey])
                (*od->notify[StaticswitcherDisplayOptionNextKey]) (d, o, StaticswitcherDisplayOptionNextKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevButton])
                (*od->notify[StaticswitcherDisplayOptionPrevButton]) (d, o, StaticswitcherDisplayOptionPrevButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevKey])
                (*od->notify[StaticswitcherDisplayOptionPrevKey]) (d, o, StaticswitcherDisplayOptionPrevKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextAllButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextAllButton])
                (*od->notify[StaticswitcherDisplayOptionNextAllButton]) (d, o, StaticswitcherDisplayOptionNextAllButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextAllKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextAllKey])
                (*od->notify[StaticswitcherDisplayOptionNextAllKey]) (d, o, StaticswitcherDisplayOptionNextAllKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevAllButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevAllButton])
                (*od->notify[StaticswitcherDisplayOptionPrevAllButton]) (d, o, StaticswitcherDisplayOptionPrevAllButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevAllKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevAllKey])
                (*od->notify[StaticswitcherDisplayOptionPrevAllKey]) (d, o, StaticswitcherDisplayOptionPrevAllKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextGroupButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextGroupButton])
                (*od->notify[StaticswitcherDisplayOptionNextGroupButton]) (d, o, StaticswitcherDisplayOptionNextGroupButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextGroupKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextGroupKey])
                (*od->notify[StaticswitcherDisplayOptionNextGroupKey]) (d, o, StaticswitcherDisplayOptionNextGroupKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevGroupButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevGroupButton])
                (*od->notify[StaticswitcherDisplayOptionPrevGroupButton]) (d, o, StaticswitcherDisplayOptionPrevGroupButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevGroupKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevGroupKey])
                (*od->notify[StaticswitcherDisplayOptionPrevGroupKey]) (d, o, StaticswitcherDisplayOptionPrevGroupKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextNoPopupButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextNoPopupButton])
                (*od->notify[StaticswitcherDisplayOptionNextNoPopupButton]) (d, o, StaticswitcherDisplayOptionNextNoPopupButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextNoPopupKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextNoPopupKey])
                (*od->notify[StaticswitcherDisplayOptionNextNoPopupKey]) (d, o, StaticswitcherDisplayOptionNextNoPopupKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevNoPopupButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevNoPopupButton])
                (*od->notify[StaticswitcherDisplayOptionPrevNoPopupButton]) (d, o, StaticswitcherDisplayOptionPrevNoPopupButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevNoPopupKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevNoPopupKey])
                (*od->notify[StaticswitcherDisplayOptionPrevNoPopupKey]) (d, o, StaticswitcherDisplayOptionPrevNoPopupKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextPanelButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextPanelButton])
                (*od->notify[StaticswitcherDisplayOptionNextPanelButton]) (d, o, StaticswitcherDisplayOptionNextPanelButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionNextPanelKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionNextPanelKey])
                (*od->notify[StaticswitcherDisplayOptionNextPanelKey]) (d, o, StaticswitcherDisplayOptionNextPanelKey);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevPanelButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevPanelButton])
                (*od->notify[StaticswitcherDisplayOptionPrevPanelButton]) (d, o, StaticswitcherDisplayOptionPrevPanelButton);
            return TRUE;
        }
        break;
     case StaticswitcherDisplayOptionPrevPanelKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[StaticswitcherDisplayOptionPrevPanelKey])
                (*od->notify[StaticswitcherDisplayOptionPrevPanelKey]) (d, o, StaticswitcherDisplayOptionPrevPanelKey);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * staticswitcherOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    STATICSWITCHER_OPTIONS_DISPLAY(d);
    *count = StaticswitcherDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo staticswitcherOptionsScreenOptionInfo[] = {
    { "speed", "float", "<min>0.1</min><max>50</max>", 0, 0 },
    { "timestep", "float", "<min>0.1</min><max>50</max>", 0, 0 },
    { "window_match", "match", 0, 0, 0 },
    { "bring_to_front", "bool", 0, 0, 0 },
    { "minimized", "bool", 0, 0, 0 },
    { "auto_change_vp", "bool", 0, 0, 0 },
    { "popup_delay", "float", "<min>0.0</min><max>2.0</max>", 0, 0 },
    { "saturation", "int", "<min>0</min><max>100</max>", 0, 0 },
    { "brightness", "int", "<min>0</min><max>100</max>", 0, 0 },
    { "opacity", "int", "<min>0</min><max>100</max>", 0, 0 },
    { "icon", "bool", 0, 0, 0 },
    { "mipmap", "bool", 0, 0, 0 },
    { "row_align", "int", "<min>0</min><max>1</max>", 0, 0 },
};

static Bool staticswitcherOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, StaticswitcherScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case StaticswitcherScreenOptionSpeed:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionSpeed])
                (*os->notify[StaticswitcherScreenOptionSpeed]) (s, o, StaticswitcherScreenOptionSpeed);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionTimestep:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionTimestep])
                (*os->notify[StaticswitcherScreenOptionTimestep]) (s, o, StaticswitcherScreenOptionTimestep);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionWindowMatch])
                (*os->notify[StaticswitcherScreenOptionWindowMatch]) (s, o, StaticswitcherScreenOptionWindowMatch);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionBringToFront:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionBringToFront])
                (*os->notify[StaticswitcherScreenOptionBringToFront]) (s, o, StaticswitcherScreenOptionBringToFront);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionMinimized:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionMinimized])
                (*os->notify[StaticswitcherScreenOptionMinimized]) (s, o, StaticswitcherScreenOptionMinimized);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionAutoChangeVp:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionAutoChangeVp])
                (*os->notify[StaticswitcherScreenOptionAutoChangeVp]) (s, o, StaticswitcherScreenOptionAutoChangeVp);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionPopupDelay:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionPopupDelay])
                (*os->notify[StaticswitcherScreenOptionPopupDelay]) (s, o, StaticswitcherScreenOptionPopupDelay);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionSaturation:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionSaturation])
                (*os->notify[StaticswitcherScreenOptionSaturation]) (s, o, StaticswitcherScreenOptionSaturation);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionBrightness:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionBrightness])
                (*os->notify[StaticswitcherScreenOptionBrightness]) (s, o, StaticswitcherScreenOptionBrightness);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionOpacity])
                (*os->notify[StaticswitcherScreenOptionOpacity]) (s, o, StaticswitcherScreenOptionOpacity);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionIcon:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionIcon])
                (*os->notify[StaticswitcherScreenOptionIcon]) (s, o, StaticswitcherScreenOptionIcon);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionMipmap:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionMipmap])
                (*os->notify[StaticswitcherScreenOptionMipmap]) (s, o, StaticswitcherScreenOptionMipmap);
            return TRUE;
        }
        break;
     case StaticswitcherScreenOptionRowAlign:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[StaticswitcherScreenOptionRowAlign])
                (*os->notify[StaticswitcherScreenOptionRowAlign]) (s, o, StaticswitcherScreenOptionRowAlign);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * staticswitcherOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    STATICSWITCHER_OPTIONS_SCREEN(s);
    *count = StaticswitcherScreenOptionNum;
    return os->opt;
}

static Bool staticswitcherOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    StaticswitcherOptionsScreen *os;
    
    STATICSWITCHER_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(StaticswitcherOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &staticswitcherOptionsMetadata, staticswitcherOptionsScreenOptionInfo, os->opt, StaticswitcherScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void staticswitcherOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    STATICSWITCHER_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, StaticswitcherScreenOptionNum);

    free (os);
}

static Bool staticswitcherOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    StaticswitcherOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(StaticswitcherOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[StaticswitcherOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &staticswitcherOptionsMetadata, staticswitcherOptionsDisplayOptionInfo, od->opt, StaticswitcherDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void staticswitcherOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    STATICSWITCHER_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, StaticswitcherDisplayOptionNum);

    free (od);
}

static Bool staticswitcherOptionsInit (CompPlugin *p)
{
    StaticswitcherOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (StaticswitcherOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&staticswitcherOptionsMetadata, "staticswitcher",staticswitcherOptionsDisplayOptionInfo, StaticswitcherDisplayOptionNum, staticswitcherOptionsScreenOptionInfo, StaticswitcherScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&staticswitcherOptionsMetadata, "staticswitcher");
    if (staticswitcherPluginVTable && staticswitcherPluginVTable->init)
        return staticswitcherPluginVTable->init (p);
    return TRUE;
}

static void staticswitcherOptionsFini (CompPlugin *p)
{
    if (staticswitcherPluginVTable && staticswitcherPluginVTable->fini)
        staticswitcherPluginVTable->fini (p);

    if (StaticswitcherOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (StaticswitcherOptionsDisplayPrivateIndex);

    compFiniMetadata (&staticswitcherOptionsMetadata);
}

static CompBool staticswitcherOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) staticswitcherOptionsInitDisplay,
        (InitPluginObjectProc) staticswitcherOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void staticswitcherOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) staticswitcherOptionsFiniDisplay,
        (FiniPluginObjectProc) staticswitcherOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool staticswitcherOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = staticswitcherOptionsInitObject (p, o);
    if (staticswitcherPluginVTable->initObject)
        rv &= staticswitcherPluginVTable->initObject (p, o);
    return rv;
}

static void staticswitcherOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (staticswitcherPluginVTable->finiObject)
        staticswitcherPluginVTable->finiObject (p, o);
    staticswitcherOptionsFiniObject (p, o);
}

static CompOption * staticswitcherOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) staticswitcherOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) staticswitcherOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool staticswitcherOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) staticswitcherOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) staticswitcherOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
staticswitcherOptionsGetMetadata (CompPlugin *plugin)
{
    return &staticswitcherOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!staticswitcherPluginVTable)
    {
        staticswitcherPluginVTable = getCompPluginInfo ();
        memcpy(&staticswitcherOptionsVTable, staticswitcherPluginVTable, sizeof(CompPluginVTable));
        staticswitcherOptionsVTable.getMetadata = staticswitcherOptionsGetMetadata;
        staticswitcherOptionsVTable.init = staticswitcherOptionsInit;
        staticswitcherOptionsVTable.fini = staticswitcherOptionsFini;
        staticswitcherOptionsVTable.initObject = staticswitcherOptionsInitObjectWrapper;
        staticswitcherOptionsVTable.finiObject = staticswitcherOptionsFiniObjectWrapper;
        staticswitcherOptionsVTable.getObjectOptions = staticswitcherOptionsGetObjectOptions;
	staticswitcherOptionsVTable.setObjectOption = staticswitcherOptionsSetObjectOption;
	
    }
    return &staticswitcherOptionsVTable;
}

