/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "mblur_options.h"

static int MblurOptionsDisplayPrivateIndex;

static CompMetadata mblurOptionsMetadata;

static CompPluginVTable *mblurPluginVTable = NULL;
CompPluginVTable mblurOptionsVTable;

#define MBLUR_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, MblurOptions, o)
#define MBLUR_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, MblurOptions, o)

typedef struct _MblurOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[MblurDisplayOptionNum];
    mblurDisplayOptionChangeNotifyProc notify[MblurDisplayOptionNum];
} MblurOptionsDisplay;

typedef struct _MblurOptionsScreen
{
    CompOption opt[MblurScreenOptionNum];
    mblurScreenOptionChangeNotifyProc notify[MblurScreenOptionNum];
} MblurOptionsScreen;

CompAction * mblurGetInitiateKey (CompDisplay *d)
{
    MBLUR_OPTIONS_DISPLAY(d);
    return &od->opt[MblurDisplayOptionInitiateKey].value.action;
}

void mblurSetInitiateKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    MBLUR_OPTIONS_DISPLAY(d);
    od->opt[MblurDisplayOptionInitiateKey].value.action.initiate = init;
}

void mblurSetInitiateKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    MBLUR_OPTIONS_DISPLAY(d);
    od->opt[MblurDisplayOptionInitiateKey].value.action.terminate = term;
}

CompOption * mblurGetInitiateKeyOption (CompDisplay *d)
{
    MBLUR_OPTIONS_DISPLAY(d);
    return &od->opt[MblurDisplayOptionInitiateKey];
}

void mblurSetInitiateKeyNotify (CompDisplay *d, mblurDisplayOptionChangeNotifyProc notify)
{
    MBLUR_OPTIONS_DISPLAY(d);
    od->notify[MblurDisplayOptionInitiateKey] = notify;
}

int mblurGetMode (CompScreen *s)
{
    MBLUR_OPTIONS_SCREEN(s);
    return os->opt[MblurScreenOptionMode].value.i;
}

CompOption * mblurGetModeOption (CompScreen *s)
{
    MBLUR_OPTIONS_SCREEN(s);
    return &os->opt[MblurScreenOptionMode];
}

void mblurSetModeNotify (CompScreen *s, mblurScreenOptionChangeNotifyProc notify)
{
    MBLUR_OPTIONS_SCREEN(s);
    os->notify[MblurScreenOptionMode] = notify;
}

float mblurGetStrength (CompScreen *s)
{
    MBLUR_OPTIONS_SCREEN(s);
    return os->opt[MblurScreenOptionStrength].value.f;
}

CompOption * mblurGetStrengthOption (CompScreen *s)
{
    MBLUR_OPTIONS_SCREEN(s);
    return &os->opt[MblurScreenOptionStrength];
}

void mblurSetStrengthNotify (CompScreen *s, mblurScreenOptionChangeNotifyProc notify)
{
    MBLUR_OPTIONS_SCREEN(s);
    os->notify[MblurScreenOptionStrength] = notify;
}

Bool mblurGetOnTransformedScreen (CompScreen *s)
{
    MBLUR_OPTIONS_SCREEN(s);
    return os->opt[MblurScreenOptionOnTransformedScreen].value.b;
}

CompOption * mblurGetOnTransformedScreenOption (CompScreen *s)
{
    MBLUR_OPTIONS_SCREEN(s);
    return &os->opt[MblurScreenOptionOnTransformedScreen];
}

void mblurSetOnTransformedScreenNotify (CompScreen *s, mblurScreenOptionChangeNotifyProc notify)
{
    MBLUR_OPTIONS_SCREEN(s);
    os->notify[MblurScreenOptionOnTransformedScreen] = notify;
}

CompOption * mblurGetDisplayOption (CompDisplay *d, MblurDisplayOptions num)
{
    MBLUR_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * mblurGetScreenOption (CompScreen *s, MblurScreenOptions num)
{
    MBLUR_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo mblurOptionsDisplayOptionInfo[] = {
    { "initiate_key", "key", 0, 0, 0 },
};

static Bool mblurOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    MBLUR_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, MblurDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case MblurDisplayOptionInitiateKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MblurDisplayOptionInitiateKey])
                (*od->notify[MblurDisplayOptionInitiateKey]) (d, o, MblurDisplayOptionInitiateKey);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * mblurOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    MBLUR_OPTIONS_DISPLAY(d);
    *count = MblurDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo mblurOptionsScreenOptionInfo[] = {
    { "mode", "int", "<min>0</min><max>1</max>", 0, 0 },
    { "strength", "float", "<min>0.0</min><max>100.0</max>", 0, 0 },
    { "on_transformed_screen", "bool", 0, 0, 0 },
};

static Bool mblurOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    MBLUR_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, MblurScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case MblurScreenOptionMode:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MblurScreenOptionMode])
                (*os->notify[MblurScreenOptionMode]) (s, o, MblurScreenOptionMode);
            return TRUE;
        }
        break;
     case MblurScreenOptionStrength:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MblurScreenOptionStrength])
                (*os->notify[MblurScreenOptionStrength]) (s, o, MblurScreenOptionStrength);
            return TRUE;
        }
        break;
     case MblurScreenOptionOnTransformedScreen:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[MblurScreenOptionOnTransformedScreen])
                (*os->notify[MblurScreenOptionOnTransformedScreen]) (s, o, MblurScreenOptionOnTransformedScreen);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * mblurOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    MBLUR_OPTIONS_SCREEN(s);
    *count = MblurScreenOptionNum;
    return os->opt;
}

static Bool mblurOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    MblurOptionsScreen *os;
    
    MBLUR_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(MblurOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &mblurOptionsMetadata, mblurOptionsScreenOptionInfo, os->opt, MblurScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void mblurOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    MBLUR_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, MblurScreenOptionNum);

    free (os);
}

static Bool mblurOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    MblurOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(MblurOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[MblurOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &mblurOptionsMetadata, mblurOptionsDisplayOptionInfo, od->opt, MblurDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void mblurOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    MBLUR_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, MblurDisplayOptionNum);

    free (od);
}

static Bool mblurOptionsInit (CompPlugin *p)
{
    MblurOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (MblurOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&mblurOptionsMetadata, "mblur",mblurOptionsDisplayOptionInfo, MblurDisplayOptionNum, mblurOptionsScreenOptionInfo, MblurScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&mblurOptionsMetadata, "mblur");
    if (mblurPluginVTable && mblurPluginVTable->init)
        return mblurPluginVTable->init (p);
    return TRUE;
}

static void mblurOptionsFini (CompPlugin *p)
{
    if (mblurPluginVTable && mblurPluginVTable->fini)
        mblurPluginVTable->fini (p);

    if (MblurOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (MblurOptionsDisplayPrivateIndex);

    compFiniMetadata (&mblurOptionsMetadata);
}

static CompBool mblurOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) mblurOptionsInitDisplay,
        (InitPluginObjectProc) mblurOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void mblurOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) mblurOptionsFiniDisplay,
        (FiniPluginObjectProc) mblurOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool mblurOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = mblurOptionsInitObject (p, o);
    if (mblurPluginVTable->initObject)
        rv &= mblurPluginVTable->initObject (p, o);
    return rv;
}

static void mblurOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (mblurPluginVTable->finiObject)
        mblurPluginVTable->finiObject (p, o);
    mblurOptionsFiniObject (p, o);
}

static CompOption * mblurOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) mblurOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) mblurOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool mblurOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) mblurOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) mblurOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
mblurOptionsGetMetadata (CompPlugin *plugin)
{
    return &mblurOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!mblurPluginVTable)
    {
        mblurPluginVTable = getCompPluginInfo ();
        memcpy(&mblurOptionsVTable, mblurPluginVTable, sizeof(CompPluginVTable));
        mblurOptionsVTable.getMetadata = mblurOptionsGetMetadata;
        mblurOptionsVTable.init = mblurOptionsInit;
        mblurOptionsVTable.fini = mblurOptionsFini;
        mblurOptionsVTable.initObject = mblurOptionsInitObjectWrapper;
        mblurOptionsVTable.finiObject = mblurOptionsFiniObjectWrapper;
        mblurOptionsVTable.getObjectOptions = mblurOptionsGetObjectOptions;
	mblurOptionsVTable.setObjectOption = mblurOptionsSetObjectOption;
	
    }
    return &mblurOptionsVTable;
}

