/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "cubeaddon_options.h"

static int CubeaddonOptionsDisplayPrivateIndex;

static CompMetadata cubeaddonOptionsMetadata;

static CompPluginVTable *cubeaddonPluginVTable = NULL;
CompPluginVTable cubeaddonOptionsVTable;

#define CUBEADDON_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, CubeaddonOptions, o)
#define CUBEADDON_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, CubeaddonOptions, o)

typedef struct _CubeaddonOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[CubeaddonDisplayOptionNum];
    cubeaddonDisplayOptionChangeNotifyProc notify[CubeaddonDisplayOptionNum];
} CubeaddonOptionsDisplay;

typedef struct _CubeaddonOptionsScreen
{
    CompOption opt[CubeaddonScreenOptionNum];
    cubeaddonScreenOptionChangeNotifyProc notify[CubeaddonScreenOptionNum];
} CubeaddonOptionsScreen;

CompAction * cubeaddonGetTopNextKey (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionTopNextKey].value.action;
}

void cubeaddonSetTopNextKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionTopNextKey].value.action.initiate = init;
}

void cubeaddonSetTopNextKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionTopNextKey].value.action.terminate = term;
}

CompOption * cubeaddonGetTopNextKeyOption (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionTopNextKey];
}

void cubeaddonSetTopNextKeyNotify (CompDisplay *d, cubeaddonDisplayOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->notify[CubeaddonDisplayOptionTopNextKey] = notify;
}

CompAction * cubeaddonGetTopNextButton (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionTopNextButton].value.action;
}

void cubeaddonSetTopNextButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionTopNextButton].value.action.initiate = init;
}

void cubeaddonSetTopNextButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionTopNextButton].value.action.terminate = term;
}

CompOption * cubeaddonGetTopNextButtonOption (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionTopNextButton];
}

void cubeaddonSetTopNextButtonNotify (CompDisplay *d, cubeaddonDisplayOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->notify[CubeaddonDisplayOptionTopNextButton] = notify;
}

CompAction * cubeaddonGetTopPrevKey (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionTopPrevKey].value.action;
}

void cubeaddonSetTopPrevKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionTopPrevKey].value.action.initiate = init;
}

void cubeaddonSetTopPrevKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionTopPrevKey].value.action.terminate = term;
}

CompOption * cubeaddonGetTopPrevKeyOption (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionTopPrevKey];
}

void cubeaddonSetTopPrevKeyNotify (CompDisplay *d, cubeaddonDisplayOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->notify[CubeaddonDisplayOptionTopPrevKey] = notify;
}

CompAction * cubeaddonGetTopPrevButton (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionTopPrevButton].value.action;
}

void cubeaddonSetTopPrevButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionTopPrevButton].value.action.initiate = init;
}

void cubeaddonSetTopPrevButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionTopPrevButton].value.action.terminate = term;
}

CompOption * cubeaddonGetTopPrevButtonOption (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionTopPrevButton];
}

void cubeaddonSetTopPrevButtonNotify (CompDisplay *d, cubeaddonDisplayOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->notify[CubeaddonDisplayOptionTopPrevButton] = notify;
}

CompAction * cubeaddonGetBottomNextKey (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionBottomNextKey].value.action;
}

void cubeaddonSetBottomNextKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionBottomNextKey].value.action.initiate = init;
}

void cubeaddonSetBottomNextKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionBottomNextKey].value.action.terminate = term;
}

CompOption * cubeaddonGetBottomNextKeyOption (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionBottomNextKey];
}

void cubeaddonSetBottomNextKeyNotify (CompDisplay *d, cubeaddonDisplayOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->notify[CubeaddonDisplayOptionBottomNextKey] = notify;
}

CompAction * cubeaddonGetBottomNextButton (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionBottomNextButton].value.action;
}

void cubeaddonSetBottomNextButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionBottomNextButton].value.action.initiate = init;
}

void cubeaddonSetBottomNextButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionBottomNextButton].value.action.terminate = term;
}

CompOption * cubeaddonGetBottomNextButtonOption (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionBottomNextButton];
}

void cubeaddonSetBottomNextButtonNotify (CompDisplay *d, cubeaddonDisplayOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->notify[CubeaddonDisplayOptionBottomNextButton] = notify;
}

CompAction * cubeaddonGetBottomPrevKey (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionBottomPrevKey].value.action;
}

void cubeaddonSetBottomPrevKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionBottomPrevKey].value.action.initiate = init;
}

void cubeaddonSetBottomPrevKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionBottomPrevKey].value.action.terminate = term;
}

CompOption * cubeaddonGetBottomPrevKeyOption (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionBottomPrevKey];
}

void cubeaddonSetBottomPrevKeyNotify (CompDisplay *d, cubeaddonDisplayOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->notify[CubeaddonDisplayOptionBottomPrevKey] = notify;
}

CompAction * cubeaddonGetBottomPrevButton (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionBottomPrevButton].value.action;
}

void cubeaddonSetBottomPrevButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionBottomPrevButton].value.action.initiate = init;
}

void cubeaddonSetBottomPrevButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->opt[CubeaddonDisplayOptionBottomPrevButton].value.action.terminate = term;
}

CompOption * cubeaddonGetBottomPrevButtonOption (CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[CubeaddonDisplayOptionBottomPrevButton];
}

void cubeaddonSetBottomPrevButtonNotify (CompDisplay *d, cubeaddonDisplayOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    od->notify[CubeaddonDisplayOptionBottomPrevButton] = notify;
}

Bool cubeaddonGetReflection (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionReflection].value.b;
}

CompOption * cubeaddonGetReflectionOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionReflection];
}

void cubeaddonSetReflectionNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionReflection] = notify;
}

unsigned short * cubeaddonGetGroundColor1 (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor1].value.c;
}

unsigned short cubeaddonGetGroundColor1Red (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor1].value.c[0];
}

unsigned short cubeaddonGetGroundColor1Green (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor1].value.c[1];
}

unsigned short cubeaddonGetGroundColor1Blue (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor1].value.c[2];
}

unsigned short cubeaddonGetGroundColor1Alpha (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor1].value.c[3];
}

CompOption * cubeaddonGetGroundColor1Option (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionGroundColor1];
}

void cubeaddonSetGroundColor1Notify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionGroundColor1] = notify;
}

unsigned short * cubeaddonGetGroundColor2 (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor2].value.c;
}

unsigned short cubeaddonGetGroundColor2Red (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor2].value.c[0];
}

unsigned short cubeaddonGetGroundColor2Green (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor2].value.c[1];
}

unsigned short cubeaddonGetGroundColor2Blue (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor2].value.c[2];
}

unsigned short cubeaddonGetGroundColor2Alpha (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundColor2].value.c[3];
}

CompOption * cubeaddonGetGroundColor2Option (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionGroundColor2];
}

void cubeaddonSetGroundColor2Notify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionGroundColor2] = notify;
}

float cubeaddonGetGroundSize (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionGroundSize].value.f;
}

CompOption * cubeaddonGetGroundSizeOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionGroundSize];
}

void cubeaddonSetGroundSizeNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionGroundSize] = notify;
}

float cubeaddonGetIntensity (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionIntensity].value.f;
}

CompOption * cubeaddonGetIntensityOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionIntensity];
}

void cubeaddonSetIntensityNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionIntensity] = notify;
}

Bool cubeaddonGetAutoZoom (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionAutoZoom].value.b;
}

CompOption * cubeaddonGetAutoZoomOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionAutoZoom];
}

void cubeaddonSetAutoZoomNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionAutoZoom] = notify;
}

Bool cubeaddonGetZoomManualOnly (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionZoomManualOnly].value.b;
}

CompOption * cubeaddonGetZoomManualOnlyOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionZoomManualOnly];
}

void cubeaddonSetZoomManualOnlyNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionZoomManualOnly] = notify;
}

int cubeaddonGetMode (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionMode].value.i;
}

CompOption * cubeaddonGetModeOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionMode];
}

void cubeaddonSetModeNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionMode] = notify;
}

int cubeaddonGetDeformation (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionDeformation].value.i;
}

CompOption * cubeaddonGetDeformationOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionDeformation];
}

void cubeaddonSetDeformationNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionDeformation] = notify;
}

Bool cubeaddonGetUnfoldDeformation (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionUnfoldDeformation].value.b;
}

CompOption * cubeaddonGetUnfoldDeformationOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionUnfoldDeformation];
}

void cubeaddonSetUnfoldDeformationNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionUnfoldDeformation] = notify;
}

Bool cubeaddonGetCylinderManualOnly (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionCylinderManualOnly].value.b;
}

CompOption * cubeaddonGetCylinderManualOnlyOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionCylinderManualOnly];
}

void cubeaddonSetCylinderManualOnlyNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionCylinderManualOnly] = notify;
}

Bool cubeaddonGetDeformCaps (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionDeformCaps].value.b;
}

CompOption * cubeaddonGetDeformCapsOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionDeformCaps];
}

void cubeaddonSetDeformCapsNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionDeformCaps] = notify;
}

float cubeaddonGetSphereAspect (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionSphereAspect].value.f;
}

CompOption * cubeaddonGetSphereAspectOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionSphereAspect];
}

void cubeaddonSetSphereAspectNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionSphereAspect] = notify;
}

Bool cubeaddonGetDrawTop (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionDrawTop].value.b;
}

CompOption * cubeaddonGetDrawTopOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionDrawTop];
}

void cubeaddonSetDrawTopNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionDrawTop] = notify;
}

Bool cubeaddonGetDrawBottom (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionDrawBottom].value.b;
}

CompOption * cubeaddonGetDrawBottomOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionDrawBottom];
}

void cubeaddonSetDrawBottomNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionDrawBottom] = notify;
}

Bool cubeaddonGetAdjustTop (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionAdjustTop].value.b;
}

CompOption * cubeaddonGetAdjustTopOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionAdjustTop];
}

void cubeaddonSetAdjustTopNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionAdjustTop] = notify;
}

Bool cubeaddonGetAdjustBottom (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionAdjustBottom].value.b;
}

CompOption * cubeaddonGetAdjustBottomOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionAdjustBottom];
}

void cubeaddonSetAdjustBottomNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionAdjustBottom] = notify;
}

Bool cubeaddonGetTopScale (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionTopScale].value.b;
}

CompOption * cubeaddonGetTopScaleOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionTopScale];
}

void cubeaddonSetTopScaleNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionTopScale] = notify;
}

Bool cubeaddonGetBottomScale (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionBottomScale].value.b;
}

CompOption * cubeaddonGetBottomScaleOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionBottomScale];
}

void cubeaddonSetBottomScaleNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionBottomScale] = notify;
}

Bool cubeaddonGetTopAspect (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionTopAspect].value.b;
}

CompOption * cubeaddonGetTopAspectOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionTopAspect];
}

void cubeaddonSetTopAspectNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionTopAspect] = notify;
}

Bool cubeaddonGetBottomAspect (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionBottomAspect].value.b;
}

CompOption * cubeaddonGetBottomAspectOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionBottomAspect];
}

void cubeaddonSetBottomAspectNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionBottomAspect] = notify;
}

Bool cubeaddonGetTopClamp (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionTopClamp].value.b;
}

CompOption * cubeaddonGetTopClampOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionTopClamp];
}

void cubeaddonSetTopClampNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionTopClamp] = notify;
}

Bool cubeaddonGetBottomClamp (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionBottomClamp].value.b;
}

CompOption * cubeaddonGetBottomClampOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionBottomClamp];
}

void cubeaddonSetBottomClampNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionBottomClamp] = notify;
}

unsigned short * cubeaddonGetTopColor (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionTopColor].value.c;
}

unsigned short cubeaddonGetTopColorRed (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionTopColor].value.c[0];
}

unsigned short cubeaddonGetTopColorGreen (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionTopColor].value.c[1];
}

unsigned short cubeaddonGetTopColorBlue (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionTopColor].value.c[2];
}

unsigned short cubeaddonGetTopColorAlpha (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionTopColor].value.c[3];
}

CompOption * cubeaddonGetTopColorOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionTopColor];
}

void cubeaddonSetTopColorNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionTopColor] = notify;
}

unsigned short * cubeaddonGetBottomColor (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionBottomColor].value.c;
}

unsigned short cubeaddonGetBottomColorRed (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionBottomColor].value.c[0];
}

unsigned short cubeaddonGetBottomColorGreen (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionBottomColor].value.c[1];
}

unsigned short cubeaddonGetBottomColorBlue (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionBottomColor].value.c[2];
}

unsigned short cubeaddonGetBottomColorAlpha (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return os->opt[CubeaddonScreenOptionBottomColor].value.c[3];
}

CompOption * cubeaddonGetBottomColorOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionBottomColor];
}

void cubeaddonSetBottomColorNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionBottomColor] = notify;
}

CompListValue * cubeaddonGetTopImages (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionTopImages].value.list;
}

CompOption * cubeaddonGetTopImagesOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionTopImages];
}

void cubeaddonSetTopImagesNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionTopImages] = notify;
}

CompListValue * cubeaddonGetBottomImages (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionBottomImages].value.list;
}

CompOption * cubeaddonGetBottomImagesOption (CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[CubeaddonScreenOptionBottomImages];
}

void cubeaddonSetBottomImagesNotify (CompScreen *s, cubeaddonScreenOptionChangeNotifyProc notify)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    os->notify[CubeaddonScreenOptionBottomImages] = notify;
}

CompOption * cubeaddonGetDisplayOption (CompDisplay *d, CubeaddonDisplayOptions num)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * cubeaddonGetScreenOption (CompScreen *s, CubeaddonScreenOptions num)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo cubeaddonOptionsDisplayOptionInfo[] = {
    { "top_next_key", "key", 0, 0, 0 },
    { "top_next_button", "button", 0, 0, 0 },
    { "top_prev_key", "key", 0, 0, 0 },
    { "top_prev_button", "button", 0, 0, 0 },
    { "bottom_next_key", "key", 0, 0, 0 },
    { "bottom_next_button", "button", 0, 0, 0 },
    { "bottom_prev_key", "key", 0, 0, 0 },
    { "bottom_prev_button", "button", 0, 0, 0 },
};

static Bool cubeaddonOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, CubeaddonDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CubeaddonDisplayOptionTopNextKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubeaddonDisplayOptionTopNextKey])
                (*od->notify[CubeaddonDisplayOptionTopNextKey]) (d, o, CubeaddonDisplayOptionTopNextKey);
            return TRUE;
        }
        break;
     case CubeaddonDisplayOptionTopNextButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubeaddonDisplayOptionTopNextButton])
                (*od->notify[CubeaddonDisplayOptionTopNextButton]) (d, o, CubeaddonDisplayOptionTopNextButton);
            return TRUE;
        }
        break;
     case CubeaddonDisplayOptionTopPrevKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubeaddonDisplayOptionTopPrevKey])
                (*od->notify[CubeaddonDisplayOptionTopPrevKey]) (d, o, CubeaddonDisplayOptionTopPrevKey);
            return TRUE;
        }
        break;
     case CubeaddonDisplayOptionTopPrevButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubeaddonDisplayOptionTopPrevButton])
                (*od->notify[CubeaddonDisplayOptionTopPrevButton]) (d, o, CubeaddonDisplayOptionTopPrevButton);
            return TRUE;
        }
        break;
     case CubeaddonDisplayOptionBottomNextKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubeaddonDisplayOptionBottomNextKey])
                (*od->notify[CubeaddonDisplayOptionBottomNextKey]) (d, o, CubeaddonDisplayOptionBottomNextKey);
            return TRUE;
        }
        break;
     case CubeaddonDisplayOptionBottomNextButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubeaddonDisplayOptionBottomNextButton])
                (*od->notify[CubeaddonDisplayOptionBottomNextButton]) (d, o, CubeaddonDisplayOptionBottomNextButton);
            return TRUE;
        }
        break;
     case CubeaddonDisplayOptionBottomPrevKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubeaddonDisplayOptionBottomPrevKey])
                (*od->notify[CubeaddonDisplayOptionBottomPrevKey]) (d, o, CubeaddonDisplayOptionBottomPrevKey);
            return TRUE;
        }
        break;
     case CubeaddonDisplayOptionBottomPrevButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubeaddonDisplayOptionBottomPrevButton])
                (*od->notify[CubeaddonDisplayOptionBottomPrevButton]) (d, o, CubeaddonDisplayOptionBottomPrevButton);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * cubeaddonOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    CUBEADDON_OPTIONS_DISPLAY(d);
    *count = CubeaddonDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo cubeaddonOptionsScreenOptionInfo[] = {
    { "reflection", "bool", 0, 0, 0 },
    { "ground_color1", "color", 0, 0, 0 },
    { "ground_color2", "color", 0, 0, 0 },
    { "ground_size", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "intensity", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "auto_zoom", "bool", 0, 0, 0 },
    { "zoom_manual_only", "bool", 0, 0, 0 },
    { "mode", "int", "<min>0</min><max>3</max>", 0, 0 },
    { "deformation", "int", "<min>0</min><max>2</max>", 0, 0 },
    { "unfold_deformation", "bool", 0, 0, 0 },
    { "cylinder_manual_only", "bool", 0, 0, 0 },
    { "deform_caps", "bool", 0, 0, 0 },
    { "sphere_aspect", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "draw_top", "bool", 0, 0, 0 },
    { "draw_bottom", "bool", 0, 0, 0 },
    { "adjust_top", "bool", 0, 0, 0 },
    { "adjust_bottom", "bool", 0, 0, 0 },
    { "top_scale", "bool", 0, 0, 0 },
    { "bottom_scale", "bool", 0, 0, 0 },
    { "top_aspect", "bool", 0, 0, 0 },
    { "bottom_aspect", "bool", 0, 0, 0 },
    { "top_clamp", "bool", 0, 0, 0 },
    { "bottom_clamp", "bool", 0, 0, 0 },
    { "top_color", "color", 0, 0, 0 },
    { "bottom_color", "color", 0, 0, 0 },
    { "top_images", "list", "<type>string</type>", 0, 0 },
    { "bottom_images", "list", "<type>string</type>", 0, 0 },
};

static Bool cubeaddonOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, CubeaddonScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CubeaddonScreenOptionReflection:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionReflection])
                (*os->notify[CubeaddonScreenOptionReflection]) (s, o, CubeaddonScreenOptionReflection);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionGroundColor1:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionGroundColor1])
                (*os->notify[CubeaddonScreenOptionGroundColor1]) (s, o, CubeaddonScreenOptionGroundColor1);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionGroundColor2:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionGroundColor2])
                (*os->notify[CubeaddonScreenOptionGroundColor2]) (s, o, CubeaddonScreenOptionGroundColor2);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionGroundSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionGroundSize])
                (*os->notify[CubeaddonScreenOptionGroundSize]) (s, o, CubeaddonScreenOptionGroundSize);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionIntensity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionIntensity])
                (*os->notify[CubeaddonScreenOptionIntensity]) (s, o, CubeaddonScreenOptionIntensity);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionAutoZoom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionAutoZoom])
                (*os->notify[CubeaddonScreenOptionAutoZoom]) (s, o, CubeaddonScreenOptionAutoZoom);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionZoomManualOnly:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionZoomManualOnly])
                (*os->notify[CubeaddonScreenOptionZoomManualOnly]) (s, o, CubeaddonScreenOptionZoomManualOnly);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionMode:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionMode])
                (*os->notify[CubeaddonScreenOptionMode]) (s, o, CubeaddonScreenOptionMode);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionDeformation:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionDeformation])
                (*os->notify[CubeaddonScreenOptionDeformation]) (s, o, CubeaddonScreenOptionDeformation);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionUnfoldDeformation:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionUnfoldDeformation])
                (*os->notify[CubeaddonScreenOptionUnfoldDeformation]) (s, o, CubeaddonScreenOptionUnfoldDeformation);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionCylinderManualOnly:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionCylinderManualOnly])
                (*os->notify[CubeaddonScreenOptionCylinderManualOnly]) (s, o, CubeaddonScreenOptionCylinderManualOnly);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionDeformCaps:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionDeformCaps])
                (*os->notify[CubeaddonScreenOptionDeformCaps]) (s, o, CubeaddonScreenOptionDeformCaps);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionSphereAspect:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionSphereAspect])
                (*os->notify[CubeaddonScreenOptionSphereAspect]) (s, o, CubeaddonScreenOptionSphereAspect);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionDrawTop:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionDrawTop])
                (*os->notify[CubeaddonScreenOptionDrawTop]) (s, o, CubeaddonScreenOptionDrawTop);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionDrawBottom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionDrawBottom])
                (*os->notify[CubeaddonScreenOptionDrawBottom]) (s, o, CubeaddonScreenOptionDrawBottom);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionAdjustTop:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionAdjustTop])
                (*os->notify[CubeaddonScreenOptionAdjustTop]) (s, o, CubeaddonScreenOptionAdjustTop);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionAdjustBottom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionAdjustBottom])
                (*os->notify[CubeaddonScreenOptionAdjustBottom]) (s, o, CubeaddonScreenOptionAdjustBottom);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionTopScale:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionTopScale])
                (*os->notify[CubeaddonScreenOptionTopScale]) (s, o, CubeaddonScreenOptionTopScale);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionBottomScale:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionBottomScale])
                (*os->notify[CubeaddonScreenOptionBottomScale]) (s, o, CubeaddonScreenOptionBottomScale);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionTopAspect:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionTopAspect])
                (*os->notify[CubeaddonScreenOptionTopAspect]) (s, o, CubeaddonScreenOptionTopAspect);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionBottomAspect:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionBottomAspect])
                (*os->notify[CubeaddonScreenOptionBottomAspect]) (s, o, CubeaddonScreenOptionBottomAspect);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionTopClamp:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionTopClamp])
                (*os->notify[CubeaddonScreenOptionTopClamp]) (s, o, CubeaddonScreenOptionTopClamp);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionBottomClamp:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionBottomClamp])
                (*os->notify[CubeaddonScreenOptionBottomClamp]) (s, o, CubeaddonScreenOptionBottomClamp);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionTopColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionTopColor])
                (*os->notify[CubeaddonScreenOptionTopColor]) (s, o, CubeaddonScreenOptionTopColor);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionBottomColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionBottomColor])
                (*os->notify[CubeaddonScreenOptionBottomColor]) (s, o, CubeaddonScreenOptionBottomColor);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionTopImages:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionTopImages])
                (*os->notify[CubeaddonScreenOptionTopImages]) (s, o, CubeaddonScreenOptionTopImages);
            return TRUE;
        }
        break;
     case CubeaddonScreenOptionBottomImages:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubeaddonScreenOptionBottomImages])
                (*os->notify[CubeaddonScreenOptionBottomImages]) (s, o, CubeaddonScreenOptionBottomImages);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * cubeaddonOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    CUBEADDON_OPTIONS_SCREEN(s);
    *count = CubeaddonScreenOptionNum;
    return os->opt;
}

static Bool cubeaddonOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    CubeaddonOptionsScreen *os;
    
    CUBEADDON_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(CubeaddonOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &cubeaddonOptionsMetadata, cubeaddonOptionsScreenOptionInfo, os->opt, CubeaddonScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void cubeaddonOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    CUBEADDON_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, CubeaddonScreenOptionNum);

    free (os);
}

static Bool cubeaddonOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    CubeaddonOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(CubeaddonOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[CubeaddonOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &cubeaddonOptionsMetadata, cubeaddonOptionsDisplayOptionInfo, od->opt, CubeaddonDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void cubeaddonOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    CUBEADDON_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, CubeaddonDisplayOptionNum);

    free (od);
}

static Bool cubeaddonOptionsInit (CompPlugin *p)
{
    CubeaddonOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (CubeaddonOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&cubeaddonOptionsMetadata, "cubeaddon",cubeaddonOptionsDisplayOptionInfo, CubeaddonDisplayOptionNum, cubeaddonOptionsScreenOptionInfo, CubeaddonScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&cubeaddonOptionsMetadata, "cubeaddon");
    if (cubeaddonPluginVTable && cubeaddonPluginVTable->init)
        return cubeaddonPluginVTable->init (p);
    return TRUE;
}

static void cubeaddonOptionsFini (CompPlugin *p)
{
    if (cubeaddonPluginVTable && cubeaddonPluginVTable->fini)
        cubeaddonPluginVTable->fini (p);

    if (CubeaddonOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (CubeaddonOptionsDisplayPrivateIndex);

    compFiniMetadata (&cubeaddonOptionsMetadata);
}

static CompBool cubeaddonOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) cubeaddonOptionsInitDisplay,
        (InitPluginObjectProc) cubeaddonOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void cubeaddonOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) cubeaddonOptionsFiniDisplay,
        (FiniPluginObjectProc) cubeaddonOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool cubeaddonOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = cubeaddonOptionsInitObject (p, o);
    if (cubeaddonPluginVTable->initObject)
        rv &= cubeaddonPluginVTable->initObject (p, o);
    return rv;
}

static void cubeaddonOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (cubeaddonPluginVTable->finiObject)
        cubeaddonPluginVTable->finiObject (p, o);
    cubeaddonOptionsFiniObject (p, o);
}

static CompOption * cubeaddonOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) cubeaddonOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) cubeaddonOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool cubeaddonOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) cubeaddonOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) cubeaddonOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
cubeaddonOptionsGetMetadata (CompPlugin *plugin)
{
    return &cubeaddonOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!cubeaddonPluginVTable)
    {
        cubeaddonPluginVTable = getCompPluginInfo ();
        memcpy(&cubeaddonOptionsVTable, cubeaddonPluginVTable, sizeof(CompPluginVTable));
        cubeaddonOptionsVTable.getMetadata = cubeaddonOptionsGetMetadata;
        cubeaddonOptionsVTable.init = cubeaddonOptionsInit;
        cubeaddonOptionsVTable.fini = cubeaddonOptionsFini;
        cubeaddonOptionsVTable.initObject = cubeaddonOptionsInitObjectWrapper;
        cubeaddonOptionsVTable.finiObject = cubeaddonOptionsFiniObjectWrapper;
        cubeaddonOptionsVTable.getObjectOptions = cubeaddonOptionsGetObjectOptions;
	cubeaddonOptionsVTable.setObjectOption = cubeaddonOptionsSetObjectOption;
	
    }
    return &cubeaddonOptionsVTable;
}

