/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _TD_OPTIONS_H
#define _TD_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    TdDisplayOptionNum
} TdDisplayOptions;

typedef void (*tdDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, TdDisplayOptions num);

CompOption *tdGetDisplayOption (CompDisplay *d, TdDisplayOptions num);

typedef enum
{
    TdScreenOptionWindowMatch,
    TdScreenOptionMinCubeSize,
    TdScreenOptionMaxWindowSpace,
    TdScreenOptionManualOnly,
    TdScreenOptionWidth,
    TdScreenOptionBevel,
    TdScreenOptionWidthColor,
    TdScreenOptionWidthColorInactive,
    TdScreenOptionBevelTopleft,
    TdScreenOptionBevelTopright,
    TdScreenOptionBevelBottomleft,
    TdScreenOptionBevelBottomright,
    TdScreenOptionNum
} TdScreenOptions;

typedef void (*tdScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, TdScreenOptions num);

CompOption *tdGetScreenOption (CompScreen *s, TdScreenOptions num);

CompMatch *      tdGetWindowMatch (CompScreen *s);
CompOption *     tdGetWindowMatchOption (CompScreen *s);
void             tdSetWindowMatchNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

int              tdGetMinCubeSize (CompScreen *s);
CompOption *     tdGetMinCubeSizeOption (CompScreen *s);
void             tdSetMinCubeSizeNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

int              tdGetMaxWindowSpace (CompScreen *s);
CompOption *     tdGetMaxWindowSpaceOption (CompScreen *s);
void             tdSetMaxWindowSpaceNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

Bool             tdGetManualOnly (CompScreen *s);
CompOption *     tdGetManualOnlyOption (CompScreen *s);
void             tdSetManualOnlyNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

float            tdGetWidth (CompScreen *s);
CompOption *     tdGetWidthOption (CompScreen *s);
void             tdSetWidthNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

int              tdGetBevel (CompScreen *s);
CompOption *     tdGetBevelOption (CompScreen *s);
void             tdSetBevelNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

unsigned short * tdGetWidthColor (CompScreen *s);
unsigned short   tdGetWidthColorRed (CompScreen *s);
unsigned short   tdGetWidthColorGreen (CompScreen *s);
unsigned short   tdGetWidthColorBlue (CompScreen *s);
unsigned short   tdGetWidthColorAlpha (CompScreen *s);
CompOption *     tdGetWidthColorOption (CompScreen *s);
void             tdSetWidthColorNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

unsigned short * tdGetWidthColorInactive (CompScreen *s);
unsigned short   tdGetWidthColorInactiveRed (CompScreen *s);
unsigned short   tdGetWidthColorInactiveGreen (CompScreen *s);
unsigned short   tdGetWidthColorInactiveBlue (CompScreen *s);
unsigned short   tdGetWidthColorInactiveAlpha (CompScreen *s);
CompOption *     tdGetWidthColorInactiveOption (CompScreen *s);
void             tdSetWidthColorInactiveNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

Bool             tdGetBevelTopleft (CompScreen *s);
CompOption *     tdGetBevelTopleftOption (CompScreen *s);
void             tdSetBevelTopleftNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

Bool             tdGetBevelTopright (CompScreen *s);
CompOption *     tdGetBevelToprightOption (CompScreen *s);
void             tdSetBevelToprightNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

Bool             tdGetBevelBottomleft (CompScreen *s);
CompOption *     tdGetBevelBottomleftOption (CompScreen *s);
void             tdSetBevelBottomleftNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

Bool             tdGetBevelBottomright (CompScreen *s);
CompOption *     tdGetBevelBottomrightOption (CompScreen *s);
void             tdSetBevelBottomrightNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
