/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "trailfocus_options.h"

static int TrailfocusOptionsDisplayPrivateIndex;

static CompMetadata trailfocusOptionsMetadata;

static CompPluginVTable *trailfocusPluginVTable = NULL;
CompPluginVTable trailfocusOptionsVTable;

#define TRAILFOCUS_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, TrailfocusOptions, o)
#define TRAILFOCUS_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, TrailfocusOptions, o)

typedef struct _TrailfocusOptionsDisplay
{
    int screenPrivateIndex;

} TrailfocusOptionsDisplay;

typedef struct _TrailfocusOptionsScreen
{
    CompOption opt[TrailfocusScreenOptionNum];
    trailfocusScreenOptionChangeNotifyProc notify[TrailfocusScreenOptionNum];
} TrailfocusOptionsScreen;

CompMatch * trailfocusGetWindowMatch (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionWindowMatch].value.match;
}

CompOption * trailfocusGetWindowMatchOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionWindowMatch];
}

void trailfocusSetWindowMatchNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionWindowMatch] = notify;
}

int trailfocusGetWindowsCount (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return os->opt[TrailfocusScreenOptionWindowsCount].value.i;
}

CompOption * trailfocusGetWindowsCountOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionWindowsCount];
}

void trailfocusSetWindowsCountNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionWindowsCount] = notify;
}

int trailfocusGetWindowsStart (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return os->opt[TrailfocusScreenOptionWindowsStart].value.i;
}

CompOption * trailfocusGetWindowsStartOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionWindowsStart];
}

void trailfocusSetWindowsStartNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionWindowsStart] = notify;
}

int trailfocusGetMaxOpacity (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return os->opt[TrailfocusScreenOptionMaxOpacity].value.i;
}

CompOption * trailfocusGetMaxOpacityOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionMaxOpacity];
}

void trailfocusSetMaxOpacityNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionMaxOpacity] = notify;
}

int trailfocusGetMinOpacity (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return os->opt[TrailfocusScreenOptionMinOpacity].value.i;
}

CompOption * trailfocusGetMinOpacityOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionMinOpacity];
}

void trailfocusSetMinOpacityNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionMinOpacity] = notify;
}

int trailfocusGetMaxBrightness (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return os->opt[TrailfocusScreenOptionMaxBrightness].value.i;
}

CompOption * trailfocusGetMaxBrightnessOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionMaxBrightness];
}

void trailfocusSetMaxBrightnessNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionMaxBrightness] = notify;
}

int trailfocusGetMinBrightness (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return os->opt[TrailfocusScreenOptionMinBrightness].value.i;
}

CompOption * trailfocusGetMinBrightnessOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionMinBrightness];
}

void trailfocusSetMinBrightnessNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionMinBrightness] = notify;
}

int trailfocusGetMaxSaturation (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return os->opt[TrailfocusScreenOptionMaxSaturation].value.i;
}

CompOption * trailfocusGetMaxSaturationOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionMaxSaturation];
}

void trailfocusSetMaxSaturationNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionMaxSaturation] = notify;
}

int trailfocusGetMinSaturation (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return os->opt[TrailfocusScreenOptionMinSaturation].value.i;
}

CompOption * trailfocusGetMinSaturationOption (CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[TrailfocusScreenOptionMinSaturation];
}

void trailfocusSetMinSaturationNotify (CompScreen *s, trailfocusScreenOptionChangeNotifyProc notify)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    os->notify[TrailfocusScreenOptionMinSaturation] = notify;
}

CompOption * trailfocusGetScreenOption (CompScreen *s, TrailfocusScreenOptions num)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo trailfocusOptionsScreenOptionInfo[] = {
    { "window_match", "match", 0, 0, 0 },
    { "windows_count", "int", "<min>1</min><max>150</max>", 0, 0 },
    { "windows_start", "int", "<min>1</min><max>20</max>", 0, 0 },
    { "max_opacity", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "min_opacity", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "max_brightness", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "min_brightness", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "max_saturation", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "min_saturation", "int", "<min>1</min><max>100</max>", 0, 0 },
};

static Bool trailfocusOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, TrailfocusScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case TrailfocusScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionWindowMatch])
                (*os->notify[TrailfocusScreenOptionWindowMatch]) (s, o, TrailfocusScreenOptionWindowMatch);
            return TRUE;
        }
        break;
     case TrailfocusScreenOptionWindowsCount:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionWindowsCount])
                (*os->notify[TrailfocusScreenOptionWindowsCount]) (s, o, TrailfocusScreenOptionWindowsCount);
            return TRUE;
        }
        break;
     case TrailfocusScreenOptionWindowsStart:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionWindowsStart])
                (*os->notify[TrailfocusScreenOptionWindowsStart]) (s, o, TrailfocusScreenOptionWindowsStart);
            return TRUE;
        }
        break;
     case TrailfocusScreenOptionMaxOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionMaxOpacity])
                (*os->notify[TrailfocusScreenOptionMaxOpacity]) (s, o, TrailfocusScreenOptionMaxOpacity);
            return TRUE;
        }
        break;
     case TrailfocusScreenOptionMinOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionMinOpacity])
                (*os->notify[TrailfocusScreenOptionMinOpacity]) (s, o, TrailfocusScreenOptionMinOpacity);
            return TRUE;
        }
        break;
     case TrailfocusScreenOptionMaxBrightness:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionMaxBrightness])
                (*os->notify[TrailfocusScreenOptionMaxBrightness]) (s, o, TrailfocusScreenOptionMaxBrightness);
            return TRUE;
        }
        break;
     case TrailfocusScreenOptionMinBrightness:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionMinBrightness])
                (*os->notify[TrailfocusScreenOptionMinBrightness]) (s, o, TrailfocusScreenOptionMinBrightness);
            return TRUE;
        }
        break;
     case TrailfocusScreenOptionMaxSaturation:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionMaxSaturation])
                (*os->notify[TrailfocusScreenOptionMaxSaturation]) (s, o, TrailfocusScreenOptionMaxSaturation);
            return TRUE;
        }
        break;
     case TrailfocusScreenOptionMinSaturation:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TrailfocusScreenOptionMinSaturation])
                (*os->notify[TrailfocusScreenOptionMinSaturation]) (s, o, TrailfocusScreenOptionMinSaturation);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * trailfocusOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    TRAILFOCUS_OPTIONS_SCREEN(s);
    *count = TrailfocusScreenOptionNum;
    return os->opt;
}

static Bool trailfocusOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    TrailfocusOptionsScreen *os;
    
    TRAILFOCUS_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(TrailfocusOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &trailfocusOptionsMetadata, trailfocusOptionsScreenOptionInfo, os->opt, TrailfocusScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void trailfocusOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    TRAILFOCUS_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, TrailfocusScreenOptionNum);

    free (os);
}

static Bool trailfocusOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    TrailfocusOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(TrailfocusOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[TrailfocusOptionsDisplayPrivateIndex].ptr = od;

    
    return TRUE;
}

static void trailfocusOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    TRAILFOCUS_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool trailfocusOptionsInit (CompPlugin *p)
{
    TrailfocusOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (TrailfocusOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&trailfocusOptionsMetadata, "trailfocus",0, 0, trailfocusOptionsScreenOptionInfo, TrailfocusScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&trailfocusOptionsMetadata, "trailfocus");
    if (trailfocusPluginVTable && trailfocusPluginVTable->init)
        return trailfocusPluginVTable->init (p);
    return TRUE;
}

static void trailfocusOptionsFini (CompPlugin *p)
{
    if (trailfocusPluginVTable && trailfocusPluginVTable->fini)
        trailfocusPluginVTable->fini (p);

    if (TrailfocusOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (TrailfocusOptionsDisplayPrivateIndex);

    compFiniMetadata (&trailfocusOptionsMetadata);
}

static CompBool trailfocusOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) trailfocusOptionsInitDisplay,
        (InitPluginObjectProc) trailfocusOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void trailfocusOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) trailfocusOptionsFiniDisplay,
        (FiniPluginObjectProc) trailfocusOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool trailfocusOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = trailfocusOptionsInitObject (p, o);
    if (trailfocusPluginVTable->initObject)
        rv &= trailfocusPluginVTable->initObject (p, o);
    return rv;
}

static void trailfocusOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (trailfocusPluginVTable->finiObject)
        trailfocusPluginVTable->finiObject (p, o);
    trailfocusOptionsFiniObject (p, o);
}

static CompOption * trailfocusOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) 0,
        (GetPluginObjectOptionsProc) trailfocusOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool trailfocusOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) trailfocusOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
trailfocusOptionsGetMetadata (CompPlugin *plugin)
{
    return &trailfocusOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!trailfocusPluginVTable)
    {
        trailfocusPluginVTable = getCompPluginInfo ();
        memcpy(&trailfocusOptionsVTable, trailfocusPluginVTable, sizeof(CompPluginVTable));
        trailfocusOptionsVTable.getMetadata = trailfocusOptionsGetMetadata;
        trailfocusOptionsVTable.init = trailfocusOptionsInit;
        trailfocusOptionsVTable.fini = trailfocusOptionsFini;
        trailfocusOptionsVTable.initObject = trailfocusOptionsInitObjectWrapper;
        trailfocusOptionsVTable.finiObject = trailfocusOptionsFiniObjectWrapper;
        trailfocusOptionsVTable.getObjectOptions = trailfocusOptionsGetObjectOptions;
	trailfocusOptionsVTable.setObjectOption = trailfocusOptionsSetObjectOption;
	
    }
    return &trailfocusOptionsVTable;
}

