/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "cubecaps_options.h"

static int CubecapsOptionsDisplayPrivateIndex;

static CompMetadata cubecapsOptionsMetadata;

static CompPluginVTable *cubecapsPluginVTable = NULL;
CompPluginVTable cubecapsOptionsVTable;

#define CUBECAPS_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, CubecapsOptions, o)
#define CUBECAPS_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, CubecapsOptions, o)

typedef struct _CubecapsOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[CubecapsDisplayOptionNum];
    cubecapsDisplayOptionChangeNotifyProc notify[CubecapsDisplayOptionNum];
} CubecapsOptionsDisplay;

typedef struct _CubecapsOptionsScreen
{
    CompOption opt[CubecapsScreenOptionNum];
    cubecapsScreenOptionChangeNotifyProc notify[CubecapsScreenOptionNum];
} CubecapsOptionsScreen;

CompAction * cubecapsGetTopNextKey (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopNextKey].value.action;
}

void cubecapsSetTopNextKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopNextKey].value.action.initiate = init;
}

void cubecapsSetTopNextKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopNextKey].value.action.terminate = term;
}

CompOption * cubecapsGetTopNextKeyOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopNextKey];
}

void cubecapsSetTopNextKeyNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionTopNextKey] = notify;
}

CompAction * cubecapsGetTopNextButton (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopNextButton].value.action;
}

void cubecapsSetTopNextButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopNextButton].value.action.initiate = init;
}

void cubecapsSetTopNextButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopNextButton].value.action.terminate = term;
}

CompOption * cubecapsGetTopNextButtonOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopNextButton];
}

void cubecapsSetTopNextButtonNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionTopNextButton] = notify;
}

CompAction * cubecapsGetTopPrevKey (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopPrevKey].value.action;
}

void cubecapsSetTopPrevKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopPrevKey].value.action.initiate = init;
}

void cubecapsSetTopPrevKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopPrevKey].value.action.terminate = term;
}

CompOption * cubecapsGetTopPrevKeyOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopPrevKey];
}

void cubecapsSetTopPrevKeyNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionTopPrevKey] = notify;
}

CompAction * cubecapsGetTopPrevButton (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopPrevButton].value.action;
}

void cubecapsSetTopPrevButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopPrevButton].value.action.initiate = init;
}

void cubecapsSetTopPrevButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopPrevButton].value.action.terminate = term;
}

CompOption * cubecapsGetTopPrevButtonOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopPrevButton];
}

void cubecapsSetTopPrevButtonNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionTopPrevButton] = notify;
}

CompAction * cubecapsGetBottomNextKey (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomNextKey].value.action;
}

void cubecapsSetBottomNextKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomNextKey].value.action.initiate = init;
}

void cubecapsSetBottomNextKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomNextKey].value.action.terminate = term;
}

CompOption * cubecapsGetBottomNextKeyOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomNextKey];
}

void cubecapsSetBottomNextKeyNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionBottomNextKey] = notify;
}

CompAction * cubecapsGetBottomNextButton (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomNextButton].value.action;
}

void cubecapsSetBottomNextButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomNextButton].value.action.initiate = init;
}

void cubecapsSetBottomNextButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomNextButton].value.action.terminate = term;
}

CompOption * cubecapsGetBottomNextButtonOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomNextButton];
}

void cubecapsSetBottomNextButtonNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionBottomNextButton] = notify;
}

CompAction * cubecapsGetBottomPrevKey (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomPrevKey].value.action;
}

void cubecapsSetBottomPrevKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomPrevKey].value.action.initiate = init;
}

void cubecapsSetBottomPrevKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomPrevKey].value.action.terminate = term;
}

CompOption * cubecapsGetBottomPrevKeyOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomPrevKey];
}

void cubecapsSetBottomPrevKeyNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionBottomPrevKey] = notify;
}

CompAction * cubecapsGetBottomPrevButton (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomPrevButton].value.action;
}

void cubecapsSetBottomPrevButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomPrevButton].value.action.initiate = init;
}

void cubecapsSetBottomPrevButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomPrevButton].value.action.terminate = term;
}

CompOption * cubecapsGetBottomPrevButtonOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomPrevButton];
}

void cubecapsSetBottomPrevButtonNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionBottomPrevButton] = notify;
}

Bool cubecapsGetDrawTop (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionDrawTop].value.b;
}

CompOption * cubecapsGetDrawTopOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionDrawTop];
}

void cubecapsSetDrawTopNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionDrawTop] = notify;
}

Bool cubecapsGetDrawBottom (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionDrawBottom].value.b;
}

CompOption * cubecapsGetDrawBottomOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionDrawBottom];
}

void cubecapsSetDrawBottomNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionDrawBottom] = notify;
}

Bool cubecapsGetAdjustTop (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionAdjustTop].value.b;
}

CompOption * cubecapsGetAdjustTopOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionAdjustTop];
}

void cubecapsSetAdjustTopNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionAdjustTop] = notify;
}

Bool cubecapsGetAdjustBottom (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionAdjustBottom].value.b;
}

CompOption * cubecapsGetAdjustBottomOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionAdjustBottom];
}

void cubecapsSetAdjustBottomNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionAdjustBottom] = notify;
}

Bool cubecapsGetScaleTopImage (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionScaleTopImage].value.b;
}

CompOption * cubecapsGetScaleTopImageOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionScaleTopImage];
}

void cubecapsSetScaleTopImageNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionScaleTopImage] = notify;
}

Bool cubecapsGetScaleBottomImage (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionScaleBottomImage].value.b;
}

CompOption * cubecapsGetScaleBottomImageOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionScaleBottomImage];
}

void cubecapsSetScaleBottomImageNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionScaleBottomImage] = notify;
}

Bool cubecapsGetClampTopToBorder (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionClampTopToBorder].value.b;
}

CompOption * cubecapsGetClampTopToBorderOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionClampTopToBorder];
}

void cubecapsSetClampTopToBorderNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionClampTopToBorder] = notify;
}

Bool cubecapsGetClampBottomToBorder (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionClampBottomToBorder].value.b;
}

CompOption * cubecapsGetClampBottomToBorderOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionClampBottomToBorder];
}

void cubecapsSetClampBottomToBorderNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionClampBottomToBorder] = notify;
}

unsigned short * cubecapsGetTopColor (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c;
}

unsigned short cubecapsGetTopColorRed (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c[0];
}

unsigned short cubecapsGetTopColorGreen (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c[1];
}

unsigned short cubecapsGetTopColorBlue (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c[2];
}

unsigned short cubecapsGetTopColorAlpha (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c[3];
}

CompOption * cubecapsGetTopColorOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionTopColor];
}

void cubecapsSetTopColorNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionTopColor] = notify;
}

unsigned short * cubecapsGetBottomColor (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c;
}

unsigned short cubecapsGetBottomColorRed (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c[0];
}

unsigned short cubecapsGetBottomColorGreen (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c[1];
}

unsigned short cubecapsGetBottomColorBlue (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c[2];
}

unsigned short cubecapsGetBottomColorAlpha (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c[3];
}

CompOption * cubecapsGetBottomColorOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionBottomColor];
}

void cubecapsSetBottomColorNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionBottomColor] = notify;
}

CompListValue * cubecapsGetTopImages (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionTopImages].value.list;
}

CompOption * cubecapsGetTopImagesOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionTopImages];
}

void cubecapsSetTopImagesNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionTopImages] = notify;
}

CompListValue * cubecapsGetBottomImages (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionBottomImages].value.list;
}

CompOption * cubecapsGetBottomImagesOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionBottomImages];
}

void cubecapsSetBottomImagesNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionBottomImages] = notify;
}

CompOption * cubecapsGetDisplayOption (CompDisplay *d, CubecapsDisplayOptions num)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * cubecapsGetScreenOption (CompScreen *s, CubecapsScreenOptions num)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo cubecapsOptionsDisplayOptionInfo[] = {
    { "top_next_key", "key", 0, 0, 0 },
    { "top_next_button", "button", 0, 0, 0 },
    { "top_prev_key", "key", 0, 0, 0 },
    { "top_prev_button", "button", 0, 0, 0 },
    { "bottom_next_key", "key", 0, 0, 0 },
    { "bottom_next_button", "button", 0, 0, 0 },
    { "bottom_prev_key", "key", 0, 0, 0 },
    { "bottom_prev_button", "button", 0, 0, 0 },
};

static Bool cubecapsOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, CubecapsDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CubecapsDisplayOptionTopNextKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionTopNextKey])
                (*od->notify[CubecapsDisplayOptionTopNextKey]) (d, o, CubecapsDisplayOptionTopNextKey);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionTopNextButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionTopNextButton])
                (*od->notify[CubecapsDisplayOptionTopNextButton]) (d, o, CubecapsDisplayOptionTopNextButton);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionTopPrevKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionTopPrevKey])
                (*od->notify[CubecapsDisplayOptionTopPrevKey]) (d, o, CubecapsDisplayOptionTopPrevKey);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionTopPrevButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionTopPrevButton])
                (*od->notify[CubecapsDisplayOptionTopPrevButton]) (d, o, CubecapsDisplayOptionTopPrevButton);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionBottomNextKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionBottomNextKey])
                (*od->notify[CubecapsDisplayOptionBottomNextKey]) (d, o, CubecapsDisplayOptionBottomNextKey);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionBottomNextButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionBottomNextButton])
                (*od->notify[CubecapsDisplayOptionBottomNextButton]) (d, o, CubecapsDisplayOptionBottomNextButton);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionBottomPrevKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionBottomPrevKey])
                (*od->notify[CubecapsDisplayOptionBottomPrevKey]) (d, o, CubecapsDisplayOptionBottomPrevKey);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionBottomPrevButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionBottomPrevButton])
                (*od->notify[CubecapsDisplayOptionBottomPrevButton]) (d, o, CubecapsDisplayOptionBottomPrevButton);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * cubecapsOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    *count = CubecapsDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo cubecapsOptionsScreenOptionInfo[] = {
    { "draw_top", "bool", 0, 0, 0 },
    { "draw_bottom", "bool", 0, 0, 0 },
    { "adjust_top", "bool", 0, 0, 0 },
    { "adjust_bottom", "bool", 0, 0, 0 },
    { "scale_top_image", "bool", 0, 0, 0 },
    { "scale_bottom_image", "bool", 0, 0, 0 },
    { "clamp_top_to_border", "bool", 0, 0, 0 },
    { "clamp_bottom_to_border", "bool", 0, 0, 0 },
    { "top_color", "color", 0, 0, 0 },
    { "bottom_color", "color", 0, 0, 0 },
    { "top_images", "list", "<type>string</type>", 0, 0 },
    { "bottom_images", "list", "<type>string</type>", 0, 0 },
};

static Bool cubecapsOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, CubecapsScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CubecapsScreenOptionDrawTop:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionDrawTop])
                (*os->notify[CubecapsScreenOptionDrawTop]) (s, o, CubecapsScreenOptionDrawTop);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionDrawBottom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionDrawBottom])
                (*os->notify[CubecapsScreenOptionDrawBottom]) (s, o, CubecapsScreenOptionDrawBottom);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionAdjustTop:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionAdjustTop])
                (*os->notify[CubecapsScreenOptionAdjustTop]) (s, o, CubecapsScreenOptionAdjustTop);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionAdjustBottom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionAdjustBottom])
                (*os->notify[CubecapsScreenOptionAdjustBottom]) (s, o, CubecapsScreenOptionAdjustBottom);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionScaleTopImage:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionScaleTopImage])
                (*os->notify[CubecapsScreenOptionScaleTopImage]) (s, o, CubecapsScreenOptionScaleTopImage);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionScaleBottomImage:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionScaleBottomImage])
                (*os->notify[CubecapsScreenOptionScaleBottomImage]) (s, o, CubecapsScreenOptionScaleBottomImage);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionClampTopToBorder:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionClampTopToBorder])
                (*os->notify[CubecapsScreenOptionClampTopToBorder]) (s, o, CubecapsScreenOptionClampTopToBorder);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionClampBottomToBorder:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionClampBottomToBorder])
                (*os->notify[CubecapsScreenOptionClampBottomToBorder]) (s, o, CubecapsScreenOptionClampBottomToBorder);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionTopColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionTopColor])
                (*os->notify[CubecapsScreenOptionTopColor]) (s, o, CubecapsScreenOptionTopColor);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionBottomColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionBottomColor])
                (*os->notify[CubecapsScreenOptionBottomColor]) (s, o, CubecapsScreenOptionBottomColor);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionTopImages:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionTopImages])
                (*os->notify[CubecapsScreenOptionTopImages]) (s, o, CubecapsScreenOptionTopImages);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionBottomImages:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionBottomImages])
                (*os->notify[CubecapsScreenOptionBottomImages]) (s, o, CubecapsScreenOptionBottomImages);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * cubecapsOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    *count = CubecapsScreenOptionNum;
    return os->opt;
}

static Bool cubecapsOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    CubecapsOptionsScreen *os;
    
    CUBECAPS_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(CubecapsOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &cubecapsOptionsMetadata, cubecapsOptionsScreenOptionInfo, os->opt, CubecapsScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void cubecapsOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, CubecapsScreenOptionNum);

    free (os);
}

static Bool cubecapsOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    CubecapsOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(CubecapsOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[CubecapsOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &cubecapsOptionsMetadata, cubecapsOptionsDisplayOptionInfo, od->opt, CubecapsDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void cubecapsOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, CubecapsDisplayOptionNum);

    free (od);
}

static Bool cubecapsOptionsInit (CompPlugin *p)
{
    CubecapsOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (CubecapsOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&cubecapsOptionsMetadata, "cubecaps",cubecapsOptionsDisplayOptionInfo, CubecapsDisplayOptionNum, cubecapsOptionsScreenOptionInfo, CubecapsScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&cubecapsOptionsMetadata, "cubecaps");
    if (cubecapsPluginVTable && cubecapsPluginVTable->init)
        return cubecapsPluginVTable->init (p);
    return TRUE;
}

static void cubecapsOptionsFini (CompPlugin *p)
{
    if (cubecapsPluginVTable && cubecapsPluginVTable->fini)
        cubecapsPluginVTable->fini (p);

    if (CubecapsOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (CubecapsOptionsDisplayPrivateIndex);

    compFiniMetadata (&cubecapsOptionsMetadata);
}

static CompBool cubecapsOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) cubecapsOptionsInitDisplay,
        (InitPluginObjectProc) cubecapsOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void cubecapsOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) cubecapsOptionsFiniDisplay,
        (FiniPluginObjectProc) cubecapsOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool cubecapsOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = cubecapsOptionsInitObject (p, o);
    if (cubecapsPluginVTable->initObject)
        rv &= cubecapsPluginVTable->initObject (p, o);
    return rv;
}

static void cubecapsOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (cubecapsPluginVTable->finiObject)
        cubecapsPluginVTable->finiObject (p, o);
    cubecapsOptionsFiniObject (p, o);
}

static CompOption * cubecapsOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) cubecapsOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) cubecapsOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool cubecapsOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) cubecapsOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) cubecapsOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
cubecapsOptionsGetMetadata (CompPlugin *plugin)
{
    return &cubecapsOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!cubecapsPluginVTable)
    {
        cubecapsPluginVTable = getCompPluginInfo ();
        memcpy(&cubecapsOptionsVTable, cubecapsPluginVTable, sizeof(CompPluginVTable));
        cubecapsOptionsVTable.getMetadata = cubecapsOptionsGetMetadata;
        cubecapsOptionsVTable.init = cubecapsOptionsInit;
        cubecapsOptionsVTable.fini = cubecapsOptionsFini;
        cubecapsOptionsVTable.initObject = cubecapsOptionsInitObjectWrapper;
        cubecapsOptionsVTable.finiObject = cubecapsOptionsFiniObjectWrapper;
        cubecapsOptionsVTable.getObjectOptions = cubecapsOptionsGetObjectOptions;
	cubecapsOptionsVTable.setObjectOption = cubecapsOptionsSetObjectOption;
	
    }
    return &cubecapsOptionsVTable;
}

