/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "bench_options.h"

static int BenchOptionsDisplayPrivateIndex;

static CompMetadata benchOptionsMetadata;

static CompPluginVTable *benchPluginVTable = NULL;
CompPluginVTable benchOptionsVTable;

#define BENCH_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, BenchOptions, o)
#define BENCH_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, BenchOptions, o)

typedef struct _BenchOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[BenchDisplayOptionNum];
    benchDisplayOptionChangeNotifyProc notify[BenchDisplayOptionNum];
} BenchOptionsDisplay;

typedef struct _BenchOptionsScreen
{
} BenchOptionsScreen;

CompAction * benchGetInitiateKey (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionInitiateKey].value.action;
}

void benchSetInitiateKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->opt[BenchDisplayOptionInitiateKey].value.action.initiate = init;
}

void benchSetInitiateKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->opt[BenchDisplayOptionInitiateKey].value.action.terminate = term;
}

CompOption * benchGetInitiateKeyOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionInitiateKey];
}

void benchSetInitiateKeyNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionInitiateKey] = notify;
}

Bool benchGetDisableLimiter (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionDisableLimiter].value.b;
}

CompOption * benchGetDisableLimiterOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionDisableLimiter];
}

void benchSetDisableLimiterNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionDisableLimiter] = notify;
}

Bool benchGetOutputScreen (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionOutputScreen].value.b;
}

CompOption * benchGetOutputScreenOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionOutputScreen];
}

void benchSetOutputScreenNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionOutputScreen] = notify;
}

int benchGetPositionX (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionPositionX].value.i;
}

CompOption * benchGetPositionXOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionPositionX];
}

void benchSetPositionXNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionPositionX] = notify;
}

int benchGetPositionY (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionPositionY].value.i;
}

CompOption * benchGetPositionYOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionPositionY];
}

void benchSetPositionYNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionPositionY] = notify;
}

Bool benchGetOutputConsole (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionOutputConsole].value.b;
}

CompOption * benchGetOutputConsoleOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionOutputConsole];
}

void benchSetOutputConsoleNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionOutputConsole] = notify;
}

int benchGetConsoleUpdateTime (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionConsoleUpdateTime].value.i;
}

CompOption * benchGetConsoleUpdateTimeOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionConsoleUpdateTime];
}

void benchSetConsoleUpdateTimeNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionConsoleUpdateTime] = notify;
}

CompOption * benchGetDisplayOption (CompDisplay *d, BenchDisplayOptions num)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo benchOptionsDisplayOptionInfo[] = {
    { "initiate_key", "key", 0, 0, 0 },
    { "disable_limiter", "bool", 0, 0, 0 },
    { "output_screen", "bool", 0, 0, 0 },
    { "position_x", "int", "<min>0</min><max>4096</max>", 0, 0 },
    { "position_y", "int", "<min>0</min><max>4096</max>", 0, 0 },
    { "output_console", "bool", 0, 0, 0 },
    { "console_update_time", "int", "<min>1</min><max>60</max>", 0, 0 },
};

static Bool benchOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    BENCH_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, BenchDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case BenchDisplayOptionInitiateKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionInitiateKey])
                (*od->notify[BenchDisplayOptionInitiateKey]) (d, o, BenchDisplayOptionInitiateKey);
            return TRUE;
        }
        break;
     case BenchDisplayOptionDisableLimiter:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionDisableLimiter])
                (*od->notify[BenchDisplayOptionDisableLimiter]) (d, o, BenchDisplayOptionDisableLimiter);
            return TRUE;
        }
        break;
     case BenchDisplayOptionOutputScreen:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionOutputScreen])
                (*od->notify[BenchDisplayOptionOutputScreen]) (d, o, BenchDisplayOptionOutputScreen);
            return TRUE;
        }
        break;
     case BenchDisplayOptionPositionX:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionPositionX])
                (*od->notify[BenchDisplayOptionPositionX]) (d, o, BenchDisplayOptionPositionX);
            return TRUE;
        }
        break;
     case BenchDisplayOptionPositionY:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionPositionY])
                (*od->notify[BenchDisplayOptionPositionY]) (d, o, BenchDisplayOptionPositionY);
            return TRUE;
        }
        break;
     case BenchDisplayOptionOutputConsole:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionOutputConsole])
                (*od->notify[BenchDisplayOptionOutputConsole]) (d, o, BenchDisplayOptionOutputConsole);
            return TRUE;
        }
        break;
     case BenchDisplayOptionConsoleUpdateTime:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionConsoleUpdateTime])
                (*od->notify[BenchDisplayOptionConsoleUpdateTime]) (d, o, BenchDisplayOptionConsoleUpdateTime);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * benchOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    BENCH_OPTIONS_DISPLAY(d);
    *count = BenchDisplayOptionNum;
    return od->opt;
}

static Bool benchOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    BenchOptionsScreen *os;
    
    BENCH_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(BenchOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void benchOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    BENCH_OPTIONS_SCREEN (s);

    free (os);
}

static Bool benchOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    BenchOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(BenchOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[BenchOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &benchOptionsMetadata, benchOptionsDisplayOptionInfo, od->opt, BenchDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void benchOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, BenchDisplayOptionNum);

    free (od);
}

static Bool benchOptionsInit (CompPlugin *p)
{
    BenchOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (BenchOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&benchOptionsMetadata, "bench",benchOptionsDisplayOptionInfo, BenchDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&benchOptionsMetadata, "bench");
    if (benchPluginVTable && benchPluginVTable->init)
        return benchPluginVTable->init (p);
    return TRUE;
}

static void benchOptionsFini (CompPlugin *p)
{
    if (benchPluginVTable && benchPluginVTable->fini)
        benchPluginVTable->fini (p);

    if (BenchOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (BenchOptionsDisplayPrivateIndex);

    compFiniMetadata (&benchOptionsMetadata);
}

static CompBool benchOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) benchOptionsInitDisplay,
        (InitPluginObjectProc) benchOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void benchOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) benchOptionsFiniDisplay,
        (FiniPluginObjectProc) benchOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool benchOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = benchOptionsInitObject (p, o);
    if (benchPluginVTable->initObject)
        rv &= benchPluginVTable->initObject (p, o);
    return rv;
}

static void benchOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (benchPluginVTable->finiObject)
        benchPluginVTable->finiObject (p, o);
    benchOptionsFiniObject (p, o);
}

static CompOption * benchOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) benchOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool benchOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) benchOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
benchOptionsGetMetadata (CompPlugin *plugin)
{
    return &benchOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!benchPluginVTable)
    {
        benchPluginVTable = getCompPluginInfo ();
        memcpy(&benchOptionsVTable, benchPluginVTable, sizeof(CompPluginVTable));
        benchOptionsVTable.getMetadata = benchOptionsGetMetadata;
        benchOptionsVTable.init = benchOptionsInit;
        benchOptionsVTable.fini = benchOptionsFini;
        benchOptionsVTable.initObject = benchOptionsInitObjectWrapper;
        benchOptionsVTable.finiObject = benchOptionsFiniObjectWrapper;
        benchOptionsVTable.getObjectOptions = benchOptionsGetObjectOptions;
	benchOptionsVTable.setObjectOption = benchOptionsSetObjectOption;
	
    }
    return &benchOptionsVTable;
}

