/***************************************************************************
 *   Copyright (C) 2007 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "nmapsi4File.h"

nmapsi4File::nmapsi4File() { // contructor = create file if !

	logName = ".nmapsi4rc";

	QFile *config_file = new QFile();
	QDir::setCurrent(QDir::homePath());

	config_file->setFileName(logName);
  	QTextStream *out = new QTextStream(config_file);

	if(!config_file->exists()) {
		config_file->open(QIODevice::WriteOnly | QIODevice::Text);
		this->configBase(out); // call new config file profile
		config_file->close();
	} 

	delete out;
	delete config_file;
}

QString nmapsi4File::readToken(QString config) {

  	QFile *config_file = new QFile();
	QDir::setCurrent(QDir::homePath());
	config_file->setFileName(logName);

	config_file->open(QFile::ReadOnly);

	QTextStream buffer(config_file);

	while(!buffer.atEnd()) {
		QString tmp_token = buffer.readLine().trimmed();

		if(tmp_token.contains(config)) {
			tmp_token.remove(config);
			tmp_token.remove("=");

			config_file->close();
			delete config_file;
			return tmp_token;
		}
	}

	config_file->close();

	delete config_file;
	return NULL;
}

void nmapsi4File::updateToken(QString config, QString newValue) {
	QFile *config_file = new QFile();
	QFile *config_file2 = new QFile(); // new file updated
	QDir::setCurrent(QDir::homePath());

	config_file->setFileName(logName);
	QString test;
	test.append(logName);
	test.append("~");
	config_file->rename(test); // rename old file with ~ extension
	config_file->setFileName(test);

	config_file2->setFileName(logName); // create new configuration file

	config_file->open(QIODevice::ReadOnly | QIODevice::Text);
	config_file2->open(QIODevice::ReadWrite | QIODevice::Text);

	QTextStream buffer(config_file);
	QTextStream buffer2(config_file2);


	while(!buffer.atEnd()) {

  		QString tmp_line = buffer.readLine().trimmed();

		if(tmp_line.contains(config)) {
			QString tmp_token = tmp_line;
			tmp_token.remove(config);
			tmp_token.remove("=");
			tmp_line.replace(tmp_token,newValue.trimmed());

   			buffer2 << tmp_line << endl; // write new line in the new file
		} else {
			buffer2 << tmp_line << endl; // write new option
			buffer2.readLine();
		}
	}

	config_file->remove(); // remove old ~ file

	delete config_file;
	delete config_file2;
}

void nmapsi4File::reloadConfig() {

  	QFile *config_file = new QFile();
	QDir::setCurrent(QDir::homePath());
	config_file->setFileName(logName);

  	QTextStream *stream = new QTextStream(config_file);

	config_file->open(QIODevice::WriteOnly | QIODevice::Text);
	this->configBase(stream); // call new config file profile

	delete stream;
	delete config_file;
}

nmapsi4File::~nmapsi4File() {
	// empty for now ;)
}

