/***************************************************************************
 *   Copyright (C) 2007 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../mainwin.h"

void nmapClass::readProfile() {
    
	this->checkProfile();

	if(checkLog)
		this->fileSession();

}

void nmapClass::resetOptions() {
	versionBox->setChecked(FALSE);
	checkOS->setChecked(FALSE);
	comboTiming->setCurrentIndex(0);
	comboDNSResolv->setCurrentIndex(0);
	comboVerbosity->setCurrentIndex(0);
}

void nmapClass::checkProfile() {

	int uid = 0;

#ifndef Q_WS_WIN
	uid = getuid();
#endif
	nmapsi4File *ptr = new nmapsi4File();
	Profile = ptr->readToken("configProfile");

	if(Profile == NULL) { // for old config
	      ptr->reloadConfig();
	      Profile = ptr->readToken("configProfile");
	}

	lineProfile->setText(Profile);

	if((Profile.contains("fullversion") || Profile.contains("quickversion")) && uid) {
		Profile = "normal"; // reset profile
		ptr->updateToken("configProfile", "normal"); // reset
		lineProfile->setText(Profile);
	}

	if(Profile.contains("quick"))
		this->setQuickProfile();

	if(Profile.contains("normal"))
		this->setNormalProfile();

	if(Profile.contains("fullversion")) {
		this->setFullVersionProfile();
	}

	if(Profile.contains( "quickversion")) {
		this->setQuickVersionProfile();
	}

	logPath = ptr->readToken("confPath"); // read log options

	if(logPath == NULL) {
		ptr->reloadConfig();
		logPath = ptr->readToken("confPath");
	}

	QString log; 
	log = ptr->readToken("logCheck");

	if(log == NULL) {
		ptr->reloadConfig();
		log = ptr->readToken("logCheck");
	}

	if(log.contains("YES"))
		checkLog = TRUE;
	else
		checkLog = FALSE;

	delete ptr;

}

void nmapClass::setQuickProfile() {
	this->resetOptions();
	comboTiming->setCurrentIndex(4);
	comboDNSResolv->setCurrentIndex(2);
	comboVerbosity->setCurrentIndex(1);
}

void nmapClass::setNormalProfile() {
	this->resetOptions();
	comboTiming->setCurrentIndex(4);
	comboDNSResolv->setCurrentIndex(2);
	comboVerbosity->setCurrentIndex(1);
	versionBox->setChecked(TRUE);
}

void nmapClass::setFullVersionProfile() {
	this->resetOptions();
	comboTiming->setCurrentIndex(4);
	checkOS->setChecked(TRUE);
	versionBox->setChecked(TRUE);
	comboVerbosity->setCurrentIndex(1);
	comboDNSResolv->setCurrentIndex(2);
}

void nmapClass::setQuickVersionProfile() {
	this->resetOptions();
	comboTiming->setCurrentIndex(4);
	checkOS->setChecked(TRUE);
	comboDNSResolv->setCurrentIndex(2);
}
