/*
 * mount.nilfs2.h - NILFS mount, declarations
 *
 * mount.nilfs2.h,v 1.6 2007-06-13 02:18:01 koji Exp
 */

#ifndef _MOUNT_NILFS2_H
#define _MOUNT_NILFS2_H

#include <sys/types.h>
#include <signal.h>


#define NILFS2_FS_NAME		"nilfs2"
#define CLEANERD_NAME		"nilfs_cleanerd"
#define PIDFILE_EXT_NAME	".pid"

#define CLEANERD_WAIT_RETRY_COUNT	3
#define CLEANERD_WAIT_RETRY_INTERVAL	2  /* in seconds */


extern int start_cleanerd(const char *, const char *, int *);
extern int stop_cleanerd(const char *);
extern int check_cleanerd(const char *);


#endif /* _MOUNT_NILFS2_H */

/* Local Variables:		*/
/* eval: (c-set-style "linux")	*/
/* End:				*/
