/*
	kshutdowniface.h - KShutdown DCOP interface
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSHUTDOWNIFACE_H__
#define __KSHUTDOWNIFACE_H__

#include <dcopobject.h>

/**
 * @short KShutDown DCOP interface (KShutdownIface).
 * See the KShutDown Handbook (F1) for details.
 */
class KShutdownIface: virtual public DCOPObject
{
	K_DCOP
public:
k_dcop:

	// general actions

	/**
	 * Cancels the current action.
	 */
	virtual ASYNC cancel() = 0;

	/**
	 * Executes the <b>Shut Down</b> action.
	 */
	virtual bool shutDown() = 0;

	/**
	 * @see shutDown
	 */
	virtual bool shutdown() = 0;

	/**
	 * Executes the @b Reboot" action.
	 */
	virtual bool reboot() = 0;

	/**
	 * Executes the <b>Lock Screen</b> action.
	 */
	virtual bool lockScreen() = 0;

	/**
	 * Executes the @b Logout action.
	 */
	virtual bool logout() = 0;

	// misc. functions

	/**
	 * Shows the settings dialog.
	 */
	virtual ASYNC configure() = 0;

	/**
	 * Returns a KShutDown status information as text
	 * (e.g. "Idle", "Busy", "1 minute warning", etc).
	 * Can be used in Karamba themes, for example.
	 */
	virtual QString getStatusInfo() = 0;

	/**
	 * Hides the main window and its system tray icon.
	 */
	virtual void makeInvisible() = 0;

	/**
	 * Shows and raises the main window.
	 * The window will be visible on the current desktop.
	 */
	virtual ASYNC makeVisible() = 0;

	/**
	 * Sets test mode to @p yes.
	 */
	virtual ASYNC setTestMode(bool yes) = 0;
};

#endif // __KSHUTDOWNIFACE_H__
