# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

require 'open-uri'
require 'fileutils'
require 'uri'
require 'nkf'
require 'time'

require 'const.rb'

USER_AGENT = "Monazilla/1.00 (Kita/#{Const::Version})"

module Downloader
  def self.download_menu_list
    str = nil
    open("http://menu.2ch.net/bbsmenu.html") {|f|
      sjis_str = f.read
      str = NKF.nkf("-Swx", sjis_str) # SJIS -> UTF-8 with JISX0201
    }

    dir = ENV['HOME'] + "/.kita/cache/2ch"
    save(dir, "bbsmenu.html", str)
    str
  end

  def self.load_menu_list
    dir = ENV['HOME'] + "/.kita/cache/2ch"
    str = nil

    File.open(dir + "/bbsmenu.html") {|f|
      str = f.read
    }
    str
  end

  def self.download_subject_txt_jbbs(url)
    str = nil
    open(url,
      "User-Agent" => USER_AGENT) {|f|
      euc_str = f.read
      str = NKF.nkf("-Ewx", euc_str) # EUC -> UTF-8 with JISX0201
    }

    board_name = URI.parse(url).path.split("/")[1] + "_" + URI.parse(url).path.split("/")[2]
    host_name = URI.parse(url).host
    dir = ENV['HOME'] + "/.kita/cache/#{host_name}/" + board_name
    save(dir, "subject.txt", str)
    str
  end

  def self.download_subject_txt(url)
    str = nil
    open(url,
      "User-Agent" => USER_AGENT) {|f|
      sjis_str = f.read
      str = NKF.nkf("-Swx", sjis_str) # SJIS -> UTF-8 with JISX0201
    }

    board_name = URI.parse(url).path.split("/")[1]
    dir = ENV['HOME'] + "/.kita/cache/2ch/" + board_name
    save(dir, "subject.txt", str)
    str
  end

  def self.download_dat(dat_url)
    str = nil
    date = nil

    Net::HTTP.start(URI.parse(dat_url).host, 80) {|http|
      header = {
        "User-Agent" => USER_AGENT
      }
      response = http.get(URI.parse(dat_url).path, header)

      raw_str = response.body
      str = Util.to_utf8(raw_str, Util.board_type(dat_url))

      date = response['Date']
    }

    dir = Util.dat_url_to_dat_dir_path(dat_url)
    dat_file_name = Util.dat_url_to_dat_file_name(dat_url)
    save_date(dir, dat_file_name + ".idx", date)
    save(dir, dat_file_name, str)
    str
  end

  def self.load_dat(dat_url)
    dir = Util.dat_url_to_dat_dir_path(dat_url)
    dat_file_name = Util.dat_url_to_dat_file_name(dat_url)
    str = nil

    File.open(dir + "/" + dat_file_name) {|f|
      str = f.read
    }
    str
  end

  def self.save(dir, file, str)
    FileUtils.mkdir_p(dir)
    File.open(dir + "/" + file, "w") {|f|
      f.puts(str)
    }
  end

  def self.save_date(dir, file, date_str)
    time = Time::parse(date_str).to_i

    FileUtils.mkdir_p(dir)
    config = KDE::Config.new(dir + "/" + file)
    config.writeEntry("Date", time)
    config.sync
  end
end
