/***************************************************************************
 *   Copyright (C) 2004-2005 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qapplication.h>
#include <qfile.h>
#include <qstring.h>
#include <qspinbox.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <klineedit.h>
#include <kdebug.h>
#include <kio/netaccess.h>
#include <kurl.h>

#include <fileimporterbibtex.h>
#include "webquerybibsonomy.h"

namespace KBibTeX
{

    WebQueryBibSonomy::WebQueryBibSonomy( QWidget* parent, const char* name ): WebQuery( parent, name )
    {
        m_wizard = new WebQueryWizardBibSonomy( title(), parent, name );
    }

    WebQueryBibSonomy::~WebQueryBibSonomy()
    {
        delete m_wizard;
    }

    BibTeX::File* WebQueryBibSonomy::query( )
    {
        if ( m_wizard->exec() == QDialog::Accepted )
            return m_wizard->result();
        else
            return NULL;
    }

    int WebQueryBibSonomy::uniqueId()
    {
        return 0x0532ab9c;
    }

    QString WebQueryBibSonomy::title()
    {
        return i18n( "BibSonomy" );
    }

    WebQueryWizardBibSonomy::WebQueryWizardBibSonomy( const QString& caption, QWidget* parent, const char* name ): WebQueryWizard( caption, i18n( "BibSonomy - A social bookmark and publication sharing system" ), "http://www.bibsonomy.org/", FALSE, TRUE, parent, name )
    {
// nothing
    }

    WebQueryWizardBibSonomy::~WebQueryWizardBibSonomy()
    {
// nothing
    }

    void WebQueryWizardBibSonomy::startSearch()
    {
        setEnabled( FALSE );
        QApplication::setOverrideCursor( Qt::waitCursor );
        m_listViewResults->clear();

        KURL url = KURL( QString( "http://www.bibsonomy.org/bib/search/%1?items=%2" ).arg( m_lineEditQuery->text().replace( "%", "%25" ).replace( " ", "+" ).replace("?","%3F" ).replace("&","%26" ) ).arg( m_spinBoxMaxHits->text() ) );
        QString tmpFile;
        if ( KIO::NetAccess::download( url, tmpFile, NULL ) )
        {
            BibTeX::FileImporterBibTeX importer( FALSE );
            importer.setIgnoreComments( TRUE );
            QFile inputFile( tmpFile );
            inputFile.open( IO_ReadOnly );
            BibTeX::File *tmpBibFile = importer.load( &inputFile );
            inputFile.close();
            KIO::NetAccess::removeTempFile( tmpFile );

            for ( BibTeX::File::ElementList::iterator it = tmpBibFile->begin(); it != tmpBibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                    new ResultsListViewItem( m_listViewResults, new BibTeX::Entry( entry ) );
            }

            delete tmpBibFile;
        }
        else
            KMessageBox::error( this, KIO::NetAccess::lastErrorString() );

        setEnabled( TRUE );
        QApplication::restoreOverrideCursor();
    }
}
