/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _TILE_OPTIONS_INTERNAL
#include "tile_options.h"

static int displayPrivateIndex;

static CompMetadata tileOptionsMetadata;

static CompPluginVTable *tilePluginVTable = NULL;
CompPluginVTable tileOptionsVTable;

#define GET_TILE_OPTIONS_DISPLAY(d) \
        ((TileOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define TILE_OPTIONS_DISPLAY(d) \
        TileOptionsDisplay *od = GET_TILE_OPTIONS_DISPLAY (d)

#define GET_TILE_OPTIONS_SCREEN(s, od) \
        ((TileOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define TILE_OPTIONS_SCREEN(s) \
        TileOptionsScreen *os = GET_TILE_OPTIONS_SCREEN (s, GET_TILE_OPTIONS_DISPLAY (s->display))

typedef struct _TileOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[TileDisplayOptionNum];
    tileDisplayOptionChangeNotifyProc notify[TileDisplayOptionNum];
} TileOptionsDisplay;

typedef struct _TileOptionsScreen
{
} TileOptionsScreen;

int tileGetAnimateType (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionAnimateType].value.i;
}

CompOption * tileGetAnimateTypeOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionAnimateType];
}

void tileSetAnimateTypeNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionAnimateType] = notify;
}

int tileGetAnimationDuration (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionAnimationDuration].value.i;
}

CompOption * tileGetAnimationDurationOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionAnimationDuration];
}

void tileSetAnimationDurationNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionAnimationDuration] = notify;
}

int tileGetTileToggleType (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionTileToggleType].value.i;
}

CompOption * tileGetTileToggleTypeOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileToggleType];
}

void tileSetTileToggleTypeNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileToggleType] = notify;
}

Bool tileGetTileJoin (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionTileJoin].value.b;
}

CompOption * tileGetTileJoinOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileJoin];
}

void tileSetTileJoinNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileJoin] = notify;
}

int tileGetTileDelta (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionTileDelta].value.i;
}

CompOption * tileGetTileDeltaOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileDelta];
}

void tileSetTileDeltaNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileDelta] = notify;
}

int tileGetTileLeftOccupancy (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionTileLeftOccupancy].value.i;
}

CompOption * tileGetTileLeftOccupancyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileLeftOccupancy];
}

void tileSetTileLeftOccupancyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileLeftOccupancy] = notify;
}

CompMatch * tileGetExcludeMatch (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionExcludeMatch].value.match;
}

CompOption * tileGetExcludeMatchOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionExcludeMatch];
}

void tileSetExcludeMatchNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionExcludeMatch] = notify;
}

CompAction * tileGetTileVertically (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileVertically].value.action;
}

void tileSetTileVerticallyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileVertically].value.action.initiate = init;
}

void tileSetTileVerticallyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileVertically].value.action.terminate = term;
}

CompOption * tileGetTileVerticallyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileVertically];
}

void tileSetTileVerticallyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileVertically] = notify;
}

CompAction * tileGetTileHorizontally (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileHorizontally].value.action;
}

void tileSetTileHorizontallyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileHorizontally].value.action.initiate = init;
}

void tileSetTileHorizontallyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileHorizontally].value.action.terminate = term;
}

CompOption * tileGetTileHorizontallyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileHorizontally];
}

void tileSetTileHorizontallyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileHorizontally] = notify;
}

CompAction * tileGetTileTile (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileTile].value.action;
}

void tileSetTileTileInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileTile].value.action.initiate = init;
}

void tileSetTileTileTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileTile].value.action.terminate = term;
}

CompOption * tileGetTileTileOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileTile];
}

void tileSetTileTileNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileTile] = notify;
}

CompAction * tileGetTileCascade (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileCascade].value.action;
}

void tileSetTileCascadeInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileCascade].value.action.initiate = init;
}

void tileSetTileCascadeTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileCascade].value.action.terminate = term;
}

CompOption * tileGetTileCascadeOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileCascade];
}

void tileSetTileCascadeNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileCascade] = notify;
}

CompAction * tileGetTileRestore (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileRestore].value.action;
}

void tileSetTileRestoreInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileRestore].value.action.initiate = init;
}

void tileSetTileRestoreTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileRestore].value.action.terminate = term;
}

CompOption * tileGetTileRestoreOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileRestore];
}

void tileSetTileRestoreNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileRestore] = notify;
}

CompAction * tileGetTileToggle (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileToggle].value.action;
}

void tileSetTileToggleInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileToggle].value.action.initiate = init;
}

void tileSetTileToggleTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileToggle].value.action.terminate = term;
}

CompOption * tileGetTileToggleOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileToggle];
}

void tileSetTileToggleNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileToggle] = notify;
}

CompOption * tileGetDisplayOption (CompDisplay *d, TileDisplayOptions num)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo tileOptionsDisplayOptionInfo[] = {
    { "animate_type", "int", "<min>0</min><max>5</max>", 0, 0 },
    { "animation_duration", "int", "<min>100</min><max>2000</max>", 0, 0 },
    { "tile_toggle_type", "int", "<min>0</min><max>4</max>", 0, 0 },
    { "tile_join", "bool", 0, 0, 0 },
    { "tile_delta", "int", "<min>0</min><max>250</max>", 0, 0 },
    { "tile_left_occupancy", "int", "<min>20</min><max>80</max>", 0, 0 },
    { "exclude_match", "match", 0, 0, 0 },
    { "tile_vertically", "action", 0, 0, 0 },
    { "tile_horizontally", "action", 0, 0, 0 },
    { "tile_tile", "action", 0, 0, 0 },
    { "tile_cascade", "action", 0, 0, 0 },
    { "tile_restore", "action", 0, 0, 0 },
    { "tile_toggle", "action", 0, 0, 0 },
};

static Bool tileOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    TILE_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, TileDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case TileDisplayOptionAnimateType:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionAnimateType])
                (*od->notify[TileDisplayOptionAnimateType]) (d, o, TileDisplayOptionAnimateType);
            return TRUE;
        }
        break;
     case TileDisplayOptionAnimationDuration:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionAnimationDuration])
                (*od->notify[TileDisplayOptionAnimationDuration]) (d, o, TileDisplayOptionAnimationDuration);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileToggleType:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileToggleType])
                (*od->notify[TileDisplayOptionTileToggleType]) (d, o, TileDisplayOptionTileToggleType);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileJoin:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileJoin])
                (*od->notify[TileDisplayOptionTileJoin]) (d, o, TileDisplayOptionTileJoin);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileDelta:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileDelta])
                (*od->notify[TileDisplayOptionTileDelta]) (d, o, TileDisplayOptionTileDelta);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileLeftOccupancy:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileLeftOccupancy])
                (*od->notify[TileDisplayOptionTileLeftOccupancy]) (d, o, TileDisplayOptionTileLeftOccupancy);
            return TRUE;
        }
        break;
     case TileDisplayOptionExcludeMatch:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionExcludeMatch])
                (*od->notify[TileDisplayOptionExcludeMatch]) (d, o, TileDisplayOptionExcludeMatch);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileVertically:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileVertically])
                (*od->notify[TileDisplayOptionTileVertically]) (d, o, TileDisplayOptionTileVertically);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileHorizontally:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileHorizontally])
                (*od->notify[TileDisplayOptionTileHorizontally]) (d, o, TileDisplayOptionTileHorizontally);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileTile:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileTile])
                (*od->notify[TileDisplayOptionTileTile]) (d, o, TileDisplayOptionTileTile);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileCascade:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileCascade])
                (*od->notify[TileDisplayOptionTileCascade]) (d, o, TileDisplayOptionTileCascade);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileRestore:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileRestore])
                (*od->notify[TileDisplayOptionTileRestore]) (d, o, TileDisplayOptionTileRestore);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileToggle:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileToggle])
                (*od->notify[TileDisplayOptionTileToggle]) (d, o, TileDisplayOptionTileToggle);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * tileOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    TILE_OPTIONS_DISPLAY(d);
    *count = TileDisplayOptionNum;
    return od->opt;
}

static Bool tileOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    TileOptionsScreen *os;
    
    TILE_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(TileOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

        if (tilePluginVTable && tilePluginVTable->initScreen)
        return tilePluginVTable->initScreen (p, s);
    return TRUE;
}

static void tileOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (tilePluginVTable && tilePluginVTable->finiScreen)
        return tilePluginVTable->finiScreen (p, s);

    TILE_OPTIONS_SCREEN (s);

    free (os);
}

static Bool tileOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    TileOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(TileOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &tileOptionsMetadata, tileOptionsDisplayOptionInfo, od->opt, TileDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (tilePluginVTable && tilePluginVTable->initDisplay)
        return tilePluginVTable->initDisplay (p, d);
    return TRUE;
}

static void tileOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (tilePluginVTable && tilePluginVTable->finiDisplay)
        return tilePluginVTable->finiDisplay (p, d);

    TILE_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, TileDisplayOptionNum);

    free (od);
}

static Bool tileOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&tileOptionsMetadata, "tile",tileOptionsDisplayOptionInfo, TileDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&tileOptionsMetadata, "tile");
    if (tilePluginVTable && tilePluginVTable->init)
        return tilePluginVTable->init (p);
    return TRUE;
}

static void tileOptionsFini (CompPlugin *p)
{
    if (tilePluginVTable && tilePluginVTable->fini)
        return tilePluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&tileOptionsMetadata);
}

static CompMetadata *
tileOptionsGetMetadata (CompPlugin *plugin)
{
    return &tileOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!tilePluginVTable)
    {
        tilePluginVTable = tileOptionsGetCompPluginInfo ();
        memcpy(&tileOptionsVTable, tilePluginVTable, sizeof(CompPluginVTable));
        tileOptionsVTable.getMetadata = tileOptionsGetMetadata;
        tileOptionsVTable.init = tileOptionsInit;
        tileOptionsVTable.fini = tileOptionsFini;
        tileOptionsVTable.initDisplay = tileOptionsInitDisplay;
        tileOptionsVTable.finiDisplay = tileOptionsFiniDisplay;
        tileOptionsVTable.initScreen = tileOptionsInitScreen;
        tileOptionsVTable.finiScreen = tileOptionsFiniScreen;
        tileOptionsVTable.getDisplayOptions = tileOptionsGetDisplayOptions;
	tileOptionsVTable.setDisplayOption = tileOptionsSetDisplayOption;
	
    }
    return &tileOptionsVTable;
}

