/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _MSWITCH_OPTIONS_INTERNAL
#include "mswitch_options.h"

static int displayPrivateIndex;

static CompMetadata mswitchOptionsMetadata;

static CompPluginVTable *mswitchPluginVTable = NULL;
CompPluginVTable mswitchOptionsVTable;

#define GET_MSWITCH_OPTIONS_DISPLAY(d) \
        ((MswitchOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define MSWITCH_OPTIONS_DISPLAY(d) \
        MswitchOptionsDisplay *od = GET_MSWITCH_OPTIONS_DISPLAY (d)

#define GET_MSWITCH_OPTIONS_SCREEN(s, od) \
        ((MswitchOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define MSWITCH_OPTIONS_SCREEN(s) \
        MswitchOptionsScreen *os = GET_MSWITCH_OPTIONS_SCREEN (s, GET_MSWITCH_OPTIONS_DISPLAY (s->display))

typedef struct _MswitchOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[MswitchDisplayOptionNum];
    mswitchDisplayOptionChangeNotifyProc notify[MswitchDisplayOptionNum];
} MswitchOptionsDisplay;

typedef struct _MswitchOptionsScreen
{
} MswitchOptionsScreen;

CompAction * mswitchGetBegin (CompDisplay *d)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    return &od->opt[MswitchDisplayOptionBegin].value.action;
}

void mswitchSetBeginInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->opt[MswitchDisplayOptionBegin].value.action.initiate = init;
}

void mswitchSetBeginTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->opt[MswitchDisplayOptionBegin].value.action.terminate = term;
}

CompOption * mswitchGetBeginOption (CompDisplay *d)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    return &od->opt[MswitchDisplayOptionBegin];
}

void mswitchSetBeginNotify (CompDisplay *d, mswitchDisplayOptionChangeNotifyProc notify)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    od->notify[MswitchDisplayOptionBegin] = notify;
}

CompOption * mswitchGetDisplayOption (CompDisplay *d, MswitchDisplayOptions num)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo mswitchOptionsDisplayOptionInfo[] = {
    { "begin", "action", 0, 0, 0 },
};

static Bool mswitchOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, MswitchDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case MswitchDisplayOptionBegin:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MswitchDisplayOptionBegin])
                (*od->notify[MswitchDisplayOptionBegin]) (d, o, MswitchDisplayOptionBegin);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * mswitchOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    MSWITCH_OPTIONS_DISPLAY(d);
    *count = MswitchDisplayOptionNum;
    return od->opt;
}

static Bool mswitchOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    MswitchOptionsScreen *os;
    
    MSWITCH_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(MswitchOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

        if (mswitchPluginVTable && mswitchPluginVTable->initScreen)
        return mswitchPluginVTable->initScreen (p, s);
    return TRUE;
}

static void mswitchOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (mswitchPluginVTable && mswitchPluginVTable->finiScreen)
        return mswitchPluginVTable->finiScreen (p, s);

    MSWITCH_OPTIONS_SCREEN (s);

    free (os);
}

static Bool mswitchOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    MswitchOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(MswitchOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &mswitchOptionsMetadata, mswitchOptionsDisplayOptionInfo, od->opt, MswitchDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (mswitchPluginVTable && mswitchPluginVTable->initDisplay)
        return mswitchPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void mswitchOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (mswitchPluginVTable && mswitchPluginVTable->finiDisplay)
        return mswitchPluginVTable->finiDisplay (p, d);

    MSWITCH_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, MswitchDisplayOptionNum);

    free (od);
}

static Bool mswitchOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&mswitchOptionsMetadata, "mswitch",mswitchOptionsDisplayOptionInfo, MswitchDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&mswitchOptionsMetadata, "mswitch");
    if (mswitchPluginVTable && mswitchPluginVTable->init)
        return mswitchPluginVTable->init (p);
    return TRUE;
}

static void mswitchOptionsFini (CompPlugin *p)
{
    if (mswitchPluginVTable && mswitchPluginVTable->fini)
        return mswitchPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&mswitchOptionsMetadata);
}

static CompMetadata *
mswitchOptionsGetMetadata (CompPlugin *plugin)
{
    return &mswitchOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!mswitchPluginVTable)
    {
        mswitchPluginVTable = mswitchOptionsGetCompPluginInfo ();
        memcpy(&mswitchOptionsVTable, mswitchPluginVTable, sizeof(CompPluginVTable));
        mswitchOptionsVTable.getMetadata = mswitchOptionsGetMetadata;
        mswitchOptionsVTable.init = mswitchOptionsInit;
        mswitchOptionsVTable.fini = mswitchOptionsFini;
        mswitchOptionsVTable.initDisplay = mswitchOptionsInitDisplay;
        mswitchOptionsVTable.finiDisplay = mswitchOptionsFiniDisplay;
        mswitchOptionsVTable.initScreen = mswitchOptionsInitScreen;
        mswitchOptionsVTable.finiScreen = mswitchOptionsFiniScreen;
        mswitchOptionsVTable.getDisplayOptions = mswitchOptionsGetDisplayOptions;
	mswitchOptionsVTable.setDisplayOption = mswitchOptionsSetDisplayOption;
	
    }
    return &mswitchOptionsVTable;
}

